/*
 * Decompiled with CFR 0.152.
 */
package net.perpetualeve.deeppouches.network;

import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import net.perpetualeve.deeppouches.DeepPouches;
import net.perpetualeve.deeppouches.network.DPPacket;

public class DPConfigSyncPacket
implements DPPacket {
    int alpha_slots;
    int beta_slots;
    Set<Item> alpha_items;
    Set<Item> beta_items;

    public DPConfigSyncPacket(int alpha_slots, int beta_slots, Set<Item> alpha_items, Set<Item> beta_items) {
        this.alpha_slots = alpha_slots;
        this.beta_slots = beta_slots;
        this.alpha_items = alpha_items;
        this.beta_items = beta_items;
    }

    public DPConfigSyncPacket() {
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.alpha_slots);
        buf.writeInt(this.beta_slots);
        buf.writeInt(this.alpha_items.size());
        for (Item item : this.alpha_items) {
            buf.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, (Object)item);
        }
        buf.writeInt(this.beta_items.size());
        for (Item item : this.beta_items) {
            buf.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, (Object)item);
        }
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        int i;
        this.alpha_slots = buf.readInt();
        this.beta_slots = buf.readInt();
        int num = buf.readInt();
        for (i = 0; i < num; ++i) {
            this.alpha_items.add((Item)buf.readRegistryIdUnsafe(ForgeRegistries.ITEMS));
        }
        num = buf.readInt();
        for (i = 0; i < num; ++i) {
            this.beta_items.add((Item)buf.readRegistryIdUnsafe(ForgeRegistries.ITEMS));
        }
    }

    @Override
    public void handlePacket(Player player) {
        DeepPouches.alpha_slots = this.alpha_slots;
        DeepPouches.beta_slots = this.beta_slots;
        DeepPouches.alpha_items = this.alpha_items;
        DeepPouches.beta_items = this.beta_items;
    }
}

