/*
 * Decompiled with CFR 0.152.
 */
package net.perpetualeve.deeppouches.item;

import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PouchItemStackHandler
implements IItemHandler,
IItemHandlerModifiable,
ICapabilityProvider {
    private final ItemStack stack;
    private final LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this);
    private int size = 5;
    private CompoundTag cachedTag;
    private NonNullList<ItemStack> itemStacksCache;

    public PouchItemStackHandler(ItemStack stack, int size) {
        this.stack = stack;
        this.size = size;
    }

    public int getSlots() {
        return this.size;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return (ItemStack)this.getItemList().get(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        NonNullList<ItemStack> itemStacks = this.getItemList();
        ItemStack existing = (ItemStack)itemStacks.get(slot);
        int limit = this.getSlotLimit(slot);
        if (!existing.m_41619_()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.m_41613_();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.m_41613_() > limit;
        if (!simulate) {
            if (existing.m_41619_()) {
                itemStacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
            } else {
                existing.m_41769_(reachedLimit ? limit : stack.m_41613_());
            }
            this.setItemList(itemStacks);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - limit)) : ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        NonNullList<ItemStack> itemStacks = this.getItemList();
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)itemStacks.get(slot);
        if (existing.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int toExtract = amount;
        if (existing.m_41613_() <= toExtract) {
            if (!simulate) {
                itemStacks.set(slot, (Object)ItemStack.f_41583_);
                this.setItemList(itemStacks);
                return existing;
            }
            return existing.m_41777_();
        }
        if (!simulate) {
            itemStacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract)));
            this.setItemList(itemStacks);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    private void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return stack.m_41720_().m_142095_();
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.validateSlotIndex(slot);
        if (!this.isItemValid(slot, stack)) {
            throw new RuntimeException("Invalid stack " + stack + " for slot " + slot + ")");
        }
        NonNullList<ItemStack> itemStacks = this.getItemList();
        itemStacks.set(slot, (Object)stack);
        this.setItemList(itemStacks);
    }

    private NonNullList<ItemStack> getItemList() {
        CompoundTag rootTag = this.stack.m_41737_("Inventory");
        if (this.cachedTag == null || !this.cachedTag.equals((Object)rootTag)) {
            this.itemStacksCache = this.refreshItemList(rootTag);
        }
        return this.itemStacksCache;
    }

    private NonNullList<ItemStack> refreshItemList(CompoundTag rootTag) {
        NonNullList itemStacks = NonNullList.m_122780_((int)this.getSlots(), (Object)ItemStack.f_41583_);
        if (rootTag != null && rootTag.m_128425_("Items", 9)) {
            PouchItemStackHandler.loadAllItems(rootTag, (NonNullList<ItemStack>)itemStacks);
        }
        this.cachedTag = rootTag;
        return itemStacks;
    }

    public static CompoundTag saveAllItems(CompoundTag p_18977_, NonNullList<ItemStack> p_18978_, boolean p_18979_) {
        ListTag listtag = new ListTag();
        for (int i = 0; i < p_18978_.size(); ++i) {
            ItemStack itemstack = (ItemStack)p_18978_.get(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(compoundtag);
            compoundtag.m_128405_("iSize", itemstack.m_41613_());
            listtag.add((Object)compoundtag);
        }
        if (!listtag.isEmpty() || p_18979_) {
            p_18977_.m_128365_("Items", (Tag)listtag);
        }
        return p_18977_;
    }

    public static void loadAllItems(CompoundTag p_18981_, NonNullList<ItemStack> p_18982_) {
        ListTag listtag = p_18981_.m_128437_("Items", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            int j = compoundtag.m_128445_("Slot") & 0xFF;
            if (j < 0 || j >= p_18982_.size()) continue;
            ItemStack stack = ItemStack.m_41712_((CompoundTag)compoundtag);
            stack.m_41764_(compoundtag.m_128451_("iSize"));
            p_18982_.set(j, (Object)stack);
        }
    }

    private void setItemList(NonNullList<ItemStack> itemStacks) {
        CompoundTag existing = this.stack.m_41737_("Inventory");
        CompoundTag rootTag = PouchItemStackHandler.saveAllItems(existing == null ? new CompoundTag() : existing, itemStacks, true);
        this.setData(this.stack, rootTag);
        this.cachedTag = rootTag;
    }

    private void setData(ItemStack p_186339_, CompoundTag p_186341_) {
        if (p_186341_.m_128456_()) {
            p_186339_.m_41749_("Inventory");
        } else {
            p_186339_.m_41700_("Inventory", (Tag)p_186341_);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.holder);
    }
}

