/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.network.message;

import de.markusbordihn.dailyrewards.data.RewardClientData;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageUserRewardsForCurrentMonth {
    protected static final Logger log = LogManager.getLogger((String)"Daily Rewards");
    protected final CompoundTag data;
    protected final int rewardedDays;
    protected final String lastRewardedDay;

    public MessageUserRewardsForCurrentMonth(CompoundTag data, int rewardedDays, String lastRewardedDay) {
        this.data = data;
        this.rewardedDays = rewardedDays;
        this.lastRewardedDay = lastRewardedDay;
    }

    public CompoundTag getData() {
        return this.data;
    }

    public int getRewardedDays() {
        return this.rewardedDays;
    }

    public String getLastRewardedDay() {
        return this.lastRewardedDay;
    }

    public static void handle(MessageUserRewardsForCurrentMonth message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MessageUserRewardsForCurrentMonth.handlePacket(message)));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageUserRewardsForCurrentMonth message) {
        RewardClientData.setUserRewardsForCurrentMonth(message.getData());
        RewardClientData.setRewardedDaysForCurrentMonth(message.getRewardedDays());
        RewardClientData.setLastRewardedDayForCurrentMonth(message.getLastRewardedDay());
    }
}

