/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Couple;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraftforge.client.gui.ScreenUtils;

public class UIRenderHelper {
    public static CustomRenderTarget framebuffer;

    public static void init() {
        RenderSystem.m_69879_(() -> {
            Window mainWindow = Minecraft.m_91087_().m_91268_();
            framebuffer = CustomRenderTarget.create(mainWindow);
        });
    }

    public static void updateWindowSize(Window mainWindow) {
        if (framebuffer != null) {
            framebuffer.m_83941_(mainWindow.m_85441_(), mainWindow.m_85442_(), Minecraft.f_91002_);
        }
    }

    public static void drawFramebuffer(float alpha) {
        framebuffer.renderWithAlpha(alpha);
    }

    public static void swapAndBlitColor(RenderTarget src, RenderTarget dst) {
        GlStateManager.m_84486_((int)36008, (int)src.f_83920_);
        GlStateManager.m_84486_((int)36009, (int)dst.f_83920_);
        GlStateManager.m_84188_((int)0, (int)0, (int)src.f_83917_, (int)src.f_83918_, (int)0, (int)0, (int)dst.f_83917_, (int)dst.f_83918_, (int)16384, (int)9729);
        GlStateManager.m_84486_((int)36160, (int)dst.f_83920_);
    }

    public static void streak(PoseStack ms, float angle, int x, int y, int breadth, int length) {
        UIRenderHelper.streak(ms, angle, x, y, breadth, length, Theme.i(Theme.Key.STREAK));
    }

    public static void streak(PoseStack ms, float angle, int x, int y, int breadth, int length, int color) {
        int a1 = -1610612736;
        int a2 = Integer.MIN_VALUE;
        int a3 = 0x10000000;
        int a4 = 0;
        int c1 = a1 | (color &= 0xFFFFFF);
        int c2 = a2 | color;
        int c3 = a3 | color;
        int c4 = a4 | color;
        ms.m_85836_();
        ms.m_85837_((double)x, (double)y, 0.0);
        ms.m_85845_(Vector3f.f_122227_.m_122240_(angle - 90.0f));
        UIRenderHelper.streak(ms, breadth / 2, length, c1, c2, c3, c4);
        ms.m_85849_();
    }

    public static void streak(PoseStack ms, float angle, int x, int y, int breadth, int length, Color c) {
        Color color = c.copy().setImmutable();
        int c1 = color.scaleAlpha(0.625f).getRGB();
        int c2 = color.scaleAlpha(0.5f).getRGB();
        int c3 = color.scaleAlpha(0.0625f).getRGB();
        int c4 = color.scaleAlpha(0.0f).getRGB();
        ms.m_85836_();
        ms.m_85837_((double)x, (double)y, 0.0);
        ms.m_85845_(Vector3f.f_122227_.m_122240_(angle - 90.0f));
        UIRenderHelper.streak(ms, breadth / 2, length, c1, c2, c3, c4);
        ms.m_85849_();
    }

    private static void streak(PoseStack ms, int width, int height, int c1, int c2, int c3, int c4) {
        double split1 = 0.5;
        double split2 = 0.75;
        Matrix4f model = ms.m_85850_().m_85861_();
        ScreenUtils.drawGradientRect((Matrix4f)model, (int)0, (int)(-width), (int)0, (int)width, (int)((int)(split1 * (double)height)), (int)c1, (int)c2);
        ScreenUtils.drawGradientRect((Matrix4f)model, (int)0, (int)(-width), (int)((int)(split1 * (double)height)), (int)width, (int)((int)(split2 * (double)height)), (int)c2, (int)c3);
        ScreenUtils.drawGradientRect((Matrix4f)model, (int)0, (int)(-width), (int)((int)(split2 * (double)height)), (int)width, (int)height, (int)c3, (int)c4);
    }

    public static void angledGradient(@Nonnull PoseStack ms, float angle, int x, int y, int breadth, int length, Couple<Color> c) {
        UIRenderHelper.angledGradient(ms, angle, x, y, 0, breadth, length, c);
    }

    public static void angledGradient(@Nonnull PoseStack ms, float angle, int x, int y, int z, int breadth, int length, Couple<Color> c) {
        UIRenderHelper.angledGradient(ms, angle, x, y, z, breadth, length, (Color)c.getFirst(), (Color)c.getSecond());
    }

    public static void angledGradient(@Nonnull PoseStack ms, float angle, int x, int y, int breadth, int length, Color color1, Color color2) {
        UIRenderHelper.angledGradient(ms, angle, x, y, 0, breadth, length, color1, color2);
    }

    public static void angledGradient(@Nonnull PoseStack ms, float angle, int x, int y, int z, int breadth, int length, Color color1, Color color2) {
        ms.m_85836_();
        ms.m_85837_((double)x, (double)y, (double)z);
        ms.m_85845_(Vector3f.f_122227_.m_122240_(angle - 90.0f));
        Matrix4f model = ms.m_85850_().m_85861_();
        int w = breadth / 2;
        ScreenUtils.drawGradientRect((Matrix4f)model, (int)0, (int)(-w), (int)0, (int)w, (int)length, (int)color1.getRGB(), (int)color2.getRGB());
        ms.m_85849_();
    }

    public static void breadcrumbArrow(PoseStack matrixStack, int x, int y, int z, int width, int height, int indent, Couple<Color> colors) {
        UIRenderHelper.breadcrumbArrow(matrixStack, x, y, z, width, height, indent, (Color)colors.getFirst(), (Color)colors.getSecond());
    }

    public static void breadcrumbArrow(PoseStack matrixStack, int x, int y, int z, int width, int height, int indent, Color startColor, Color endColor) {
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(x - indent), (double)y, (double)z);
        UIRenderHelper.breadcrumbArrow(matrixStack, width, height, indent, startColor, endColor);
        matrixStack.m_85849_();
    }

    private static void breadcrumbArrow(PoseStack ms, int width, int height, int indent, Color c1, Color c2) {
        float x0 = 0.0f;
        float y0 = (float)height / 2.0f;
        float x1 = indent;
        float y1 = 0.0f;
        float x2 = indent;
        float y2 = (float)height / 2.0f;
        float x3 = indent;
        float y3 = height;
        float x4 = width;
        float y4 = 0.0f;
        float x5 = width;
        float y5 = (float)height / 2.0f;
        float x6 = width;
        float y6 = height;
        float x7 = indent + width;
        float y7 = 0.0f;
        float x8 = indent + width;
        float y8 = height;
        indent = Math.abs(indent);
        width = Math.abs(width);
        Color fc1 = Color.mixColors(c1, c2, 0.0f);
        Color fc2 = Color.mixColors(c1, c2, (float)indent / ((float)width + 2.0f * (float)indent));
        Color fc3 = Color.mixColors(c1, c2, (float)(indent + width) / ((float)width + 2.0f * (float)indent));
        Color fc4 = Color.mixColors(c1, c2, 1.0f);
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69464_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        Matrix4f model = ms.m_85850_().m_85861_();
        bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_85982_(model, x0, y0, 0.0f).m_6122_(fc1.getRed(), fc1.getGreen(), fc1.getBlue(), fc1.getAlpha()).m_5752_();
        bufferbuilder.m_85982_(model, x1, y1, 0.0f).m_6122_(fc2.getRed(), fc2.getGreen(), fc2.getBlue(), fc2.getAlpha()).m_5752_();
        bufferbuilder.m_85982_(model, x2, y2, 0.0f).m_6122_(fc2.getRed(), fc2.getGreen(), fc2.getBlue(), fc2.getAlpha()).m_5752_();
        bufferbuilder.m_85982_(model, x0, y0, 0.0f).m_6122_(fc1.getRed(), fc1.getGreen(), fc1.getBlue(), fc1.getAlpha()).m_5752_();
        bufferbuilder.m_85982_(model, x2, y2, 0.0f).m_6122_(fc2.getRed(), fc2.getGreen(), fc2.getBlue(), fc2.getAlpha()).m_5752_();
        bufferbuilder.m_85982_(model, x3, y3, 0.0f).m_6122_(fc2.getRed(), fc2.getGreen(), fc2.getBlue(), fc2.getAlpha()).m_5752_();
        bufferbuilder.m_85982_(model, x3, y3, 0.0f).m_6122_(fc2.getRed(), fc2.getGreen(), fc2.getBlue(), fc2.getAlpha()).m_5752_();
        bufferbuilder.m_85982_(model, x1, y1, 0.0f).m_6122_(fc2.getRed(), fc2.getGreen(), fc2.getBlue(), fc2.getAlpha()).m_5752_();
        bufferbuilder.m_85982_(model, x4, y4, 0.0f).m_6122_(fc3.getRed(), fc3.getGreen(), fc3.getBlue(), fc3.getAlpha()).m_5752_();
        bufferbuilder.m_85982_(model, x3, y3, 0.0f).m_6122_(fc2.getRed(), fc2.getGreen(), fc2.getBlue(), fc2.getAlpha()).m_5752_();
        bufferbuilder.m_85982_(model, x4, y4, 0.0f).m_6122_(fc3.getRed(), fc3.getGreen(), fc3.getBlue(), fc3.getAlpha()).m_5752_();
        bufferbuilder.m_85982_(model, x6, y6, 0.0f).m_6122_(fc3.getRed(), fc3.getGreen(), fc3.getBlue(), fc3.getAlpha()).m_5752_();
        bufferbuilder.m_85982_(model, x5, y5, 0.0f).m_6122_(fc3.getRed(), fc3.getGreen(), fc3.getBlue(), fc3.getAlpha()).m_5752_();
        bufferbuilder.m_85982_(model, x4, y4, 0.0f).m_6122_(fc3.getRed(), fc3.getGreen(), fc3.getBlue(), fc3.getAlpha()).m_5752_();
        bufferbuilder.m_85982_(model, x7, y7, 0.0f).m_6122_(fc4.getRed(), fc4.getGreen(), fc4.getBlue(), fc4.getAlpha()).m_5752_();
        bufferbuilder.m_85982_(model, x6, y6, 0.0f).m_6122_(fc3.getRed(), fc3.getGreen(), fc3.getBlue(), fc3.getAlpha()).m_5752_();
        bufferbuilder.m_85982_(model, x5, y5, 0.0f).m_6122_(fc3.getRed(), fc3.getGreen(), fc3.getBlue(), fc3.getAlpha()).m_5752_();
        bufferbuilder.m_85982_(model, x8, y8, 0.0f).m_6122_(fc4.getRed(), fc4.getGreen(), fc4.getBlue(), fc4.getAlpha()).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69481_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void drawColoredTexture(PoseStack ms, Color c, int x, int y, int tex_left, int tex_top, int width, int height) {
        UIRenderHelper.drawColoredTexture(ms, c, x, y, 0, tex_left, tex_top, width, height, 256, 256);
    }

    public static void drawColoredTexture(PoseStack ms, Color c, int x, int y, int z, float tex_left, float tex_top, int width, int height, int sheet_width, int sheet_height) {
        UIRenderHelper.drawColoredTexture(ms, c, x, x + width, y, y + height, z, width, height, tex_left, tex_top, sheet_width, sheet_height);
    }

    public static void drawStretched(PoseStack ms, int left, int top, int w, int h, int z, AllGuiTextures tex) {
        tex.bind();
        UIRenderHelper.drawTexturedQuad(ms.m_85850_().m_85861_(), Color.WHITE, left, left + w, top, top + h, z, (float)tex.startX / 256.0f, (float)(tex.startX + tex.width) / 256.0f, (float)tex.startY / 256.0f, (float)(tex.startY + tex.height) / 256.0f);
    }

    public static void drawCropped(PoseStack ms, int left, int top, int w, int h, int z, AllGuiTextures tex) {
        tex.bind();
        UIRenderHelper.drawTexturedQuad(ms.m_85850_().m_85861_(), Color.WHITE, left, left + w, top, top + h, z, (float)tex.startX / 256.0f, (float)(tex.startX + w) / 256.0f, (float)tex.startY / 256.0f, (float)(tex.startY + h) / 256.0f);
    }

    private static void drawColoredTexture(PoseStack ms, Color c, int left, int right, int top, int bot, int z, int tex_width, int tex_height, float tex_left, float tex_top, int sheet_width, int sheet_height) {
        UIRenderHelper.drawTexturedQuad(ms.m_85850_().m_85861_(), c, left, right, top, bot, z, (tex_left + 0.0f) / (float)sheet_width, (tex_left + (float)tex_width) / (float)sheet_width, (tex_top + 0.0f) / (float)sheet_height, (tex_top + (float)tex_height) / (float)sheet_height);
    }

    private static void drawTexturedQuad(Matrix4f m, Color c, int left, int right, int top, int bot, int z, float u1, float u2, float v1, float v2) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferbuilder.m_85982_(m, (float)left, (float)bot, (float)z).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).m_7421_(u1, v2).m_5752_();
        bufferbuilder.m_85982_(m, (float)right, (float)bot, (float)z).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).m_7421_(u2, v2).m_5752_();
        bufferbuilder.m_85982_(m, (float)right, (float)top, (float)z).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).m_7421_(u2, v1).m_5752_();
        bufferbuilder.m_85982_(m, (float)left, (float)top, (float)z).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).m_7421_(u1, v1).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69461_();
    }

    public static void flipForGuiRender(PoseStack poseStack) {
        poseStack.m_166854_(Matrix4f.m_27632_((float)1.0f, (float)-1.0f, (float)1.0f));
    }

    public static class CustomRenderTarget
    extends RenderTarget {
        public CustomRenderTarget(boolean useDepth) {
            super(useDepth);
        }

        public static CustomRenderTarget create(Window mainWindow) {
            CustomRenderTarget framebuffer = new CustomRenderTarget(true);
            framebuffer.m_83941_(mainWindow.m_85441_(), mainWindow.m_85442_(), Minecraft.f_91002_);
            framebuffer.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
            framebuffer.enableStencil();
            return framebuffer;
        }

        public void renderWithAlpha(float alpha) {
            Window window = Minecraft.m_91087_().m_91268_();
            float vx = window.m_85445_();
            float vy = window.m_85446_();
            float tx = (float)this.f_83917_ / (float)this.f_83915_;
            float ty = (float)this.f_83918_ / (float)this.f_83916_;
            RenderSystem.m_69493_();
            RenderSystem.m_69482_();
            RenderSystem.m_157427_(() -> Minecraft.m_91087_().f_91063_.f_172635_);
            RenderSystem.m_157196_().m_173350_("DiffuseSampler", (Object)this.f_83923_);
            this.m_83956_();
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tessellator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
            bufferbuilder.m_5483_(0.0, (double)vy, 0.0).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(0.0f, 0.0f).m_5752_();
            bufferbuilder.m_5483_((double)vx, (double)vy, 0.0).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(tx, 0.0f).m_5752_();
            bufferbuilder.m_5483_((double)vx, 0.0, 0.0).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(tx, ty).m_5752_();
            bufferbuilder.m_5483_(0.0, 0.0, 0.0).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(0.0f, ty).m_5752_();
            tessellator.m_85914_();
            this.m_83963_();
        }
    }
}

