/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.Create;
import com.simibubi.create.content.decoration.palettes.ConnectedGlassBlock;
import com.simibubi.create.content.decoration.palettes.ConnectedGlassPaneBlock;
import com.simibubi.create.content.decoration.palettes.GlassPaneBlock;
import com.simibubi.create.content.decoration.palettes.WindowBlock;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.block.connected.GlassPaneCTBehaviour;
import com.simibubi.create.foundation.block.connected.HorizontalCTBehaviour;
import com.simibubi.create.foundation.data.BlockStateGen;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;

public class WindowGen {
    private static BlockBehaviour.Properties glassProperties(BlockBehaviour.Properties p) {
        return p.m_60922_(WindowGen::never).m_60924_(WindowGen::never).m_60960_(WindowGen::never).m_60971_(WindowGen::never);
    }

    private static boolean never(BlockState p_235436_0_, BlockGetter p_235436_1_, BlockPos p_235436_2_) {
        return false;
    }

    private static Boolean never(BlockState p_235427_0_, BlockGetter p_235427_1_, BlockPos p_235427_2_, EntityType<?> p_235427_3_) {
        return false;
    }

    public static BlockEntry<WindowBlock> woodenWindowBlock(WoodType woodType, Block planksBlock) {
        return WindowGen.woodenWindowBlock(woodType, planksBlock, () -> RenderType::m_110457_, false);
    }

    public static BlockEntry<WindowBlock> customWindowBlock(String name, Supplier<? extends ItemLike> ingredient, Supplier<CTSpriteShiftEntry> ct, Supplier<Supplier<RenderType>> renderType, boolean translucent, Supplier<MaterialColor> color) {
        NonNullFunction end_texture = n -> Create.asResource(WindowGen.palettesDir() + name + "_end");
        NonNullFunction side_texture = n -> Create.asResource(WindowGen.palettesDir() + n);
        return WindowGen.windowBlock(name, ingredient, ct, renderType, translucent, (NonNullFunction<String, ResourceLocation>)end_texture, (NonNullFunction<String, ResourceLocation>)side_texture, color);
    }

    public static BlockEntry<WindowBlock> woodenWindowBlock(WoodType woodType, Block planksBlock, Supplier<Supplier<RenderType>> renderType, boolean translucent) {
        String woodName = woodType.m_61846_();
        String name = woodName + "_window";
        NonNullFunction end_texture = $ -> new ResourceLocation("block/" + woodName + "_planks");
        NonNullFunction side_texture = n -> Create.asResource(WindowGen.palettesDir() + n);
        return WindowGen.windowBlock(name, () -> planksBlock, () -> AllSpriteShifts.getWoodenWindow(woodType), renderType, translucent, (NonNullFunction<String, ResourceLocation>)end_texture, (NonNullFunction<String, ResourceLocation>)side_texture, () -> ((Block)planksBlock).m_60590_());
    }

    public static BlockEntry<WindowBlock> windowBlock(String name, Supplier<? extends ItemLike> ingredient, Supplier<CTSpriteShiftEntry> ct, Supplier<Supplier<RenderType>> renderType, boolean translucent, NonNullFunction<String, ResourceLocation> endTexture, NonNullFunction<String, ResourceLocation> sideTexture, Supplier<MaterialColor> color) {
        return ((BlockBuilder)Create.REGISTRATE.block(name, p -> new WindowBlock((BlockBehaviour.Properties)p, translucent)).onRegister(CreateRegistrate.connectedTextures(() -> new HorizontalCTBehaviour((CTSpriteShiftEntry)ct.get())))).addLayer(renderType).recipe((c, p) -> ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)c.get()), (int)2).m_126130_(" # ").m_126130_("#X#").m_126127_(Character.valueOf('#'), (ItemLike)ingredient.get()).m_126124_(Character.valueOf('X'), (Ingredient)DataIngredient.tag((TagKey)Tags.Items.GLASS_COLORLESS)).m_126132_("has_ingredient", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)ingredient.get()))).m_176498_(arg_0 -> ((RegistrateRecipeProvider)p).accept(arg_0))).initialProperties(() -> Blocks.f_50058_).properties(WindowGen::glassProperties).properties(p -> p.m_155949_((MaterialColor)color.get())).loot((t, g) -> t.m_124272_((Block)g)).blockstate((c, p) -> p.simpleBlock((Block)c.get(), (ModelFile)p.models().cubeColumn(c.getName(), (ResourceLocation)sideTexture.apply((Object)c.getName()), (ResourceLocation)endTexture.apply((Object)c.getName())))).tag(new TagKey[]{BlockTags.f_13049_}).simpleItem().register();
    }

    public static BlockEntry<ConnectedGlassBlock> framedGlass(String name, Supplier<ConnectedTextureBehaviour> behaviour) {
        return ((BlockBuilder)((BlockBuilder)Create.REGISTRATE.block(name, ConnectedGlassBlock::new).onRegister(CreateRegistrate.connectedTextures(behaviour))).addLayer(() -> RenderType::m_110463_).initialProperties(() -> Blocks.f_50058_).properties(WindowGen::glassProperties).loot((t, g) -> t.m_124272_((Block)g)).recipe((c, p) -> p.stonecutting(DataIngredient.tag((TagKey)Tags.Items.GLASS_COLORLESS), () -> ((DataGenContext)c).get())).blockstate((c, p) -> BlockStateGen.cubeAll(c, p, "palettes/", "framed_glass")).tag(new TagKey[]{Tags.Blocks.GLASS_COLORLESS, BlockTags.f_13049_}).item().tag(new TagKey[]{Tags.Items.GLASS_COLORLESS}).model((c, p) -> p.cubeColumn(c.getName(), p.modLoc(WindowGen.palettesDir() + c.getName()), p.modLoc("block/palettes/framed_glass"))).build()).register();
    }

    public static BlockEntry<ConnectedGlassPaneBlock> framedGlassPane(String name, Supplier<? extends Block> parent, Supplier<CTSpriteShiftEntry> ctshift) {
        ResourceLocation sideTexture = Create.asResource(WindowGen.palettesDir() + "framed_glass");
        ResourceLocation itemSideTexture = Create.asResource(WindowGen.palettesDir() + name);
        ResourceLocation topTexture = Create.asResource(WindowGen.palettesDir() + "framed_glass_pane_top");
        Supplier<Supplier<RenderType>> renderType = () -> RenderType::m_110457_;
        return WindowGen.connectedGlassPane(name, parent, ctshift, sideTexture, itemSideTexture, topTexture, renderType);
    }

    public static BlockEntry<ConnectedGlassPaneBlock> customWindowPane(String name, Supplier<? extends Block> parent, Supplier<CTSpriteShiftEntry> ctshift, Supplier<Supplier<RenderType>> renderType) {
        ResourceLocation topTexture = Create.asResource(WindowGen.palettesDir() + name + "_pane_top");
        ResourceLocation sideTexture = Create.asResource(WindowGen.palettesDir() + name);
        return WindowGen.connectedGlassPane(name, parent, ctshift, sideTexture, sideTexture, topTexture, renderType);
    }

    public static BlockEntry<ConnectedGlassPaneBlock> woodenWindowPane(WoodType woodType, Supplier<? extends Block> parent) {
        return WindowGen.woodenWindowPane(woodType, parent, () -> RenderType::m_110457_);
    }

    public static BlockEntry<ConnectedGlassPaneBlock> woodenWindowPane(WoodType woodType, Supplier<? extends Block> parent, Supplier<Supplier<RenderType>> renderType) {
        String woodName = woodType.m_61846_();
        String name = woodName + "_window";
        ResourceLocation topTexture = new ResourceLocation("block/" + woodName + "_planks");
        ResourceLocation sideTexture = Create.asResource(WindowGen.palettesDir() + name);
        return WindowGen.connectedGlassPane(name, parent, () -> AllSpriteShifts.getWoodenWindow(woodType), sideTexture, sideTexture, topTexture, renderType);
    }

    public static BlockEntry<GlassPaneBlock> standardGlassPane(String name, Supplier<? extends Block> parent, ResourceLocation sideTexture, ResourceLocation topTexture, Supplier<Supplier<RenderType>> renderType) {
        NonNullBiConsumer stateProvider = (c, p) -> p.paneBlock((IronBarsBlock)c.get(), sideTexture, topTexture);
        return WindowGen.glassPane(name, parent, sideTexture, topTexture, GlassPaneBlock::new, renderType, $ -> {}, stateProvider);
    }

    private static BlockEntry<ConnectedGlassPaneBlock> connectedGlassPane(String name, Supplier<? extends Block> parent, Supplier<CTSpriteShiftEntry> ctshift, ResourceLocation sideTexture, ResourceLocation itemSideTexture, ResourceLocation topTexture, Supplier<Supplier<RenderType>> renderType) {
        NonNullConsumer connectedTextures = CreateRegistrate.connectedTextures(() -> new GlassPaneCTBehaviour((CTSpriteShiftEntry)ctshift.get()));
        String CGPparents = "block/connected_glass_pane/";
        String prefix = name + "_pane_";
        Function<RegistrateBlockstateProvider, ModelFile> post = WindowGen.getPaneModelProvider(CGPparents, prefix, "post", sideTexture, topTexture);
        Function<RegistrateBlockstateProvider, ModelFile> side = WindowGen.getPaneModelProvider(CGPparents, prefix, "side", sideTexture, topTexture);
        Function<RegistrateBlockstateProvider, ModelFile> sideAlt = WindowGen.getPaneModelProvider(CGPparents, prefix, "side_alt", sideTexture, topTexture);
        Function<RegistrateBlockstateProvider, ModelFile> noSide = WindowGen.getPaneModelProvider(CGPparents, prefix, "noside", sideTexture, topTexture);
        Function<RegistrateBlockstateProvider, ModelFile> noSideAlt = WindowGen.getPaneModelProvider(CGPparents, prefix, "noside_alt", sideTexture, topTexture);
        NonNullBiConsumer stateProvider = (c, p) -> p.paneBlock((IronBarsBlock)c.get(), (ModelFile)post.apply((RegistrateBlockstateProvider)p), (ModelFile)side.apply((RegistrateBlockstateProvider)p), (ModelFile)sideAlt.apply((RegistrateBlockstateProvider)p), (ModelFile)noSide.apply((RegistrateBlockstateProvider)p), (ModelFile)noSideAlt.apply((RegistrateBlockstateProvider)p));
        return WindowGen.glassPane(name, parent, itemSideTexture, topTexture, ConnectedGlassPaneBlock::new, renderType, connectedTextures, stateProvider);
    }

    private static Function<RegistrateBlockstateProvider, ModelFile> getPaneModelProvider(String CGPparents, String prefix, String partial, ResourceLocation sideTexture, ResourceLocation topTexture) {
        return p -> ((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(prefix + partial, Create.asResource(CGPparents + partial))).texture("pane", sideTexture)).texture("edge", topTexture);
    }

    private static <G extends GlassPaneBlock> BlockEntry<G> glassPane(String name, Supplier<? extends Block> parent, ResourceLocation sideTexture, ResourceLocation topTexture, NonNullFunction<BlockBehaviour.Properties, G> factory, Supplier<Supplier<RenderType>> renderType, NonNullConsumer<? super G> connectedTextures, NonNullBiConsumer<DataGenContext<Block, G>, RegistrateBlockstateProvider> stateProvider) {
        name = (String)name + "_pane";
        return ((BlockBuilder)((BlockBuilder)Create.REGISTRATE.block((String)name, factory).onRegister(connectedTextures)).addLayer(renderType).initialProperties(() -> Blocks.f_50185_).properties(p -> p.m_155949_(((Block)parent.get()).m_60590_())).blockstate(stateProvider).recipe((c, p) -> ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)c.get()), (int)16).m_126130_("###").m_126130_("###").m_126127_(Character.valueOf('#'), (ItemLike)parent.get()).m_126132_("has_ingredient", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)parent.get()))).m_176498_(arg_0 -> ((RegistrateRecipeProvider)p).accept(arg_0))).tag(new TagKey[]{Tags.Blocks.GLASS_PANES}).loot((t, g) -> t.m_124272_((Block)g)).item().tag(new TagKey[]{Tags.Items.GLASS_PANES}).model((c, p) -> ((ItemModelBuilder)((ItemModelBuilder)p.withExistingParent(c.getName(), Create.asResource("item/pane"))).texture("pane", sideTexture)).texture("edge", topTexture)).build()).register();
    }

    private static String palettesDir() {
        return "block/palettes/";
    }
}

