/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.basin;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.content.fluids.particle.FluidParticleData;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.simibubi.create.content.processing.basin.BasinBlock;
import com.simibubi.create.content.processing.basin.BasinInventory;
import com.simibubi.create.content.processing.basin.BasinOperatingBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.IntAttached;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class BasinBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    private boolean areFluidsMoving;
    LerpedFloat ingredientRotationSpeed;
    LerpedFloat ingredientRotation;
    public BasinInventory inputInventory = new BasinInventory(9, this);
    public SmartFluidTankBehaviour inputTank;
    protected SmartInventory outputInventory;
    protected SmartFluidTankBehaviour outputTank;
    private FilteringBehaviour filtering;
    private boolean contentsChanged;
    private Couple<SmartInventory> invs;
    private Couple<SmartFluidTankBehaviour> tanks;
    protected LazyOptional<IItemHandlerModifiable> itemCapability;
    protected LazyOptional<IFluidHandler> fluidCapability;
    List<Direction> disabledSpoutputs;
    Direction preferredSpoutput;
    protected List<ItemStack> spoutputBuffer;
    protected List<FluidStack> spoutputFluidBuffer;
    int recipeBackupCheck;
    public static final int OUTPUT_ANIMATION_TIME = 10;
    List<IntAttached<ItemStack>> visualizedOutputItems;
    List<IntAttached<FluidStack>> visualizedOutputFluids;

    public BasinBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inputInventory.whenContentsChanged($ -> {
            this.contentsChanged = true;
        });
        this.outputInventory = new BasinInventory(9, this).forbidInsertion().withMaxStackSize(64);
        this.areFluidsMoving = false;
        this.itemCapability = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory, this.outputInventory}));
        this.contentsChanged = true;
        this.ingredientRotation = LerpedFloat.angular().startWithValue(0.0);
        this.ingredientRotationSpeed = LerpedFloat.linear().startWithValue(0.0);
        this.invs = Couple.create(this.inputInventory, this.outputInventory);
        this.tanks = Couple.create(this.inputTank, this.outputTank);
        this.visualizedOutputItems = Collections.synchronizedList(new ArrayList());
        this.visualizedOutputFluids = Collections.synchronizedList(new ArrayList());
        this.disabledSpoutputs = new ArrayList<Direction>();
        this.preferredSpoutput = null;
        this.spoutputBuffer = new ArrayList<ItemStack>();
        this.spoutputFluidBuffer = new ArrayList<FluidStack>();
        this.recipeBackupCheck = 20;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this));
        this.filtering = new FilteringBehaviour(this, new BasinValueBox()).withCallback(newFilter -> {
            this.contentsChanged = true;
        }).forRecipes();
        behaviours.add(this.filtering);
        this.inputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, this, 2, 1000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        });
        this.outputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.OUTPUT, this, 2, 1000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        }).forbidInsertion();
        behaviours.add(this.inputTank);
        behaviours.add(this.outputTank);
        this.fluidCapability = LazyOptional.of(() -> {
            LazyOptional<? extends IFluidHandler> inputCap = this.inputTank.getCapability();
            LazyOptional<? extends IFluidHandler> outputCap = this.outputTank.getCapability();
            return new CombinedTankWrapper((IFluidHandler)outputCap.orElse(null), (IFluidHandler)inputCap.orElse(null));
        });
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inputInventory.deserializeNBT(compound.m_128469_("InputItems"));
        this.outputInventory.deserializeNBT(compound.m_128469_("OutputItems"));
        this.preferredSpoutput = null;
        if (compound.m_128441_("PreferredSpoutput")) {
            this.preferredSpoutput = NBTHelper.readEnum(compound, "PreferredSpoutput", Direction.class);
        }
        this.disabledSpoutputs.clear();
        ListTag disabledList = compound.m_128437_("DisabledSpoutput", 8);
        disabledList.forEach(d -> this.disabledSpoutputs.add(Direction.valueOf((String)((StringTag)d).m_7916_())));
        this.spoutputBuffer = NBTHelper.readItemList(compound.m_128437_("Overflow", 10));
        this.spoutputFluidBuffer = NBTHelper.readCompoundList(compound.m_128437_("FluidOverflow", 10), FluidStack::loadFluidStackFromNBT);
        if (!clientPacket) {
            return;
        }
        NBTHelper.iterateCompoundList(compound.m_128437_("VisualizedItems", 10), c -> this.visualizedOutputItems.add(IntAttached.with(10, ItemStack.m_41712_((CompoundTag)c))));
        NBTHelper.iterateCompoundList(compound.m_128437_("VisualizedFluids", 10), c -> this.visualizedOutputFluids.add(IntAttached.with(10, FluidStack.loadFluidStackFromNBT((CompoundTag)c))));
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("InputItems", (Tag)this.inputInventory.serializeNBT());
        compound.m_128365_("OutputItems", (Tag)this.outputInventory.serializeNBT());
        if (this.preferredSpoutput != null) {
            NBTHelper.writeEnum(compound, "PreferredSpoutput", this.preferredSpoutput);
        }
        ListTag disabledList = new ListTag();
        this.disabledSpoutputs.forEach(d -> disabledList.add((Object)StringTag.m_129297_((String)d.name())));
        compound.m_128365_("DisabledSpoutput", (Tag)disabledList);
        compound.m_128365_("Overflow", (Tag)NBTHelper.writeItemList(this.spoutputBuffer));
        compound.m_128365_("FluidOverflow", (Tag)NBTHelper.writeCompoundList(this.spoutputFluidBuffer, fs -> fs.writeToNBT(new CompoundTag())));
        if (!clientPacket) {
            return;
        }
        compound.m_128365_("VisualizedItems", (Tag)NBTHelper.writeCompoundList(this.visualizedOutputItems, ia -> ((ItemStack)ia.getValue()).serializeNBT()));
        compound.m_128365_("VisualizedFluids", (Tag)NBTHelper.writeCompoundList(this.visualizedOutputFluids, ia -> ((FluidStack)ia.getValue()).writeToNBT(new CompoundTag())));
        this.visualizedOutputItems.clear();
        this.visualizedOutputFluids.clear();
    }

    @Override
    public void destroy() {
        super.destroy();
        ItemHelper.dropContents(this.f_58857_, this.f_58858_, (IItemHandler)this.inputInventory);
        ItemHelper.dropContents(this.f_58857_, this.f_58858_, (IItemHandler)this.outputInventory);
        this.spoutputBuffer.forEach(is -> Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)is));
    }

    @Override
    public void remove() {
        super.remove();
        this.onEmptied();
    }

    public void onEmptied() {
        this.getOperator().ifPresent(be -> {
            be.basinRemoved = true;
        });
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.itemCapability.invalidate();
        this.fluidCapability.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemCapability.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void notifyUpdate() {
        super.notifyUpdate();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (!this.f_58857_.f_46443_) {
            this.updateSpoutput();
            if (this.recipeBackupCheck-- > 0) {
                return;
            }
            this.recipeBackupCheck = 20;
            if (this.isEmpty()) {
                return;
            }
            this.notifyChangeOfContents();
            return;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_6630_(2));
        if (!(blockEntity instanceof MechanicalMixerBlockEntity)) {
            this.setAreFluidsMoving(false);
            return;
        }
        MechanicalMixerBlockEntity mixer = (MechanicalMixerBlockEntity)blockEntity;
        this.setAreFluidsMoving(mixer.running && mixer.runningTicks <= 20);
    }

    public boolean isEmpty() {
        return this.inputInventory.m_7983_() && this.outputInventory.m_7983_() && this.inputTank.isEmpty() && this.outputTank.isEmpty();
    }

    public void onWrenched(Direction face) {
        BlockState blockState = this.m_58900_();
        Direction currentFacing = (Direction)blockState.m_61143_((Property)BasinBlock.FACING);
        this.disabledSpoutputs.remove(face);
        if (currentFacing == face) {
            if (this.preferredSpoutput == face) {
                this.preferredSpoutput = null;
            }
            this.disabledSpoutputs.add(face);
        } else {
            this.preferredSpoutput = face;
        }
        this.updateSpoutput();
    }

    private void updateSpoutput() {
        BlockState blockState = this.m_58900_();
        Direction currentFacing = (Direction)blockState.m_61143_((Property)BasinBlock.FACING);
        Direction newFacing = Direction.DOWN;
        for (Direction test : Iterate.horizontalDirections) {
            boolean canOutputTo = BasinBlock.canOutputTo((BlockGetter)this.f_58857_, this.f_58858_, test);
            if (!canOutputTo || this.disabledSpoutputs.contains(test)) continue;
            newFacing = test;
        }
        if (this.preferredSpoutput != null && BasinBlock.canOutputTo((BlockGetter)this.f_58857_, this.f_58858_, this.preferredSpoutput) && this.preferredSpoutput != Direction.UP) {
            newFacing = this.preferredSpoutput;
        }
        if (newFacing == currentFacing) {
            return;
        }
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)blockState.m_61124_((Property)BasinBlock.FACING, (Comparable)newFacing));
        if (newFacing.m_122434_().m_122478_()) {
            return;
        }
        for (int slot = 0; slot < this.outputInventory.getSlots(); ++slot) {
            ItemStack extractItem = this.outputInventory.extractItem(slot, 64, true);
            if (extractItem.m_41619_() || !this.acceptOutputs((List<ItemStack>)ImmutableList.of((Object)extractItem), Collections.emptyList(), true)) continue;
            this.acceptOutputs((List<ItemStack>)ImmutableList.of((Object)this.outputInventory.extractItem(slot, 64, false)), Collections.emptyList(), false);
        }
        IFluidHandler handler = (IFluidHandler)this.outputTank.getCapability().orElse(null);
        for (int slot = 0; slot < handler.getTanks(); ++slot) {
            FluidStack fs = handler.getFluidInTank(slot).copy();
            if (fs.isEmpty() || !this.acceptOutputs(Collections.emptyList(), (List<FluidStack>)ImmutableList.of((Object)fs), true)) continue;
            handler.drain(fs, IFluidHandler.FluidAction.EXECUTE);
            this.acceptOutputs(Collections.emptyList(), (List<FluidStack>)ImmutableList.of((Object)fs), false);
        }
        this.notifyChangeOfContents();
        this.notifyUpdate();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            this.createFluidParticles();
            this.tickVisualizedOutputs();
            this.ingredientRotationSpeed.tickChaser();
            this.ingredientRotation.setValue(this.ingredientRotation.getValue() + this.ingredientRotationSpeed.getValue());
        }
        if (!(this.spoutputBuffer.isEmpty() && this.spoutputFluidBuffer.isEmpty() || this.f_58857_.f_46443_)) {
            this.tryClearingSpoutputOverflow();
        }
        if (!this.contentsChanged) {
            return;
        }
        this.contentsChanged = false;
        this.getOperator().ifPresent(be -> be.basinChecker.scheduleUpdate());
        for (Direction offset : Iterate.horizontalDirections) {
            BlockEntity be2;
            BlockPos toUpdate = this.f_58858_.m_7494_().m_121945_(offset);
            BlockState stateToUpdate = this.f_58857_.m_8055_(toUpdate);
            if (!(stateToUpdate.m_60734_() instanceof BasinBlock) || stateToUpdate.m_61143_((Property)BasinBlock.FACING) != offset.m_122424_() || !((be2 = this.f_58857_.m_7702_(toUpdate)) instanceof BasinBlockEntity)) continue;
            ((BasinBlockEntity)be2).contentsChanged = true;
        }
    }

    private void tryClearingSpoutputOverflow() {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof BasinBlock)) {
            return;
        }
        Direction direction = (Direction)blockState.m_61143_((Property)BasinBlock.FACING);
        BlockEntity be = this.f_58857_.m_7702_(this.f_58858_.m_7495_().m_121945_(direction));
        FilteringBehaviour filter = null;
        CapManipulationBehaviourBase inserter = null;
        if (be != null) {
            filter = BlockEntityBehaviour.get((BlockGetter)this.f_58857_, be.m_58899_(), FilteringBehaviour.TYPE);
            inserter = BlockEntityBehaviour.get((BlockGetter)this.f_58857_, be.m_58899_(), InvManipulationBehaviour.TYPE);
        }
        IItemHandler targetInv = be == null ? null : (IItemHandler)be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.m_122424_()).orElse(inserter == null ? null : (IItemHandler)inserter.getInventory());
        IFluidHandler targetTank = be == null ? null : (IFluidHandler)be.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.m_122424_()).orElse(null);
        boolean update = false;
        Iterator<ItemStack> iterator = this.spoutputBuffer.iterator();
        while (iterator.hasNext()) {
            ItemStack itemStack = iterator.next();
            if (direction == Direction.DOWN) {
                Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)itemStack);
                iterator.remove();
                update = true;
                continue;
            }
            if (targetInv == null) break;
            if (!ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)itemStack, (boolean)true).m_41619_() || filter != null && !filter.test(itemStack)) continue;
            update = true;
            ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)itemStack.m_41777_(), (boolean)false);
            iterator.remove();
            this.visualizedOutputItems.add(IntAttached.withZero(itemStack));
        }
        iterator = this.spoutputFluidBuffer.iterator();
        block1: while (iterator.hasNext()) {
            FluidStack fluidStack = (FluidStack)iterator.next();
            if (direction == Direction.DOWN) {
                iterator.remove();
                update = true;
                continue;
            }
            if (targetTank == null) break;
            for (boolean simulate : Iterate.trueAndFalse) {
                IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
                int fill = targetTank instanceof SmartFluidTankBehaviour.InternalFluidHandler ? ((SmartFluidTankBehaviour.InternalFluidHandler)targetTank).forceFill(fluidStack.copy(), action) : targetTank.fill(fluidStack.copy(), action);
                if (fill != fluidStack.getAmount()) continue block1;
                if (simulate) continue;
                update = true;
                iterator.remove();
                this.visualizedOutputFluids.add(IntAttached.withZero(fluidStack));
            }
        }
        if (update) {
            this.notifyChangeOfContents();
            this.sendData();
        }
    }

    public float getTotalFluidUnits(float partialTicks) {
        int renderedFluids = 0;
        float totalUnits = 0.0f;
        for (SmartFluidTankBehaviour behaviour : this.getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                float units;
                if (tankSegment.getRenderedFluid().isEmpty() || (units = tankSegment.getTotalUnits(partialTicks)) < 1.0f) continue;
                totalUnits += units;
                ++renderedFluids;
            }
        }
        if (renderedFluids == 0) {
            return 0.0f;
        }
        if (totalUnits < 1.0f) {
            return 0.0f;
        }
        return totalUnits;
    }

    private Optional<BasinOperatingBlockEntity> getOperator() {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        BlockEntity be = this.f_58857_.m_7702_(this.f_58858_.m_6630_(2));
        if (be instanceof BasinOperatingBlockEntity) {
            return Optional.of((BasinOperatingBlockEntity)be);
        }
        return Optional.empty();
    }

    public FilteringBehaviour getFilter() {
        return this.filtering;
    }

    public void notifyChangeOfContents() {
        this.contentsChanged = true;
    }

    public SmartInventory getInputInventory() {
        return this.inputInventory;
    }

    public SmartInventory getOutputInventory() {
        return this.outputInventory;
    }

    public boolean canContinueProcessing() {
        return this.spoutputBuffer.isEmpty() && this.spoutputFluidBuffer.isEmpty();
    }

    public boolean acceptOutputs(List<ItemStack> outputItems, List<FluidStack> outputFluids, boolean simulate) {
        this.outputInventory.allowInsertion();
        this.outputTank.allowInsertion();
        boolean acceptOutputsInner = this.acceptOutputsInner(outputItems, outputFluids, simulate);
        this.outputInventory.forbidInsertion();
        this.outputTank.forbidInsertion();
        return acceptOutputsInner;
    }

    private boolean acceptOutputsInner(List<ItemStack> outputItems, List<FluidStack> outputFluids, boolean simulate) {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof BasinBlock)) {
            return false;
        }
        Direction direction = (Direction)blockState.m_61143_((Property)BasinBlock.FACING);
        if (direction != Direction.DOWN) {
            boolean externalTankNotPresent;
            InvManipulationBehaviour inserter;
            BlockEntity be = this.f_58857_.m_7702_(this.f_58858_.m_7495_().m_121945_(direction));
            InvManipulationBehaviour invManipulationBehaviour = inserter = be == null ? null : BlockEntityBehaviour.get((BlockGetter)this.f_58857_, be.m_58899_(), InvManipulationBehaviour.TYPE);
            IItemHandler targetInv = be == null ? null : (IItemHandler)be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.m_122424_()).orElse(inserter == null ? null : (IItemHandler)inserter.getInventory());
            IFluidHandler targetTank = be == null ? null : (IFluidHandler)be.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.m_122424_()).orElse(null);
            boolean bl = externalTankNotPresent = targetTank == null;
            if (!outputItems.isEmpty() && targetInv == null) {
                return false;
            }
            if (!outputFluids.isEmpty() && externalTankNotPresent) {
                targetTank = (IFluidHandler)this.outputTank.getCapability().orElse(null);
                if (targetTank == null) {
                    return false;
                }
                if (!this.acceptFluidOutputsIntoBasin(outputFluids, simulate, targetTank)) {
                    return false;
                }
            }
            if (simulate) {
                return true;
            }
            for (ItemStack itemStack : outputItems) {
                this.spoutputBuffer.add(itemStack.m_41777_());
            }
            if (!externalTankNotPresent) {
                for (FluidStack fluidStack : outputFluids) {
                    this.spoutputFluidBuffer.add(fluidStack.copy());
                }
            }
            return true;
        }
        SmartInventory targetInv = this.outputInventory;
        IFluidHandler targetTank = (IFluidHandler)this.outputTank.getCapability().orElse(null);
        if (targetInv == null && !outputItems.isEmpty()) {
            return false;
        }
        if (!this.acceptItemOutputsIntoBasin(outputItems, simulate, (IItemHandler)targetInv)) {
            return false;
        }
        if (outputFluids.isEmpty()) {
            return true;
        }
        if (targetTank == null) {
            return false;
        }
        return this.acceptFluidOutputsIntoBasin(outputFluids, simulate, targetTank);
    }

    private boolean acceptFluidOutputsIntoBasin(List<FluidStack> outputFluids, boolean simulate, IFluidHandler targetTank) {
        for (FluidStack fluidStack : outputFluids) {
            IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
            int fill = targetTank instanceof SmartFluidTankBehaviour.InternalFluidHandler ? ((SmartFluidTankBehaviour.InternalFluidHandler)targetTank).forceFill(fluidStack.copy(), action) : targetTank.fill(fluidStack.copy(), action);
            if (fill == fluidStack.getAmount()) continue;
            return false;
        }
        return true;
    }

    private boolean acceptItemOutputsIntoBasin(List<ItemStack> outputItems, boolean simulate, IItemHandler targetInv) {
        for (ItemStack itemStack : outputItems) {
            if (ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)itemStack.m_41777_(), (boolean)simulate).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void readOnlyItems(CompoundTag compound) {
        this.inputInventory.deserializeNBT(compound.m_128469_("InputItems"));
        this.outputInventory.deserializeNBT(compound.m_128469_("OutputItems"));
    }

    public static BlazeBurnerBlock.HeatLevel getHeatLevelOf(BlockState state) {
        if (state.m_61138_(BlazeBurnerBlock.HEAT_LEVEL)) {
            return (BlazeBurnerBlock.HeatLevel)((Object)state.m_61143_(BlazeBurnerBlock.HEAT_LEVEL));
        }
        return AllTags.AllBlockTags.PASSIVE_BOILER_HEATERS.matches(state) ? BlazeBurnerBlock.HeatLevel.SMOULDERING : BlazeBurnerBlock.HeatLevel.NONE;
    }

    public Couple<SmartFluidTankBehaviour> getTanks() {
        return this.tanks;
    }

    public Couple<SmartInventory> getInvs() {
        return this.invs;
    }

    private void tickVisualizedOutputs() {
        this.visualizedOutputFluids.forEach(IntAttached::decrement);
        this.visualizedOutputItems.forEach(IntAttached::decrement);
        this.visualizedOutputFluids.removeIf(IntAttached::isOrBelowZero);
        this.visualizedOutputItems.removeIf(IntAttached::isOrBelowZero);
    }

    private void createFluidParticles() {
        RandomSource r = this.f_58857_.f_46441_;
        if (!this.visualizedOutputFluids.isEmpty()) {
            this.createOutputFluidParticles(r);
        }
        if (!this.areFluidsMoving && r.m_188501_() > 0.125f) {
            return;
        }
        int segments = 0;
        for (SmartFluidTankBehaviour behaviour : this.getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0.0f)) continue;
                ++segments;
            }
        }
        if (segments < 2) {
            return;
        }
        float totalUnits = this.getTotalFluidUnits(0.0f);
        if (totalUnits == 0.0f) {
            return;
        }
        float fluidLevel = Mth.m_14036_((float)(totalUnits / 2000.0f), (float)0.0f, (float)1.0f);
        float rim = 0.125f;
        float space = 0.75f;
        float surface = (float)this.f_58858_.m_123342_() + rim + space * fluidLevel + 0.03125f;
        if (this.areFluidsMoving) {
            this.createMovingFluidParticles(surface, segments);
            return;
        }
        for (SmartFluidTankBehaviour behaviour : this.getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0.0f)) continue;
                float x = (float)this.f_58858_.m_123341_() + rim + space * r.m_188501_();
                float z = (float)this.f_58858_.m_123343_() + rim + space * r.m_188501_();
                this.f_58857_.m_7107_((ParticleOptions)new FluidParticleData(AllParticleTypes.BASIN_FLUID.get(), tankSegment.getRenderedFluid()), (double)x, (double)surface, (double)z, 0.0, 0.0, 0.0);
            }
        }
    }

    private void createOutputFluidParticles(RandomSource r) {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof BasinBlock)) {
            return;
        }
        Direction direction = (Direction)blockState.m_61143_((Property)BasinBlock.FACING);
        if (direction == Direction.DOWN) {
            return;
        }
        Vec3 directionVec = Vec3.m_82528_((Vec3i)direction.m_122436_());
        Vec3 outVec = VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82549_(directionVec.m_82490_(0.65).m_82492_(0.0, 0.25, 0.0));
        Vec3 outMotion = directionVec.m_82490_(0.0625).m_82520_(0.0, -0.0625, 0.0);
        for (int i = 0; i < 2; ++i) {
            this.visualizedOutputFluids.forEach(ia -> {
                FluidStack fluidStack = (FluidStack)ia.getValue();
                ParticleOptions fluidParticle = FluidFX.getFluidParticle(fluidStack);
                Vec3 m = VecHelper.offsetRandomly(outMotion, r, 0.0625f);
                this.f_58857_.m_7107_(fluidParticle, outVec.f_82479_, outVec.f_82480_, outVec.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
            });
        }
    }

    private void createMovingFluidParticles(float surface, int segments) {
        Vec3 pointer = new Vec3(1.0, 0.0, 0.0).m_82490_(0.0625);
        float interval = 360.0f / (float)segments;
        Vec3 centerOf = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        float intervalOffset = AnimationTickHolder.getTicks() * 18 % 360;
        int currentSegment = 0;
        for (SmartFluidTankBehaviour behaviour : this.getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0.0f)) continue;
                float angle = interval * (float)(1 + currentSegment) + intervalOffset;
                Vec3 vec = centerOf.m_82549_(VecHelper.rotate(pointer, angle, Direction.Axis.Y));
                this.f_58857_.m_7107_((ParticleOptions)new FluidParticleData(AllParticleTypes.BASIN_FLUID.get(), tankSegment.getRenderedFluid()), vec.m_7096_(), (double)surface, vec.m_7094_(), 1.0, 0.0, 0.0);
                ++currentSegment;
            }
        }
    }

    public boolean areFluidsMoving() {
        return this.areFluidsMoving;
    }

    public boolean setAreFluidsMoving(boolean areFluidsMoving) {
        this.areFluidsMoving = areFluidsMoving;
        this.ingredientRotationSpeed.chase(areFluidsMoving ? 20.0 : 0.0, 0.1f, LerpedFloat.Chaser.EXP);
        return areFluidsMoving;
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.translate("gui.goggles.basin_contents", new Object[0]).forGoggles(tooltip);
        IItemHandlerModifiable items = (IItemHandlerModifiable)this.itemCapability.orElse((Object)new ItemStackHandler());
        IFluidHandler fluids = (IFluidHandler)this.fluidCapability.orElse((Object)new FluidTank(0));
        boolean isEmpty = true;
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack stackInSlot = items.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            Lang.text("").add(Components.translatable(stackInSlot.m_41778_()).m_130940_(ChatFormatting.GRAY)).add(Lang.text(" x" + stackInSlot.m_41613_()).style(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        LangBuilder mb = Lang.translate("generic.unit.millibuckets", new Object[0]);
        for (int i = 0; i < fluids.getTanks(); ++i) {
            FluidStack fluidStack = fluids.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            Lang.text("").add(Lang.fluidName(fluidStack).add(Lang.text(" ")).style(ChatFormatting.GRAY).add(Lang.number(fluidStack.getAmount()).add(mb).style(ChatFormatting.BLUE))).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (isEmpty) {
            tooltip.remove(0);
        }
        return true;
    }

    class BasinValueBox
    extends ValueBoxTransform.Sided {
        BasinValueBox() {
        }

        @Override
        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace(8.0, 12.0, 16.05);
        }

        @Override
        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction.m_122434_().m_122479_();
        }
    }
}

