/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Field;
import java.util.Objects;

public abstract class DecimalValue<N extends Number>
extends ConfigValue<N> {
    protected Range range;

    public DecimalValue(ValueData<N> data, Range range) {
        super(data);
        this.range = Objects.requireNonNull(range);
    }

    @Override
    protected void readFieldData(Field field) {
        super.readFieldData(field);
        Configurable.DecimalRange decimalRange = field.getAnnotation(Configurable.DecimalRange.class);
        if (decimalRange != null) {
            this.range = Range.newBoundedRange(decimalRange.min(), decimalRange.max());
        }
    }

    @Override
    public abstract N getCorrectedValue(N var1);

    public Range getRange() {
        return this.range;
    }

    public static final class Range {
        private final double min;
        private final double max;

        private Range(double min, double max) {
            this.min = min;
            this.max = max;
        }

        public static Range newBoundedRange(double min, double max) {
            if (min > max) {
                throw new IllegalArgumentException(String.format("Invalid number range: Min value (%f) cannot be bigger than max value (%f)", min, max));
            }
            return new Range(min, max);
        }

        public static Range unboundedDouble() {
            return Range.newBoundedRange(-1.7976931348623157E308, Double.MAX_VALUE);
        }

        public static Range unboundedFloat() {
            return Range.newBoundedRange(-3.4028234663852886E38, 3.4028234663852886E38);
        }

        public boolean isWithin(double number) {
            return number >= this.min && number <= this.max;
        }

        public double min() {
            return this.min;
        }

        public double max() {
            return this.max;
        }

        public double clamp(double in) {
            return Math.min(this.max, Math.max(this.min, in));
        }

        public float clamp(float in) {
            return (float)Math.min(this.max, Math.max(this.min, (double)in));
        }
    }
}

