/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.format;

import dev.toma.configuration.config.format.GsonFormat;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.format.IConfigFormatHandler;
import dev.toma.configuration.config.format.PropertiesFormat;
import dev.toma.configuration.config.format.YamlFormat;
import java.util.function.Supplier;

public final class ConfigFormats {
    private static final String EXT_JSON = "json";
    private static final String EXT_YAML = "yaml";
    private static final String EXT_PROPERTIES = "properties";

    public static IConfigFormatHandler json(GsonFormat.Settings settings) {
        return new SimpleFormatImpl(EXT_JSON, () -> new GsonFormat(settings));
    }

    public static IConfigFormatHandler json() {
        return ConfigFormats.json(new GsonFormat.Settings());
    }

    public static IConfigFormatHandler yaml() {
        return new SimpleFormatImpl(EXT_YAML, YamlFormat::new);
    }

    public static IConfigFormatHandler properties(PropertiesFormat.Settings settings) {
        return new SimpleFormatImpl(EXT_PROPERTIES, () -> new PropertiesFormat(settings));
    }

    public static IConfigFormatHandler properties() {
        return ConfigFormats.properties(new PropertiesFormat.Settings());
    }

    private static final class SimpleFormatImpl
    implements IConfigFormatHandler {
        private final String extension;
        private final Supplier<IConfigFormat> factory;

        public SimpleFormatImpl(String extension, Supplier<IConfigFormat> factory) {
            this.extension = extension;
            this.factory = factory;
        }

        @Override
        public IConfigFormat createFormat() {
            return this.factory.get();
        }

        @Override
        public String fileExt() {
            return this.extension;
        }
    }
}

