/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.toma.configuration.client.WidgetAdder;
import dev.toma.configuration.client.widget.ContainerWidget;
import dev.toma.configuration.config.validate.NotificationSeverity;
import dev.toma.configuration.config.validate.ValidationResult;
import dev.toma.configuration.config.value.ConfigValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;

public class ConfigEntryWidget
extends ContainerWidget
implements WidgetAdder {
    public static final Component EDIT = Component.m_237115_((String)"text.configuration.value.edit");
    public static final Component BACK = Component.m_237115_((String)"text.configuration.value.back");
    public static final Component REVERT_DEFAULTS = Component.m_237115_((String)"text.configuration.value.revert.default");
    public static final Component REVERT_DEFAULTS_DIALOG_TEXT = Component.m_237115_((String)"text.configuration.value.revert.default.dialog");
    public static final Component REVERT_CHANGES = Component.m_237115_((String)"text.configuration.value.revert.changes");
    public static final Component REVERT_CHANGES_DIALOG_TEXT = Component.m_237115_((String)"text.configuration.value.revert.changes.dialog");
    private final String configId;
    private final List<Component> description;
    private ValidationResult result = ValidationResult.ok();
    private IDescriptionRenderer renderer;
    private boolean lastHoverState;
    private long hoverTimeStart;

    public ConfigEntryWidget(int x, int y, int w, int h, ConfigValue<?> value, String configId) {
        super(x, y, w, h, (Component)Component.m_237115_((String)("config." + configId + ".option." + value.getId())));
        this.configId = configId;
        this.description = Arrays.stream(value.getDescription()).map(text -> Component.m_237113_((String)text).m_130940_(ChatFormatting.GRAY)).collect(Collectors.toList());
    }

    public void setDescriptionRenderer(IDescriptionRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public Component getComponentName() {
        return this.m_6035_();
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }

    @Override
    public void m_6303_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        Font font = Minecraft.m_91087_().f_91062_;
        if (!this.lastHoverState && this.f_93622_) {
            this.hoverTimeStart = System.currentTimeMillis();
        }
        boolean isError = !this.result.isOk();
        Component component = this.m_6035_();
        float f = this.f_93620_;
        float f2 = this.f_93621_;
        Objects.requireNonNull(font);
        font.m_92889_(stack, component, f, f2 + (float)(this.f_93619_ - 9) / 2.0f, 0xAAAAAA);
        super.m_6303_(stack, mouseX, mouseY, partialTicks);
        if ((isError || this.f_93622_) && this.renderer != null) {
            long totalHoverTime = System.currentTimeMillis() - this.hoverTimeStart;
            if (isError || totalHoverTime >= 750L) {
                NotificationSeverity severity = this.result.severity();
                MutableComponent textComponent = this.result.text().m_130940_(severity.getExtraFormatting());
                List<MutableComponent> desc = isError ? Collections.singletonList(textComponent) : this.description;
                List<FormattedCharSequence> split = desc.stream().flatMap(text -> font.m_92923_((FormattedText)text, this.f_93618_ / 2).stream()).collect(Collectors.toList());
                this.renderer.drawDescription(stack, this, severity, split);
            }
        }
        this.lastHoverState = this.f_93622_;
    }

    @Override
    public void setValidationResult(ValidationResult result) {
        this.result = result;
    }

    @Override
    public <W extends AbstractWidget> W addConfigWidget(WidgetAdder.ToWidgetFunction<W> function) {
        W widget = function.asWidget(this.f_93620_, this.f_93621_, this.f_93618_, this.f_93619_, this.configId);
        return this.addRenderableWidget(widget);
    }

    @FunctionalInterface
    public static interface IDescriptionRenderer {
        public void drawDescription(PoseStack var1, AbstractWidget var2, NotificationSeverity var3, List<FormattedCharSequence> var4);
    }
}

