/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.toma.configuration.client.DisplayAdapter;
import dev.toma.configuration.client.screen.AbstractConfigScreen;
import dev.toma.configuration.client.screen.ConfigScreen;
import dev.toma.configuration.client.widget.ConfigEntryWidget;
import dev.toma.configuration.config.ConfigHolder;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class ConfigGroupScreen
extends Screen {
    protected final Screen last;
    protected final String groupId;
    protected final List<ConfigHolder<?>> configHolders;
    protected int index;
    protected int pageSize;

    public ConfigGroupScreen(Screen last, String groupId, List<ConfigHolder<?>> configHolders) {
        super((Component)Component.m_237115_((String)"text.configuration.screen.select_config"));
        this.last = last;
        this.groupId = groupId;
        this.configHolders = configHolders;
    }

    protected void m_7856_() {
        int viewportMin = 35;
        int viewportHeight = this.f_96544_ - 35 - 30;
        this.pageSize = (viewportHeight - 20) / 25;
        this.correctScrollingIndex(this.configHolders.size());
        int errorOffset = viewportHeight - 20 - (this.pageSize * 25 - 5);
        int offset = 0;
        int posX = 30;
        int componentWidth = this.f_96543_ - 2 * posX;
        for (int i = this.index; i < this.index + this.pageSize; ++i) {
            int j = i - this.index;
            if (i >= this.configHolders.size()) break;
            int correct = errorOffset / (this.pageSize - j);
            errorOffset -= correct;
            ConfigHolder<?> value = this.configHolders.get(i);
            int y = 45 + j * 25 + (offset += correct);
            String configId = value.getConfigId();
            this.m_142416_((GuiEventListener)new LeftAlignedLabel(posX, y, componentWidth, 20, (Component)Component.m_237115_((String)("config.screen." + configId)), this.f_96547_));
            this.m_142416_((GuiEventListener)new Button(DisplayAdapter.getValueX(posX, componentWidth), y, DisplayAdapter.getValueWidth(componentWidth), 20, ConfigEntryWidget.EDIT, btn -> {
                ConfigScreen screen = new ConfigScreen(configId, configId, value.getValueMap(), (Screen)this);
                this.f_96541_.m_91152_((Screen)screen);
            }));
        }
        this.initFooter();
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        int titleWidth = this.f_96547_.m_92852_((FormattedText)this.f_96539_);
        float f = (float)(this.f_96543_ - titleWidth) / 2.0f;
        Objects.requireNonNull(this.f_96547_);
        this.f_96547_.m_92889_(stack, this.f_96539_, f, (float)(35 - 9) / 2.0f, 0xFFFFFF);
        ConfigGroupScreen.m_93172_((PoseStack)stack, (int)0, (int)35, (int)this.f_96543_, (int)(this.f_96544_ - 30), (int)-1728053248);
        AbstractConfigScreen.renderScrollbar(stack, this.f_96543_ - 5, 35, 5, this.f_96544_ - 30 - 35, this.index, this.configHolders.size(), this.pageSize);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
    }

    protected void initFooter() {
        int centerY = this.f_96544_ - 30 + 5;
        this.m_142416_((GuiEventListener)new Button(20, centerY, 50, 20, ConfigEntryWidget.BACK, btn -> this.f_96541_.m_91152_(this.last)));
    }

    protected void correctScrollingIndex(int count) {
        if (this.index + this.pageSize > count) {
            this.index = Math.max(count - this.pageSize, 0);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        int scale = (int)(-amount);
        int next = this.index + scale;
        if (next >= 0 && next + this.pageSize <= this.configHolders.size()) {
            this.index = next;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            return true;
        }
        return false;
    }

    protected static final class LeftAlignedLabel
    extends AbstractWidget {
        private final Font font;

        public LeftAlignedLabel(int x, int y, int width, int height, Component label, Font font) {
            super(x, y, width, height, label);
            this.font = font;
        }

        public void m_6303_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
            Component component = this.m_6035_();
            float f = this.f_93620_;
            float f2 = this.f_93621_;
            Objects.requireNonNull(this.font);
            this.font.m_92889_(stack, component, f, f2 + (float)(this.f_93619_ - 9) / 2.0f, 0xAAAAAA);
        }

        protected boolean m_7972_(int p_230987_1_) {
            return false;
        }

        public void m_142291_(NarrationElementOutput p_169152_) {
        }
    }
}

