/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import dev.toma.configuration.Configuration;
import dev.toma.configuration.client.IValidationHandler;
import dev.toma.configuration.client.screen.ConfigScreen;
import dev.toma.configuration.client.screen.DialogScreen;
import dev.toma.configuration.client.widget.ConfigEntryWidget;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.io.ConfigIO;
import dev.toma.configuration.config.validate.NotificationSeverity;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.ObjectValue;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public abstract class AbstractConfigScreen
extends Screen {
    public static final int HEADER_HEIGHT = 35;
    public static final int FOOTER_HEIGHT = 30;
    public static final Marker MARKER = MarkerManager.getMarker((String)"Screen");
    protected final Screen last;
    protected final String configId;
    protected int index;
    protected int pageSize;

    public AbstractConfigScreen(Component title, Screen previous, String configId) {
        super(title);
        this.last = previous;
        this.configId = configId;
    }

    public void m_7379_() {
        super.m_7379_();
        this.saveConfig(true);
    }

    public static void renderScrollbar(PoseStack stack, int x, int y, int width, int height, int index, int valueCount, int paging) {
        if (valueCount <= paging) {
            return;
        }
        double step = (double)height / (double)valueCount;
        int min = Mth.m_14107_((double)((double)index * step));
        int max = Mth.m_14165_((double)((double)(index + paging) * step));
        int y1 = y + min;
        int y2 = y + max;
        AbstractConfigScreen.m_93172_((PoseStack)stack, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)-16777216);
        AbstractConfigScreen.m_93172_((PoseStack)stack, (int)x, (int)y1, (int)(x + width), (int)y2, (int)-7829368);
        AbstractConfigScreen.m_93172_((PoseStack)stack, (int)x, (int)y1, (int)(x + width - 1), (int)(y2 - 1), (int)-1118482);
        AbstractConfigScreen.m_93172_((PoseStack)stack, (int)(x + 1), (int)(y1 + 1), (int)(x + width - 1), (int)(y2 - 1), (int)-3355444);
    }

    protected void addFooter() {
        int centerY = this.f_96544_ - 30 + 5;
        this.m_142416_((GuiEventListener)new Button(20, centerY, 50, 20, ConfigEntryWidget.BACK, this::buttonBackClicked));
        this.m_142416_((GuiEventListener)new Button(75, centerY, 120, 20, ConfigEntryWidget.REVERT_DEFAULTS, this::buttonRevertToDefaultClicked));
        this.m_142416_((GuiEventListener)new Button(200, centerY, 120, 20, ConfigEntryWidget.REVERT_CHANGES, this::buttonRevertChangesClicked));
    }

    protected void correctScrollingIndex(int count) {
        if (this.index + this.pageSize > count) {
            this.index = Math.max(count - this.pageSize, 0);
        }
    }

    protected Screen getFirstNonConfigScreen() {
        Screen screen = this.last;
        while (screen instanceof ConfigScreen) {
            ConfigScreen configScreen = (ConfigScreen)screen;
            screen = configScreen.last;
        }
        return screen;
    }

    private void buttonBackClicked(Button button) {
        this.f_96541_.m_91152_(this.last);
        this.saveConfig();
    }

    private void buttonRevertToDefaultClicked(Button button) {
        DialogScreen dialog = new DialogScreen(ConfigEntryWidget.REVERT_DEFAULTS, new Component[]{ConfigEntryWidget.REVERT_DEFAULTS_DIALOG_TEXT}, this);
        dialog.onConfirmed(screen -> {
            Configuration.LOGGER.info(MARKER, "Reverting config {} to default values", (Object)this.configId);
            ConfigHolder.getConfig(this.configId).ifPresent(holder -> {
                this.revertToDefault(holder.values());
                ConfigIO.saveClientValues(holder);
            });
            this.backToConfigList();
        });
        this.f_96541_.m_91152_((Screen)dialog);
    }

    private void buttonRevertChangesClicked(Button button) {
        DialogScreen dialog = new DialogScreen(ConfigEntryWidget.REVERT_CHANGES, new Component[]{ConfigEntryWidget.REVERT_CHANGES_DIALOG_TEXT}, this);
        dialog.onConfirmed(screen -> {
            ConfigHolder.getConfig(this.configId).ifPresent(ConfigIO::reloadClientValues);
            this.backToConfigList();
        });
        this.f_96541_.m_91152_((Screen)dialog);
    }

    private void revertToDefault(Collection<ConfigValue<?>> configValues) {
        configValues.forEach(val -> {
            if (val instanceof ObjectValue) {
                ObjectValue objVal = (ObjectValue)val;
                this.revertToDefault(((Map)objVal.get()).values());
            } else {
                val.useDefaultValue();
            }
        });
    }

    private void backToConfigList() {
        this.f_96541_.m_91152_(this.getFirstNonConfigScreen());
        this.saveConfig();
    }

    private void saveConfig() {
        this.saveConfig(false);
    }

    private void saveConfig(boolean force) {
        if (force || !(this.last instanceof AbstractConfigScreen)) {
            ConfigHolder.getConfig(this.configId).ifPresent(ConfigIO::saveClientValues);
        }
    }

    public void renderNotification(NotificationSeverity severity, PoseStack stack, List<FormattedCharSequence> texts, int mouseX, int mouseY) {
        if (!texts.isEmpty()) {
            int maxTextWidth = 0;
            int iconOffset = 13;
            for (FormattedCharSequence textComponent : texts) {
                int textWidth = this.f_96547_.m_92724_(textComponent);
                if (!severity.isOkStatus()) {
                    textWidth += iconOffset;
                }
                if (textWidth <= maxTextWidth) continue;
                maxTextWidth = textWidth;
            }
            int startX = mouseX + 12;
            int startY = mouseY - 12;
            int heightOffset = 8;
            if (texts.size() > 1) {
                heightOffset += 2 + (texts.size() - 1) * 10;
            }
            if (startX + maxTextWidth > this.f_96543_) {
                startX -= 28 + maxTextWidth;
            }
            if (startY + heightOffset + 6 > this.f_96544_) {
                startY = this.f_96544_ - heightOffset - 6;
            }
            stack.m_85836_();
            int background = severity.background;
            int fadeMin = severity.fadeMin;
            int fadeMax = severity.fadeMax;
            int zIndex = 400;
            float blitBackup = this.f_96542_.f_115093_;
            this.f_96542_.f_115093_ = 400.0f;
            Tesselator tessellator = Tesselator.m_85913_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            BufferBuilder bufferbuilder = tessellator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            Matrix4f matrix4f = stack.m_85850_().m_85861_();
            AbstractConfigScreen.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(startX - 3), (int)(startY - 4), (int)(startX + maxTextWidth + 3), (int)(startY - 3), (int)zIndex, (int)background, (int)background);
            AbstractConfigScreen.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(startX - 3), (int)(startY + heightOffset + 3), (int)(startX + maxTextWidth + 3), (int)(startY + heightOffset + 4), (int)zIndex, (int)background, (int)background);
            AbstractConfigScreen.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(startX - 3), (int)(startY - 3), (int)(startX + maxTextWidth + 3), (int)(startY + heightOffset + 3), (int)zIndex, (int)background, (int)background);
            AbstractConfigScreen.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(startX - 4), (int)(startY - 3), (int)(startX - 3), (int)(startY + heightOffset + 3), (int)zIndex, (int)background, (int)background);
            AbstractConfigScreen.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(startX + maxTextWidth + 3), (int)(startY - 3), (int)(startX + maxTextWidth + 4), (int)(startY + heightOffset + 3), (int)zIndex, (int)background, (int)background);
            AbstractConfigScreen.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(startX - 3), (int)(startY - 3 + 1), (int)(startX - 3 + 1), (int)(startY + heightOffset + 3 - 1), (int)zIndex, (int)fadeMin, (int)fadeMax);
            AbstractConfigScreen.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(startX + maxTextWidth + 2), (int)(startY - 3 + 1), (int)(startX + maxTextWidth + 3), (int)(startY + heightOffset + 3 - 1), (int)zIndex, (int)fadeMin, (int)fadeMax);
            AbstractConfigScreen.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(startX - 3), (int)(startY - 3), (int)(startX + maxTextWidth + 3), (int)(startY - 3 + 1), (int)zIndex, (int)fadeMin, (int)fadeMin);
            AbstractConfigScreen.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(startX - 3), (int)(startY + heightOffset + 2), (int)(startX + maxTextWidth + 3), (int)(startY + heightOffset + 3), (int)zIndex, (int)fadeMax, (int)fadeMax);
            RenderSystem.m_69482_();
            RenderSystem.m_69472_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            RenderSystem.m_69493_();
            if (!severity.isOkStatus()) {
                ResourceLocation icon = severity.getIcon();
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)icon);
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                float min = -0.5f;
                float max = 8.5f;
                bufferbuilder.m_85982_(matrix4f, (float)startX + min, (float)startY + min, (float)zIndex).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder.m_85982_(matrix4f, (float)startX + min, (float)startY + max, (float)zIndex).m_7421_(0.0f, 1.0f).m_5752_();
                bufferbuilder.m_85982_(matrix4f, (float)startX + max, (float)startY + max, (float)zIndex).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder.m_85982_(matrix4f, (float)startX + max, (float)startY + min, (float)zIndex).m_7421_(1.0f, 0.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            }
            RenderSystem.m_69461_();
            MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            stack.m_85837_(0.0, 0.0, (double)zIndex);
            int textOffset = severity.isOkStatus() ? 0 : iconOffset;
            for (int i = 0; i < texts.size(); ++i) {
                FormattedCharSequence textComponent = texts.get(i);
                if (textComponent != null) {
                    this.f_96547_.m_92733_(textComponent, (float)startX + (float)textOffset, (float)startY, -1, true, matrix4f, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
                }
                if (i == 0) {
                    startY += 2;
                }
                startY += 10;
            }
            bufferSource.m_109911_();
            stack.m_85849_();
            this.f_96542_.f_115093_ = blitBackup;
        }
    }

    protected <T> void initializeGuiValue(ConfigValue<T> value, IValidationHandler handler) {
        T t = value.get();
        value.setWithValidationHandler(t, handler);
    }
}

