/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.compat;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IRecipeRegistration;
import net.brdle.collectorsreap.Util;
import net.brdle.collectorsreap.common.config.CRConfig;
import net.brdle.collectorsreap.common.item.CRItems;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = Util.cr("jei_plugin");

    public void registerRecipes(IRecipeRegistration registration) {
        List<ItemStack> items = CRItems.ITEMS.getEntries().stream().filter(Predicate.not(CRConfig::verify)).map(Util::gs).toList();
        if (!items.isEmpty()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, items);
        }
        if ((Integer)CRConfig.CHANCE_PORTOBELLO.get() > 0 && CRConfig.verify(CRItems.PORTOBELLO)) {
            registration.addItemStackInfo(Util.gs(CRItems.PORTOBELLO), new Component[]{Component.m_237115_((String)("desc.collectorsreap." + Util.name(CRItems.PORTOBELLO)))});
        }
        if ((Integer)CRConfig.CHANCE_LIME_BUSH.get() > 0 && CRConfig.verify(CRItems.LIME)) {
            registration.addItemStackInfo(Util.gs(CRItems.LIME), new Component[]{Component.m_237115_((String)("desc.collectorsreap." + Util.name(CRItems.LIME)))});
        }
        if ((Integer)CRConfig.CHANCE_POMEGRANATE_BUSH.get() > 0 && CRConfig.verify(CRItems.POMEGRANATE)) {
            registration.addItemStackInfo(Util.gs(CRItems.POMEGRANATE), new Component[]{Component.m_237115_((String)("desc.collectorsreap." + Util.name(CRItems.POMEGRANATE)))});
        }
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return ID;
    }
}

