/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.common.block;

import net.brdle.collectorsreap.Util;
import net.brdle.collectorsreap.common.block.CRBlocks;
import net.brdle.collectorsreap.common.block.LimeBushBlock;
import net.brdle.collectorsreap.common.item.CRItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;

public class SmallLimeBushBlock
extends BushBlock
implements BonemealableBlock {
    public static final int MAX_AGE = 1;
    public static final IntegerProperty AGE = BlockStateProperties.f_61405_;
    public static final VoxelShape SMALL_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0);
    private static final VoxelShape MEDIUM_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0));

    public SmallLimeBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return (Integer)state.m_61143_((Property)AGE) == 1 ? MEDIUM_SHAPE : SMALL_SHAPE;
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return this.m_5940_(pState, pLevel, pPos, pContext);
    }

    @NotNull
    public ItemStack m_7397_(@NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull BlockState state) {
        return Util.gs(CRItems.LIME_SEEDS);
    }

    protected boolean m_6266_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return state.m_204336_(BlockTags.f_144274_);
    }

    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader level, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        return this.m_6266_(level.m_8055_(below), (BlockGetter)level, below);
    }

    public boolean m_6724_(@NotNull BlockState state) {
        return true;
    }

    public void m_213898_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, RandomSource random) {
        if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(20) == 0 ? 1 : 0) != 0)) {
            this.m_214148_(level, random, pos, state);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{AGE});
    }

    public boolean m_7370_(@NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(@NotNull Level world, @NotNull RandomSource rand, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    public void m_214148_(@NotNull ServerLevel world, @NotNull RandomSource pRandom, @NotNull BlockPos pPos, BlockState pState) {
        int i = (Integer)pState.m_61143_((Property)AGE);
        if (i < 1) {
            BlockState newState = (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(Math.min(1, (Integer)pState.m_61143_((Property)AGE) + 1)));
            world.m_7731_(pPos, newState, 2);
            world.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223722_((BlockState)newState));
        } else if (world.m_46859_(pPos.m_7494_())) {
            world.m_46597_(pPos, ((Block)CRBlocks.LIME_BUSH.get()).m_49966_());
            world.m_46597_(pPos.m_7494_(), (BlockState)((Block)CRBlocks.LIME_BUSH.get()).m_49966_().m_61124_(LimeBushBlock.HALF, (Comparable)DoubleBlockHalf.UPPER));
        }
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 60;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 30;
    }
}

