/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.common.block;

import javax.annotation.Nullable;
import net.brdle.collectorsreap.common.block.IFruiting;
import net.brdle.collectorsreap.common.config.CRConfig;
import net.brdle.collectorsreap.common.item.CRItems;
import net.brdle.collectorsreap.data.CRBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class PomegranateBushBlock
extends CropBlock
implements IFruiting {
    public static final int MAX_AGE = 2;
    public static final IntegerProperty AGE = BlockStateProperties.f_61406_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    private static final VoxelShape SHAPE_LOWER = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape SHAPE_UPPER = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public PomegranateBushBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @NotNull
    public IntegerProperty m_7959_() {
        return AGE;
    }

    public int m_7419_() {
        return 2;
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        EntityCollisionContext ent;
        if (pContext instanceof EntityCollisionContext && (ent = (EntityCollisionContext)pContext).m_193113_() instanceof Bee && ((Boolean)CRConfig.POMEGRANATE_POLLINATION.get()).booleanValue()) {
            return pState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0) : Shapes.m_83040_();
        }
        return this.m_5940_(pState, pLevel, pPos, pContext);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? SHAPE_UPPER : SHAPE_LOWER;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos facingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (facing.m_122434_() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            return facingState.m_60713_((Block)this) && facingState.m_61143_(HALF) != doubleblockhalf ? (BlockState)state.m_61124_((Property)AGE, (Comparable)((Integer)facingState.m_61143_((Property)AGE))) : Blocks.f_50016_.m_49966_();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, world, pos, facingPos);
    }

    protected boolean m_6266_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos) {
        return pState.m_204336_(BlockTags.f_144274_) || pState.m_204336_(CRBlockTags.POMEGRANATE_FAST_ON);
    }

    public boolean m_7898_(BlockState state, @NotNull LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? this.m_6266_(level.m_8055_(blockpos), (BlockGetter)level, blockpos) : state.m_60713_((Block)this);
    }

    @NotNull
    protected ItemLike m_6404_() {
        return (ItemLike)CRItems.POMEGRANATE_SEEDS.get();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack(((Integer)state.m_61143_((Property)AGE)).intValue() == this.m_7419_() ? (ItemLike)CRItems.POMEGRANATE.get() : this.m_6404_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{AGE, HALF});
    }

    public boolean m_6724_(BlockState pState) {
        return (Integer)pState.m_61143_((Property)AGE) < this.m_7419_();
    }

    public void m_213898_(@NotNull BlockState state, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        if ((Integer)state.m_61143_((Property)AGE) < this.m_7419_() && state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            int growthRate;
            int n = growthRate = pLevel.m_8055_(pPos.m_7495_()).m_204336_(CRBlockTags.POMEGRANATE_FAST_ON) ? 9 : 13;
            if (pLevel.m_46472_() == Level.f_46429_) {
                growthRate -= 4;
            } else if ((Integer)state.m_61143_((Property)AGE) != 0 && ((Boolean)CRConfig.POMEGRANATE_POLLINATION.get()).booleanValue()) {
                return;
            }
            if (ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)state, (pRandom.m_188503_(growthRate) == 0 ? 1 : 0) != 0)) {
                this.m_214148_(pLevel, pRandom, pPos, state);
                ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)state);
            }
        }
    }

    @Override
    public Item getFruit() {
        return (Item)CRItems.POMEGRANATE.get();
    }

    @Override
    public int getNumFruit(Level level) {
        return 1 + level.m_213780_().m_188503_(2);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        if (((Integer)pState.m_61143_((Property)AGE)).intValue() == this.m_7419_()) {
            if (!pPlayer.m_21120_(pHand).m_204117_(Tags.Items.SHEARS)) {
                pPlayer.m_6469_(DamageSource.f_19325_, 1.0f);
            }
            this.dropResources(pLevel, pPos);
            pLevel.m_5594_(null, pPos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + pLevel.m_213780_().m_188501_() * 0.4f);
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
            return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public boolean m_7370_(@NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, boolean pIsClient) {
        return false;
    }

    public boolean m_214167_(@NotNull Level pLevel, @NotNull RandomSource pRandom, @NotNull BlockPos pPos, @NotNull BlockState pState) {
        return false;
    }

    public void m_214148_(ServerLevel pLevel, @NotNull RandomSource pRandom, @NotNull BlockPos pPos, BlockState pState) {
        pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(Math.min(this.m_7419_(), (Integer)pState.m_61143_((Property)AGE) + 1))));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos blockpos = pContext.m_8083_();
        return blockpos.m_123342_() < 255 && pContext.m_43725_().m_8055_(blockpos.m_7494_()).m_60629_(pContext) ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER) : null;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, @NotNull ItemStack pStack) {
        pLevel.m_7731_(pPos.m_7494_(), (BlockState)pState.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public static void placeAt(LevelAccessor pLevel, BlockState pState, BlockPos pPos, int pFlags) {
        pLevel.m_7731_(pPos, (BlockState)((BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(2))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER), pFlags);
        pLevel.m_7731_(pPos.m_7494_(), (BlockState)((BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(2))).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), pFlags);
    }

    public void m_5707_(Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull Player pPlayer) {
        if (!pLevel.m_5776_()) {
            if (pPlayer.m_7500_()) {
                this.preventCreativeDropFromBottomPart(HALF, pLevel, pPos, pState, pPlayer);
            } else if (((Integer)pState.m_61143_((Property)AGE)).intValue() == this.m_7419_()) {
                if (!pPlayer.m_21205_().m_204117_(Tags.Items.SHEARS)) {
                    pPlayer.m_6469_(DamageSource.f_19325_, 1.0f);
                }
                this.dropResources(pLevel, pPos);
            }
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public void m_7892_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Entity e) {
        if (!pLevel.m_5776_() && ((Boolean)CRConfig.POMEGRANATE_POLLINATION.get()).booleanValue() && ((Boolean)CRConfig.FAST_POLLINATE.get()).booleanValue() && e instanceof Bee && (Integer)pState.m_61143_((Property)AGE) == this.m_7419_() - 1 && pLevel.m_213780_().m_188503_(150) == 0) {
            this.m_214148_((ServerLevel)pLevel, pLevel.m_213780_(), pPos, pState);
        }
    }
}

