/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.common;

import java.util.List;
import java.util.Objects;
import net.brdle.collectorsreap.Util;
import net.brdle.collectorsreap.common.CRParticleTypes;
import net.brdle.collectorsreap.common.block.CRBlocks;
import net.brdle.collectorsreap.common.config.CRConfig;
import net.brdle.collectorsreap.common.effect.CREffects;
import net.brdle.collectorsreap.common.item.CRItems;
import net.brdle.collectorsreap.data.CREntityTags;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;

@Mod.EventBusSubscriber(modid="collectorsreap")
public class ForgeEvents {
    @SubscribeEvent
    public static void onMissingMappings(MissingMappingsEvent e) {
        block6: {
            block5: {
                if (e.getRegistry() != ForgeRegistries.ITEMS) break block5;
                for (MissingMappingsEvent.Mapping map : e.getMappings(ForgeRegistries.ITEMS.getRegistryKey(), "collectorsreap")) {
                    ResourceLocation remap = Util.cr(map.getKey().m_135815_().replace("lemon", "lime"));
                    if (ForgeRegistries.ITEMS.containsKey(remap)) {
                        map.remap((Object)((Item)ForgeRegistries.ITEMS.getValue(remap)));
                        continue;
                    }
                    map.warn();
                }
                break block6;
            }
            if (e.getRegistry() != ForgeRegistries.BLOCKS) break block6;
            for (MissingMappingsEvent.Mapping map : e.getMappings(ForgeRegistries.BLOCKS.getRegistryKey(), "collectorsreap")) {
                String path = map.getKey().m_135815_();
                if (path.equalsIgnoreCase("medium_lime_bush") || path.equalsIgnoreCase("medium_lemon_bush")) {
                    map.remap((Object)((Block)CRBlocks.LIME_BUSH.get()));
                    continue;
                }
                ResourceLocation remap = Util.cr(path.replace("lemon", "lime"));
                if (ForgeRegistries.BLOCKS.containsKey(remap)) {
                    map.remap((Object)((Block)ForgeRegistries.BLOCKS.getValue(remap)));
                    continue;
                }
                map.warn();
            }
        }
    }

    @SubscribeEvent
    public static void onWanderingTrader(WandererTradesEvent e) {
        if (CRConfig.verify(CRItems.LIME) && CRConfig.verify(CRItems.LIME_SEEDS)) {
            e.getGenericTrades().add((ent, r) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 1), Util.gs(CRItems.LIME_SEEDS), 5, 1, 1.0f));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onCorrodeWeapon(LivingDamageEvent e) {
        InteractionHand hand;
        Player p;
        ItemStack stack;
        Entity entity;
        if (e.getEntity().m_21023_((MobEffect)CREffects.CORROSION.get()) && (entity = e.getSource().m_7639_()) instanceof Player && (stack = (p = (Player)entity).m_21120_(hand = p.m_7655_())).m_41763_()) {
            int damage = Objects.requireNonNull(e.getEntity().m_21124_((MobEffect)CREffects.CORROSION.get())).m_19564_();
            stack.m_41622_(damage, (LivingEntity)p, en -> en.m_21190_(hand));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onCorrodeProjectile(ProjectileImpactEvent e) {
        LivingEntity victim;
        Entity entity;
        if (e.getRayTraceResult().m_6662_() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)e.getRayTraceResult()).m_82443_()) instanceof LivingEntity && (victim = (LivingEntity)entity).m_21023_((MobEffect)CREffects.CORROSION.get())) {
            Level level;
            Projectile proj = e.getProjectile();
            if (proj.m_6095_().m_204039_(CREntityTags.CORROSION_IMMUNE)) {
                return;
            }
            e.setCanceled(true);
            if (!proj.m_9236_().m_5776_() && (level = proj.m_9236_()) instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                for (int i = 0; i < 3; ++i) {
                    server.m_8767_((ParticleOptions)((SimpleParticleType)CRParticleTypes.ACID.get()), proj.m_20208_(0.3), proj.m_20187_(), proj.m_20262_(0.3), 1, 0.0, 0.0, 0.0, 0.0);
                }
                victim.m_5496_(SoundEvents.f_12374_, 0.4f, 1.1f);
                if (proj instanceof ThrownTrident) {
                    ThrownTrident trident = (ThrownTrident)proj;
                    trident.f_37555_.m_220157_(5 * Objects.requireNonNull(victim.m_21124_((MobEffect)CREffects.CORROSION.get())).m_19564_(), trident.m_9236_().m_213780_(), null);
                } else {
                    proj.m_146870_();
                    proj.m_146850_(GameEvent.f_223707_);
                }
            }
        }
    }

    private static boolean validateVolatile(LivingEntity victim, LivingEntity attacker) {
        Player p;
        return victim != null && attacker.m_21023_((MobEffect)CREffects.VOLATILITY.get()) && !attacker.m_6095_().m_204039_(CREntityTags.INVOLATILE) && (!(attacker instanceof Player) || !(p = (Player)attacker).m_36335_().m_41519_(p.m_21205_().m_41720_()));
    }

    @SubscribeEvent
    public static void onVolatile(LivingDamageEvent e) {
        Level level;
        LivingEntity victim = e.getEntity();
        if (e.getSource().m_7639_() != null && !victim.m_9236_().m_5776_() && (level = victim.m_9236_()) instanceof ServerLevel) {
            LivingEntity attacker;
            ServerLevel server = (ServerLevel)level;
            level = e.getSource().m_7639_();
            if (level instanceof LivingEntity && ForgeEvents.validateVolatile(victim, attacker = (LivingEntity)level)) {
                server.m_8767_((ParticleOptions)((SimpleParticleType)CRParticleTypes.SHOCKWAVE.get()), victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                int level2 = Objects.requireNonNull(attacker.m_21124_((MobEffect)CREffects.VOLATILITY.get())).m_19564_();
                List nearby = server.m_45971_(LivingEntity.class, TargetingConditions.f_26872_.m_26888_(living -> {
                    TamableAnimal tame;
                    return living != attacker && living != victim && !living.m_6095_().m_204039_(CREntityTags.VOLATILITY_IMMUNE) && (!(living instanceof TamableAnimal) || !(tame = (TamableAnimal)living).m_21824_());
                }), victim, victim.m_20191_().m_82377_(4.0 + (double)level2, 2.0, 4.0 + (double)level2)).stream().limit(3 + level2).toList();
                if (nearby.isEmpty()) {
                    return;
                }
                if (attacker instanceof Player) {
                    Player p = (Player)attacker;
                    p.m_36335_().m_41524_(p.m_21205_().m_41720_(), 40);
                }
                for (LivingEntity ent : nearby) {
                    Vec3 vec32 = ent.m_146892_().m_82546_(victim.m_20182_().m_82520_(0.0, 1.0, 0.0)).m_82541_();
                    ent.m_5496_(SoundEvents.f_12090_, 0.2f, 1.75f);
                    ent.m_6469_(e.getSource(), (e.getAmount() + (float)(level2 - 1) * 0.65f) / (float)nearby.size());
                    double d1 = (1.0 - ent.m_21133_(Attributes.f_22278_)) * 0.75;
                    ent.m_5997_(vec32.m_7096_() * d1, vec32.m_7098_() * d1 * 0.35, vec32.m_7094_() * d1);
                }
            }
        }
    }
}

