/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.util.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.item.Item;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.tnt.collectoralbum.common.init.ItemRegistry;
import team.tnt.collectoralbum.common.item.CardRarity;
import team.tnt.collectoralbum.common.item.ICard;

public class CardTagGen {
    private static final File EXPORT_DIR = new File("./exported/datagen/card_tags");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LogManager.getLogger(CardTagGen.class);

    public static void main(String[] args) {
        try {
            new CardTagGen().run(ItemRegistry.class);
        }
        catch (Exception e) {
            LOGGER.fatal("Error:", (Throwable)e);
        }
    }

    private void run(Class<?> itemRegistry) throws Exception {
        Field[] fields = itemRegistry.getFields();
        LOGGER.info("Mapping cards to their ids from {} class", (Object)itemRegistry.getName());
        Map<String, ICard> itemId2CardMap = Arrays.stream(fields).filter(field -> this.isConstant((Field)field) && Item.class.isAssignableFrom(field.getType()) && ICard.class.isAssignableFrom(field.getType())).collect(Collectors.toMap(Field::getName, field -> {
            try {
                return (ICard)field.get(ICard.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
        LOGGER.info("Mapped cards to id -> card map, total {} entries", (Object)itemId2CardMap.size());
        LOGGER.info("Splitting cards by their rarities");
        EnumMap<CardRarity, List> idsByCategory = new EnumMap<CardRarity, List>(CardRarity.class);
        for (Map.Entry<String, ICard> entry : itemId2CardMap.entrySet()) {
            String id = "collectorsalbum:" + entry.getKey().toLowerCase();
            ICard card = entry.getValue();
            CardRarity rarity = card.getCardRarity();
            List list = idsByCategory.computeIfAbsent(rarity, k -> new ArrayList());
            list.add(id);
        }
        LOGGER.info("Card rarity map dump:");
        idsByCategory.forEach((key, value) -> LOGGER.info("Rarity: {}, Count: {}", (Object)key, (Object)value.size()));
        LOGGER.info("Writing output files");
        EXPORT_DIR.mkdirs();
        idsByCategory.forEach((key, value) -> {
            File tagFile = new File(EXPORT_DIR, "cards_" + key.name().toLowerCase() + ".json");
            try {
                tagFile.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            JsonObject obj = new JsonObject();
            obj.addProperty("replace", Boolean.valueOf(false));
            JsonArray array = new JsonArray();
            value.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            obj.add("values", (JsonElement)array);
            try (FileWriter fw = new FileWriter(tagFile);){
                String jsonString = GSON.toJson((JsonElement)obj);
                fw.write(jsonString);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        LOGGER.info("Tag gen finished");
    }

    private boolean isConstant(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }
}

