/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.util.datagen;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.tnt.collectoralbum.common.init.CardRegistry;
import team.tnt.collectoralbum.common.item.CardRarity;

public class CardItemCodeGen {
    private static final File CARD_ITEM_DIR = new File("./run/exported/cards");
    private static final Logger LOGGER = LogManager.getLogger(CardItemCodeGen.class);

    public static void main(String[] args) {
        try {
            new CardItemCodeGen().run(CardRegistry.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void run(Class<?> cardRegistry) throws Exception {
        LOGGER.info("Running CardItemCode generator");
        LOGGER.info("Retrieving all cards from registry");
        Field[] cardFields = cardRegistry.getFields();
        LOGGER.info("Retrieving field names");
        String[] cardIds = (String[])Arrays.stream(cardFields).filter(field -> {
            int modifiers = field.getModifiers();
            return Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
        }).map(Field::getName).toArray(String[]::new);
        ArrayList<String> variables = new ArrayList<String>();
        ArrayList<String> registration = new ArrayList<String>();
        LOGGER.info("Generating...");
        for (String card : cardIds) {
            LOGGER.info("Running generator for {} card", (Object)card);
            for (CardRarity rarity : CardRarity.values()) {
                String rarityName = rarity.name().toLowerCase();
                String fieldName = card.toLowerCase();
                String itemId = String.format("%s_%s", rarityName, fieldName);
                String variableLine = String.format("public static final CardItem %s = new CardItem(CardRarity.%s, CardRegistry.%s);", itemId.toUpperCase(), rarity.name(), card);
                LOGGER.info("Generated constant code line: {}", (Object)variableLine);
                String registrationLine = String.format("registerItem(\"%s\", %s);", itemId, itemId.toUpperCase());
                LOGGER.info("Generated registration code line: {}", (Object)registrationLine);
                variables.add(variableLine);
                registration.add(registrationLine);
            }
            LOGGER.info("Generator finished for {} card", (Object)card);
        }
        LOGGER.info("Writing output files...");
        File variableOut = new File(CARD_ITEM_DIR, "variables.txt");
        File registrationOut = new File(CARD_ITEM_DIR, "registration.txt");
        CARD_ITEM_DIR.mkdirs();
        variableOut.createNewFile();
        registrationOut.createNewFile();
        try (PrintWriter writer = new PrintWriter(new FileWriter(variableOut));){
            variables.forEach(writer::println);
        }
        writer = new PrintWriter(new FileWriter(registrationOut));
        try {
            registration.forEach(writer::println);
        }
        finally {
            writer.close();
        }
        LOGGER.info("Output files generated in {}", (Object)CARD_ITEM_DIR.getAbsolutePath());
    }
}

