/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.network.packet;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import team.tnt.collectoralbum.common.ICardCategory;
import team.tnt.collectoralbum.common.container.AlbumContainer;
import team.tnt.collectoralbum.common.init.CardCategoryRegistry;
import team.tnt.collectoralbum.common.init.ItemRegistry;
import team.tnt.collectoralbum.common.menu.AlbumMenu;
import team.tnt.collectoralbum.network.packet.AbstractNetworkPacket;

public class RequestAlbumPagePacket
extends AbstractNetworkPacket<RequestAlbumPagePacket> {
    private final ICardCategory category;

    public RequestAlbumPagePacket() {
        this(null);
    }

    public RequestAlbumPagePacket(ICardCategory category) {
        this.category = category;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.category != null);
        if (this.category != null) {
            buffer.m_130085_(this.category.getId());
        }
    }

    @Override
    public RequestAlbumPagePacket decode(FriendlyByteBuf buffer) {
        boolean flag = buffer.readBoolean();
        ICardCategory category = null;
        if (flag) {
            category = CardCategoryRegistry.getByKey(buffer.m_130281_());
        }
        return new RequestAlbumPagePacket(category);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ItemStack stack = context.getSender().m_21205_();
        if (stack.m_41720_() != ItemRegistry.ALBUM.get()) {
            return;
        }
        AlbumContainer container = new AlbumContainer(stack);
        ICardCategory category = this.category;
        NetworkHooks.openScreen((ServerPlayer)context.getSender(), (MenuProvider)new SimpleMenuProvider((id, inv, player) -> new AlbumMenu(container, inv, id, category), CommonComponents.f_237098_), buffer -> {
            buffer.m_130055_(stack);
            buffer.writeBoolean(category != null);
            if (category != null) {
                buffer.m_130085_(category.getId());
            }
        });
    }
}

