/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.network;

import java.lang.reflect.InvocationTargetException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import team.tnt.collectoralbum.network.api.IPacket;
import team.tnt.collectoralbum.network.packet.OpenCardScreenPacket;
import team.tnt.collectoralbum.network.packet.RequestAlbumPagePacket;
import team.tnt.collectoralbum.network.packet.RequestCardPackDropPacket;
import team.tnt.collectoralbum.network.packet.SendAlbumBoostsPacket;

public class Networking {
    private static final String NETWORK_PROTOCOL_VERSION = "collectorsalbum-v1";
    private static final SimpleChannel NETWORK_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("collectorsalbum", "network"), () -> "collectorsalbum-v1", "collectorsalbum-v1"::equals, "collectorsalbum-v1"::equals);
    private static byte packetId;

    public static void dispatchServerPacket(IPacket<?> packet) {
        NETWORK_CHANNEL.sendToServer(packet);
    }

    public static void dispatchClientPacket(ServerPlayer serverPlayerRef, IPacket<?> packet) {
        NETWORK_CHANNEL.sendTo(packet, serverPlayerRef.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void registerPackets() {
        Networking.registerPacket(OpenCardScreenPacket.class);
        Networking.registerPacket(RequestAlbumPagePacket.class);
        Networking.registerPacket(RequestCardPackDropPacket.class);
        Networking.registerPacket(SendAlbumBoostsPacket.class);
    }

    private static <T extends IPacket<T>> void registerPacket(Class<T> packetClass) {
        IPacket instance;
        try {
            instance = (IPacket)packetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        byte by = packetId;
        packetId = (byte)(by + 1);
        NETWORK_CHANNEL.registerMessage((int)by, packetClass, IPacket::encode, instance::decode, IPacket::handle);
    }
}

