/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.integration;

import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import team.tnt.collectoralbum.common.CardCategoryIndexPool;
import team.tnt.collectoralbum.common.CardDefinition;
import team.tnt.collectoralbum.common.item.CardRarity;
import team.tnt.collectoralbum.common.item.ICard;
import vazkii.quark.api.ICustomSorting;
import vazkii.quark.api.QuarkCapabilities;

public final class QuarkIntegration {
    public static final ICustomSorting CARD_SORTING = new CardSorter();

    public static ICapabilityProvider getCardsCapabilityProvider(ItemStack stack, @Nullable CompoundTag nbt) {
        return CustomSortProvider.INSTANCE;
    }

    private static class CustomSortProvider
    implements ICapabilityProvider {
        private static final CustomSortProvider INSTANCE = new CustomSortProvider();
        private final LazyOptional<ICustomSorting> capability = LazyOptional.of(() -> CARD_SORTING);

        private CustomSortProvider() {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return cap == QuarkCapabilities.SORTING ? this.capability.cast() : LazyOptional.empty();
        }
    }

    private static class CardSorter
    implements ICustomSorting {
        private static final String CATEGORY = "collectorsalbum:cards";

        private CardSorter() {
        }

        public String getSortingCategory() {
            return CATEGORY;
        }

        public Comparator<ItemStack> getItemComparator() {
            return (i1, i2) -> {
                int b;
                if (!(i1.m_41720_() instanceof ICard) || !(i2.m_41720_() instanceof ICard)) {
                    return 0;
                }
                ICard card1 = (ICard)i1.m_41720_();
                ICard card2 = (ICard)i2.m_41720_();
                CardDefinition def1 = card1.getCard();
                CardDefinition def2 = card2.getCard();
                int a = CardCategoryIndexPool.getIndexOffset(def1.category()) + def1.cardNumber();
                if (a == (b = CardCategoryIndexPool.getIndexOffset(def2.category()) + def2.cardNumber())) {
                    CardRarity rar1 = card1.getCardRarity();
                    CardRarity rar2 = card2.getCardRarity();
                    return rar2.ordinal() - rar1.ordinal();
                }
                return a - b;
            };
        }
    }
}

