/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.data.packs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import team.tnt.collectoralbum.data.packs.CardDropProviderType;
import team.tnt.collectoralbum.data.packs.ICardDropProvider;
import team.tnt.collectoralbum.data.packs.ICardDropSerializer;
import team.tnt.collectoralbum.util.JsonHelper;
import team.tnt.collectoralbum.util.math.WeightedRandom;

public class WeightedDropProvider
implements ICardDropProvider {
    private final WeightedRandom<Entry> randomProvider;

    private WeightedDropProvider(Entry[] entries) {
        this.randomProvider = WeightedRandom.create((WeightedRandom.IWeighted[])entries);
    }

    @Override
    public List<ItemStack> provideDrops() {
        Entry providerEntry = this.randomProvider.get();
        ICardDropProvider provider = providerEntry.provider();
        return provider.provideDrops();
    }

    private record Entry(int value, ICardDropProvider provider) implements WeightedRandom.IWeighted
    {
        @Override
        public int getWeight() {
            return this.value;
        }

        static Entry fromJson(JsonElement element) throws JsonParseException {
            JsonObject data = JsonHelper.asObject(element);
            int weight = GsonHelper.m_13824_((JsonObject)data, (String)"weight", (int)1);
            JsonObject provider = GsonHelper.m_13930_((JsonObject)data, (String)"provider");
            Object cardDropProvider = CardDropProviderType.fromJson((JsonElement)provider);
            return new Entry(weight, (ICardDropProvider)cardDropProvider);
        }
    }

    public static final class Serializer
    implements ICardDropSerializer<WeightedDropProvider> {
        @Override
        public WeightedDropProvider fromJson(JsonElement data) throws JsonParseException {
            JsonObject object = JsonHelper.asObject(data);
            JsonArray array = GsonHelper.m_13933_((JsonObject)object, (String)"providers");
            Entry[] entries = JsonHelper.resolveArray(array, Entry[]::new, Entry::fromJson);
            return new WeightedDropProvider(entries);
        }
    }
}

