/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.data.packs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import team.tnt.collectoralbum.data.packs.CardDropProviderType;
import team.tnt.collectoralbum.data.packs.ICardDropProvider;
import team.tnt.collectoralbum.data.packs.ICardDropSerializer;
import team.tnt.collectoralbum.util.JsonHelper;

public class MultiDropProvider
implements ICardDropProvider {
    private final ICardDropProvider[] nestedProviders;

    private MultiDropProvider(ICardDropProvider[] nestedProviders) {
        this.nestedProviders = nestedProviders;
    }

    @Override
    public List<ItemStack> provideDrops() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ICardDropProvider provider : this.nestedProviders) {
            list.addAll(provider.provideDrops());
        }
        return list;
    }

    public static final class Serializer
    implements ICardDropSerializer<MultiDropProvider> {
        @Override
        public MultiDropProvider fromJson(JsonElement data) throws JsonParseException {
            JsonObject object = JsonHelper.asObject(data);
            JsonArray array = GsonHelper.m_13933_((JsonObject)object, (String)"providers");
            ICardDropProvider[] providers = JsonHelper.resolveArray(array, ICardDropProvider[]::new, CardDropProviderType::fromJson);
            return new MultiDropProvider(providers);
        }
    }
}

