/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.data.boosts;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import team.tnt.collectoralbum.common.AlbumStats;
import team.tnt.collectoralbum.common.init.CardBoostConditionRegistry;
import team.tnt.collectoralbum.data.boosts.CardBoostConditionType;
import team.tnt.collectoralbum.data.boosts.CardsCondition;
import team.tnt.collectoralbum.data.boosts.IBoostContext;
import team.tnt.collectoralbum.data.boosts.ICardBoostCondition;
import team.tnt.collectoralbum.data.boosts.ICardBoostConditionSerializer;
import team.tnt.collectoralbum.data.boosts.IDescriptionProvider;
import team.tnt.collectoralbum.util.JsonHelper;

public class PointsCondition
implements ICardBoostCondition {
    private final int minPoints;
    private final Component[] description;

    private PointsCondition(int minPoints) {
        this.minPoints = minPoints;
        this.description = new Component[]{this.getDescriptionText()};
    }

    @Override
    public CardBoostConditionType<?> getType() {
        return CardBoostConditionRegistry.POINTS;
    }

    @Override
    public boolean isValid(IBoostContext context) {
        AlbumStats stats = context.get("stats", AlbumStats.class);
        int points = stats.getPoints();
        return points >= this.minPoints;
    }

    @Override
    public Component[] getDescription() {
        return this.description;
    }

    @Override
    public int compareTo(@NotNull IDescriptionProvider o) {
        if (o instanceof CardsCondition) {
            return -1;
        }
        if (o instanceof PointsCondition) {
            PointsCondition c = (PointsCondition)o;
            return this.minPoints - c.minPoints;
        }
        return 0;
    }

    private Component getDescriptionText() {
        MutableComponent points = Component.m_237113_((String)String.valueOf(this.minPoints)).m_130940_(ChatFormatting.AQUA);
        return Component.m_237110_((String)"text.collectorsalbum.album.boost.condition.points", (Object[])new Object[]{points}).m_130940_(ChatFormatting.GRAY);
    }

    public static final class Serializer
    implements ICardBoostConditionSerializer<PointsCondition> {
        @Override
        public PointsCondition fromJson(JsonElement element) throws JsonParseException {
            JsonObject object = JsonHelper.asObject(element);
            int minPoints = GsonHelper.m_13927_((JsonObject)object, (String)"points");
            return new PointsCondition(minPoints);
        }

        @Override
        public void networkEncode(PointsCondition condition, FriendlyByteBuf buffer) {
            buffer.writeInt(condition.minPoints);
        }

        @Override
        public PointsCondition networkDecode(CardBoostConditionType<PointsCondition> type, FriendlyByteBuf buffer) {
            return new PointsCondition(buffer.readInt());
        }
    }
}

