/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.common;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;
import team.tnt.collectoralbum.api.CardSlotDefinition;
import team.tnt.collectoralbum.api.ICategorySlotDistributor;
import team.tnt.collectoralbum.api.ISlotAppender;
import team.tnt.collectoralbum.common.CardCategoryIndexPool;
import team.tnt.collectoralbum.common.ICardCategory;

public class CardCategory
implements ICardCategory,
Comparable<ICardCategory> {
    public static final ICategorySlotDistributor DISTRIBUTOR = new SlotDistributor();
    private final int categoryIndex = CardCategoryIndexPool.assignUniqueIndex();
    private final ResourceLocation id;
    private final ChatFormatting formatting;
    private final Component translatedName;

    public CardCategory(ResourceLocation id, ChatFormatting formatting) {
        this.id = id;
        this.formatting = formatting;
        String identifier = id.toString().replaceAll(":", ".");
        this.translatedName = Component.m_237115_((String)("card.category." + identifier));
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public int getIndex() {
        return this.categoryIndex;
    }

    @Override
    public int getCapacity() {
        return 30;
    }

    @Override
    public ICategorySlotDistributor getMenuSlotDistributor() {
        return DISTRIBUTOR;
    }

    @Override
    public ChatFormatting getTooltipFormat() {
        return this.formatting;
    }

    @Override
    public Component getTranslatedName() {
        return this.translatedName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardCategory that = (CardCategory)o;
        return this.categoryIndex == that.categoryIndex;
    }

    public int hashCode() {
        return Objects.hash(this.categoryIndex);
    }

    @Override
    public int compareTo(@NotNull ICardCategory o) {
        return this.categoryIndex - o.getIndex();
    }

    private static final class SlotDistributor
    implements ICategorySlotDistributor {
        private SlotDistributor() {
        }

        @Override
        public void distributeSlot(ISlotAppender<CardSlotDefinition> appender, int index, int cardIndexOffset) {
            int cardNumber = cardIndexOffset + index;
            int slotX = index < 15 ? 31 + index % 3 * 41 : 170 + (index - 15) % 3 * 41;
            int slotY = 21 + index % 15 / 3 * 29;
            appender.appendSlot(new CardSlotDefinition(index, slotX, slotY, cardNumber));
        }

        @Override
        public void addPlayerSlots(ISlotAppender<Slot> appender, Inventory inventory) {
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    int slotId = x + y * 9 + 9;
                    appender.appendSlot(new Slot((Container)inventory, slotId, 73 + x * 18, 176 + y * 18));
                }
            }
            for (int x = 0; x < 9; ++x) {
                appender.appendSlot(new Slot((Container)inventory, x, 73 + x * 18, 234));
            }
        }
    }
}

