/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.client.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import team.tnt.collectoralbum.CollectorsAlbum;
import team.tnt.collectoralbum.client.screen.ITickableWidget;
import team.tnt.collectoralbum.common.item.ICard;
import team.tnt.collectoralbum.network.Networking;
import team.tnt.collectoralbum.network.packet.RequestCardPackDropPacket;

public class CardOpenScreen
extends Screen {
    private static final ResourceLocation CARD_BACK = new ResourceLocation("collectorsalbum", "textures/screen/card_back.png");
    private final List<ITickableWidget> tickableWidgets = new ArrayList<ITickableWidget>();
    private final List<ItemStack> drops;
    private int flipsRemaining;

    public CardOpenScreen(List<ItemStack> drops) {
        super((Component)Component.m_237113_((String)"Card Open Screen"));
        this.drops = drops;
        Collections.shuffle(this.drops);
    }

    protected void m_7856_() {
        int total;
        this.tickableWidgets.clear();
        this.flipsRemaining = total = this.drops.size();
        int deckWidth = (total - 1) * 65 + 64;
        int left = (this.f_96543_ - deckWidth) / 2;
        int top = (this.f_96544_ - 64) / 2;
        for (int i = 0; i < total; ++i) {
            int desiredX = left + i * 65;
            CardWidget widget = this.m_142416_(new CardWidget(this.f_96543_ - 70 + i * 7, this.f_96544_ - 70, 64, 64, desiredX, top, this.drops.get(i)));
            widget.setAnimTime(15);
            widget.setFlipTime(15);
            widget.setClickResponder(this::cardFlipped);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.flipsRemaining == 0) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7379_() {
        super.m_7379_();
        boolean requireAll = CollectorsAlbum.config.requireTurnAllCards;
        if (!requireAll || this.flipsRemaining == 0) {
            Networking.dispatchServerPacket(new RequestCardPackDropPacket());
        }
    }

    public void m_86600_() {
        this.tickableWidgets.forEach(ITickableWidget::tickWidget);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public boolean m_7043_() {
        return false;
    }

    protected <T extends GuiEventListener & Widget> T m_142416_(T widget) {
        if (widget instanceof ITickableWidget) {
            ITickableWidget tickable = (ITickableWidget)widget;
            this.tickableWidgets.add(tickable);
        }
        return (T)super.m_142416_(widget);
    }

    private void cardFlipped(CardWidget widget) {
        --this.flipsRemaining;
    }

    public static void renderTexture(Matrix4f pose, float x1, float y1, float x2, float y2) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_85982_(pose, x1, y1, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        bufferBuilder.m_85982_(pose, x1, y2, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        bufferBuilder.m_85982_(pose, x2, y2, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilder.m_85982_(pose, x2, y1, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69461_();
    }

    private static final class CardWidget
    extends AbstractWidget
    implements ITickableWidget {
        private final int targetX;
        private final int targetY;
        private final int startX;
        private final int startY;
        private final ResourceLocation itemTexture;
        private final SoundEvent discoverySound;
        private int animTime = 30;
        private int timer;
        private int prevTimer;
        private Consumer<CardWidget> widgetConsumer = widget -> {};
        private boolean flipped;
        private boolean flipping;
        private int flipTimer;
        private int flipTimerOld;
        private int flipTimeTotal = 20;

        public CardWidget(int x, int y, int width, int height, int targetX, int targetY, ItemStack stack) {
            super(x, y, width, height, CommonComponents.f_237098_);
            this.startX = x;
            this.startY = y;
            this.targetX = targetX;
            this.targetY = targetY;
            ResourceLocation itemId = Registry.f_122827_.m_7981_((Object)stack.m_41720_());
            this.itemTexture = new ResourceLocation(itemId.m_135827_(), "textures/item/" + itemId.m_135815_() + ".png");
            Item item = stack.m_41720_();
            if (item instanceof ICard) {
                ICard card = (ICard)item;
                this.discoverySound = card.getCardRarity().getDiscoverySound();
            } else {
                this.discoverySound = null;
            }
        }

        public void setAnimTime(int time) {
            this.animTime = time;
        }

        public void setFlipTime(int time) {
            this.flipTimeTotal = time;
        }

        public void setClickResponder(Consumer<CardWidget> widgetConsumer) {
            this.widgetConsumer = widgetConsumer;
        }

        public void m_5716_(double mouseX, double mouseY) {
            this.widgetConsumer.accept(this);
            this.flipping = true;
            if (this.discoverySound != null) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)this.discoverySound, (float)1.0f));
            }
        }

        public void m_7435_(SoundManager handler) {
        }

        protected boolean m_93680_(double mouseX, double mouseY) {
            return !this.flipped && !this.flipping && super.m_93680_(mouseX, mouseY);
        }

        @Override
        public void tickWidget() {
            this.updateMovementAnimationTimer();
            this.doFlipProcessTick();
        }

        public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            int scale = this.f_93622_ ? 8 : 0;
            float actual = (float)this.timer / (float)this.animTime;
            float old = (float)this.prevTimer / (float)this.animTime;
            float rawProgress = Mth.m_14179_((float)partialTick, (float)old, (float)actual);
            float progress = 1.0f - (float)Math.pow(1.0f - rawProgress, 3.0);
            int diffX = this.targetX - this.startX;
            int diffY = this.targetY - this.startY;
            float renderX = (float)this.startX + (float)diffX * progress;
            float renderY = (float)this.startY + (float)diffY * progress;
            this.f_93620_ = (int)renderX;
            this.f_93621_ = (int)renderY;
            Lighting.m_84930_();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)(this.flipped ? this.itemTexture : CARD_BACK));
            this.actuallyRender(poseStack, renderX - (float)scale, renderY - (float)scale, renderX + (float)this.f_93618_ + (float)scale, renderY + (float)this.f_93619_ + (float)scale, partialTick);
        }

        private void actuallyRender(PoseStack stack, float x1, float y1, float x2, float y2, float partialTicks) {
            if (this.flipping) {
                float flipProgress;
                float flipOld = (float)this.flipTimerOld / (float)this.flipTimeTotal;
                float flipActual = (float)this.flipTimer / (float)this.flipTimeTotal;
                float flipProgressRaw = Mth.m_14179_((float)partialTicks, (float)flipOld, (float)flipActual);
                float f = flipProgress = (double)flipProgressRaw < 0.5 ? 4.0f * flipProgressRaw * flipProgressRaw * flipProgressRaw : 1.0f - (float)Math.pow(-2.0f * flipProgressRaw + 2.0f, 3.0) / 2.0f;
                if ((double)flipProgress >= 0.5) {
                    this.flipped = true;
                }
                float halfX = (x2 - x1) / 2.0f;
                float centerX = x1 + halfX;
                float progress = (double)flipProgress < 0.5 ? 1.0f - flipProgress / 0.5f : (flipProgress - 0.5f) / 0.5f;
                x1 = centerX - halfX * progress;
                x2 = centerX + halfX * progress;
            }
            Matrix4f pose = stack.m_85850_().m_85861_();
            CardOpenScreen.renderTexture(pose, x1, y1, x2, y2);
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }

        private void updateMovementAnimationTimer() {
            this.prevTimer = this.timer;
            if (this.timer >= this.animTime) {
                return;
            }
            ++this.timer;
        }

        private void doFlipProcessTick() {
            if (!this.flipping) {
                return;
            }
            this.flipTimerOld = this.flipTimer;
            if (this.flipTimer >= this.flipTimeTotal) {
                return;
            }
            ++this.flipTimer;
        }
    }
}

