/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.cherishedworlds.mixin;

import com.illusivesoulworks.cherishedworlds.client.favorites.FavoritesList;
import com.illusivesoulworks.cherishedworlds.mixin.core.AccessorServerSelectionListEntry;
import com.illusivesoulworks.cherishedworlds.mixin.core.AccessorWorldSelectionListEntry;
import com.illusivesoulworks.cherishedworlds.mixin.core.AccessorWorldSelectionScreen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.client.gui.screens.worldselection.WorldSelectionList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.world.level.storage.LevelSummary;

public class CherishedWorldsMixinHooks {
    public static boolean isNotValidSwap(ServerList serverList, int pos1, int pos2) {
        ServerData data1 = serverList.m_105432_(pos1);
        ServerData data2 = serverList.m_105432_(pos2);
        boolean isFavored1 = FavoritesList.contains(data1.f_105362_ + data1.f_105363_);
        boolean isFavored2 = FavoritesList.contains(data2.f_105362_ + data2.f_105363_);
        return isFavored1 && !isFavored2 || !isFavored1 && isFavored2;
    }

    public static void renameFavorite(String prevName, String newName) {
        if (FavoritesList.contains(prevName)) {
            FavoritesList.remove(prevName);
            FavoritesList.add(newName);
        }
    }

    public static boolean editDeleteButton(ServerSelectionList.Entry entry, boolean flag) {
        if (entry instanceof ServerSelectionList.OnlineServerEntry) {
            ServerData data = ((ServerSelectionList.OnlineServerEntry)entry).m_99898_();
            return !FavoritesList.contains(data.f_105362_ + data.f_105363_);
        }
        return flag;
    }

    public static void updateServers(ServerList serverList, List<ServerSelectionList.OnlineServerEntry> onlineServers, ServerSelectionList serverSelectionList, JoinMultiplayerScreen screen) {
        int i;
        onlineServers.clear();
        ArrayList<ServerSelectionList.OnlineServerEntry> favorites = new ArrayList<ServerSelectionList.OnlineServerEntry>();
        ArrayList<ServerSelectionList.OnlineServerEntry> others = new ArrayList<ServerSelectionList.OnlineServerEntry>();
        for (i = 0; i < serverList.m_105445_(); ++i) {
            ServerData data = serverList.m_105432_(i);
            ServerSelectionList.OnlineServerEntry entry = AccessorServerSelectionListEntry.cherishedworlds$createEntry(serverSelectionList, screen, data);
            if (FavoritesList.contains(data.f_105362_ + data.f_105363_)) {
                favorites.add(entry);
                continue;
            }
            others.add(entry);
        }
        onlineServers.addAll(favorites);
        onlineServers.addAll(others);
        for (i = 0; i < onlineServers.size(); ++i) {
            serverList.m_105437_(i, onlineServers.get(i).m_99898_());
        }
    }

    public static void fillLevels(String filter, List<LevelSummary> levels, WorldSelectionList selectionList) {
        List entries = selectionList.m_6702_();
        entries.clear();
        filter = filter.toLowerCase(Locale.ROOT);
        ArrayList<LevelSummary> copy = new ArrayList<LevelSummary>(levels);
        ListIterator iter = copy.listIterator();
        ArrayList<Object> favorites = new ArrayList<Object>();
        while (iter.hasNext()) {
            LevelSummary summ = (LevelSummary)iter.next();
            if (!FavoritesList.contains(summ.m_78358_())) continue;
            favorites.add(summ);
            iter.remove();
        }
        Collections.sort(favorites);
        Collections.sort(copy);
        for (LevelSummary levelSummary : favorites) {
            if (!CherishedWorldsMixinHooks.filterAccepts(filter, levelSummary)) continue;
            WorldSelectionList worldSelectionList = selectionList;
            Objects.requireNonNull(worldSelectionList);
            entries.add(new WorldSelectionList.WorldListEntry(worldSelectionList, selectionList, levelSummary));
        }
        for (LevelSummary levelSummary : copy) {
            if (!CherishedWorldsMixinHooks.filterAccepts(filter, levelSummary)) continue;
            WorldSelectionList worldSelectionList = selectionList;
            Objects.requireNonNull(worldSelectionList);
            entries.add(new WorldSelectionList.WorldListEntry(worldSelectionList, selectionList, levelSummary));
        }
        WorldSelectionList.Entry entry = (WorldSelectionList.Entry)selectionList.m_93511_();
        if (entry instanceof WorldSelectionList.WorldListEntry) {
            AccessorWorldSelectionListEntry accessorWorldSelectionListEntry = (AccessorWorldSelectionListEntry)entry;
            LevelSummary summary = accessorWorldSelectionListEntry.getWorldSummary();
            Button deleteButton = ((AccessorWorldSelectionScreen)selectionList.m_101685_()).getDeleteButton();
            if (deleteButton != null && summary != null) {
                deleteButton.f_93623_ = !FavoritesList.contains(summary.m_78358_());
            }
        }
    }

    private static boolean filterAccepts(String filter, LevelSummary level) {
        return level.m_78361_().toLowerCase(Locale.ROOT).contains(filter) || level.m_78358_().toLowerCase(Locale.ROOT).contains(filter);
    }
}

