/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.data.generation;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.advancement.ChalkDrawTrigger;
import io.github.mortuusars.chalk.advancement.ConsecutiveSleepingTrigger;
import io.github.mortuusars.chalk.advancement.DyeColorPredicate;
import io.github.mortuusars.chalk.advancement.MaterialColorPredicate;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class Advancements
extends AdvancementProvider {
    private final Path PATH;
    private final ExistingFileHelper existingFileHelper;
    public static final Logger LOGGER = LogManager.getLogger();

    public Advancements(DataGenerator dataGenerator, ExistingFileHelper existingFileHelper) {
        super(dataGenerator, existingFileHelper);
        this.PATH = dataGenerator.m_123916_();
        this.existingFileHelper = existingFileHelper;
    }

    public void m_213708_(@NotNull CachedOutput cache) {
        Consumer<Advancement> consumer = this.getOutput(cache);
        CompoundTag almostExpiredTag = new CompoundTag();
        almostExpiredTag.m_128379_("almostExpired", true);
        Advancement.Builder.m_138353_().m_138396_(new ResourceLocation("minecraft:adventure/kill_a_mob")).m_138371_((ItemLike)Items.f_42678_, (Component)Component.m_237115_((String)"advancement.chalk.get_skeleton_skull"), (Component)Component.m_237115_((String)"advancement.chalk.get_skeleton_skull.description"), null, FrameType.TASK, true, true, false).m_138386_("slept_in_bed", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42678_})).save(consumer, Chalk.resource("adventure/get_skeleton_skull"), this.existingFileHelper);
        Advancement.Builder.m_138353_().m_138396_(new ResourceLocation("minecraft:adventure/sleep_in_bed")).m_138371_((ItemLike)Items.f_42507_, (Component)Component.m_237115_((String)"advancement.chalk.sleep_three_times_in_one_place"), (Component)Component.m_237115_((String)"advancement.chalk.sleep_three_times_in_one_place.description"), null, FrameType.TASK, true, true, false).m_138386_("sleep_three_times_in_one_place", (CriterionTriggerInstance)new ConsecutiveSleepingTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, MinMaxBounds.Ints.m_55386_((int)3), DistancePredicate.m_148840_((MinMaxBounds.Doubles)MinMaxBounds.Doubles.m_154808_((double)16.0)))).save(consumer, Chalk.resource("adventure/sleep_three_times_in_one_place"), this.existingFileHelper);
        Advancement drawInStructure = Advancement.Builder.m_138353_().m_138396_(new ResourceLocation("minecraft:adventure/root")).m_138371_((ItemLike)Chalk.Items.getChalk(DyeColor.YELLOW), (Component)Component.m_237115_((String)"advancement.chalk.draw_mark_in_maze"), (Component)Component.m_237115_((String)"advancement.chalk.draw_mark_in_maze.description"), null, FrameType.TASK, true, true, false).m_138360_(RequirementsStrategy.f_15979_).m_138386_("draw_in_mineshaft", (CriterionTriggerInstance)ChalkDrawTrigger.TriggerInstance.structure((ResourceKey<Structure>)BuiltinStructures.f_209846_)).m_138386_("draw_in_mineshaft_mesa", (CriterionTriggerInstance)ChalkDrawTrigger.TriggerInstance.structure((ResourceKey<Structure>)BuiltinStructures.f_209847_)).m_138386_("draw_in_fortress", (CriterionTriggerInstance)ChalkDrawTrigger.TriggerInstance.structure((ResourceKey<Structure>)BuiltinStructures.f_209859_)).m_138386_("draw_in_stronghold", (CriterionTriggerInstance)ChalkDrawTrigger.TriggerInstance.structure((ResourceKey<Structure>)BuiltinStructures.f_209855_)).save(consumer, Chalk.resource("adventure/draw_mark_in_maze"), this.existingFileHelper);
        Advancement.Builder.m_138353_().m_138398_(drawInStructure).m_138371_((ItemLike)Chalk.Items.getChalk(DyeColor.LIGHT_GRAY), (Component)Component.m_237115_((String)"advancement.chalk.vandalism"), (Component)Component.m_237115_((String)"advancement.chalk.vandalism.description"), null, FrameType.TASK, true, true, true).m_138360_(RequirementsStrategy.f_15979_).m_138386_("draw_in_village_plains", (CriterionTriggerInstance)ChalkDrawTrigger.TriggerInstance.structure((ResourceKey<Structure>)BuiltinStructures.f_209864_)).m_138386_("draw_in_village_desert", (CriterionTriggerInstance)ChalkDrawTrigger.TriggerInstance.structure((ResourceKey<Structure>)BuiltinStructures.f_209865_)).m_138386_("draw_in_village_savanna", (CriterionTriggerInstance)ChalkDrawTrigger.TriggerInstance.structure((ResourceKey<Structure>)BuiltinStructures.f_209866_)).m_138386_("draw_in_village_snowy", (CriterionTriggerInstance)ChalkDrawTrigger.TriggerInstance.structure((ResourceKey<Structure>)BuiltinStructures.f_209867_)).m_138386_("draw_in_village_taiga", (CriterionTriggerInstance)ChalkDrawTrigger.TriggerInstance.structure((ResourceKey<Structure>)BuiltinStructures.f_209868_)).m_138354_(AdvancementRewards.Builder.m_10005_((int)100)).save(consumer, Chalk.resource("adventure/vandalism"), this.existingFileHelper);
        Advancement.Builder.m_138353_().m_138398_(drawInStructure).m_138371_((ItemLike)Chalk.Items.getChalk(DyeColor.BLACK), (Component)Component.m_237115_((String)"advancement.chalk.black_chalk_on_black_block"), (Component)Component.m_237115_((String)"advancement.chalk.black_chalk_on_black_block.description"), null, FrameType.TASK, true, true, true).m_138386_("draw_with_chalk_color", (CriterionTriggerInstance)new ChalkDrawTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, LocationPredicate.Builder.m_52651_().m_153968_(new LightPredicate.Builder().m_153104_(MinMaxBounds.Ints.m_154819_((int)7)).m_153106_()).m_52658_(), new MaterialColorPredicate(List.of(MaterialColor.f_76365_)), new DyeColorPredicate(List.of(DyeColor.BLACK)))).m_138354_(AdvancementRewards.Builder.m_10005_((int)100)).save(consumer, Chalk.resource("adventure/black_chalk_on_black_block"), this.existingFileHelper);
    }

    protected Consumer<Advancement> getOutput(CachedOutput cache) {
        HashSet set = Sets.newHashSet();
        return advancement -> {
            if (!set.add(advancement.m_138327_())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.m_138327_());
            }
            Path path1 = this.PATH.resolve("data/" + advancement.m_138327_().m_135827_() + "/advancements/" + advancement.m_138327_().m_135815_() + ".json");
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)advancement.m_138313_().m_138400_(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
            }
        };
    }
}

