/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.advancement;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.MaterialColor;

public class MaterialColorPredicate {
    public static final String JSON_PROPERTY = "materialColorPredicate";
    public static final MaterialColorPredicate ANY = new MaterialColorPredicate(Collections.emptyList());
    private final List<MaterialColor> colors;

    public MaterialColorPredicate(List<MaterialColor> colors) {
        this.colors = colors;
    }

    public boolean matches(MaterialColor color) {
        if (this.colors.size() == 0) {
            return true;
        }
        for (MaterialColor dyeColor : this.colors) {
            if (!color.equals(dyeColor)) continue;
            return true;
        }
        return false;
    }

    public static MaterialColorPredicate fromJson(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return ANY;
        }
        JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)json, (String)JSON_PROPERTY);
        JsonArray colorsList = jsonobject.get("colors").getAsJsonArray();
        ArrayList<MaterialColor> colors = new ArrayList<MaterialColor>();
        for (JsonElement element : colorsList) {
            colors.add(MaterialColor.m_192919_((int)element.getAsInt()));
        }
        return new MaterialColorPredicate(colors);
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonArray colorsList = new JsonArray();
        for (MaterialColor color : this.colors) {
            colorsList.add((Number)color.f_76397_);
        }
        JsonObject jsonobject = new JsonObject();
        jsonobject.add("colors", (JsonElement)colorsList);
        return jsonobject;
    }
}

