/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.network;

import com.mrh0.buildersaddition.config.Config;
import com.mrh0.buildersaddition.tileentity.base.BaseInstrument;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class PlayNotePacket {
    private BlockPos pos;
    private int note;

    public PlayNotePacket(BlockPos pos, int note) {
        this.pos = pos;
        this.note = note;
    }

    public static void encode(PlayNotePacket packet, FriendlyByteBuf tag) {
        tag.m_130064_(packet.pos);
        tag.writeInt(packet.note);
    }

    public static PlayNotePacket decode(FriendlyByteBuf buf) {
        PlayNotePacket scp = new PlayNotePacket(buf.m_130135_(), buf.readInt());
        return scp;
    }

    public static void handle(PlayNotePacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null) {
                    PlayNotePacket.sendUpdate(pkt.pos, player, pkt.note);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void sendUpdate(BlockPos pos, ServerPlayer player, int note) {
        if (!((Boolean)Config.MIDI_ENABLED.get()).booleanValue()) {
            return;
        }
        BaseInstrument te = (BaseInstrument)player.f_19853_.m_7702_(pos);
        if (te != null) {
            te.playNote(note);
            Packet supdatetileentitypacket = te.m_58483_();
            if (supdatetileentitypacket != null) {
                player.f_8906_.m_9829_(supdatetileentitypacket);
            }
        }
    }
}

