/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.event;

import com.mrh0.buildersaddition.Index;
import com.mrh0.buildersaddition.blocks.VerticalComparatorBlock;
import com.mrh0.buildersaddition.blocks.VerticalRepeaterBlock;
import com.mrh0.buildersaddition.config.Config;
import com.mrh0.buildersaddition.tileentity.SpeakerTileEntity;
import com.mrh0.buildersaddition.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class GameEvents {
    @SubscribeEvent
    public static void interact(PlayerInteractEvent.RightClickBlock evt) {
        Item item = evt.getItemStack().m_41720_();
        if (item instanceof ShovelItem) {
            BlockState stateAbove;
            if (!((Boolean)Config.PATHBLOCK_CREATION_ENABLED.get()).booleanValue()) {
                return;
            }
            BlockState stateClicked = evt.getLevel().m_8055_(evt.getPos());
            if (stateClicked.m_60713_(Blocks.f_49994_) && (!(stateAbove = evt.getLevel().m_8055_(evt.getPos().m_7494_())).m_60767_().m_76333_() || stateAbove.m_60734_() instanceof FenceGateBlock)) {
                if (!evt.getLevel().m_5776_()) {
                    evt.getLevel().m_46597_(evt.getPos(), ((Block)Index.GRAVEL_PATH.get()).m_49966_());
                    evt.getItemStack().m_41622_(1, (LivingEntity)evt.getEntity(), e -> {});
                } else {
                    evt.getEntity().m_5496_(SoundEvents.f_11993_, 1.0f, 1.0f);
                }
                evt.setCancellationResult(InteractionResult.SUCCESS);
                evt.setCanceled(true);
            }
        } else if (item instanceof PickaxeItem) {
            if (!((Boolean)Config.CRACKED_CREATION_ENABLED.get()).booleanValue()) {
                return;
            }
            BlockState stateClicked = evt.getLevel().m_8055_(evt.getPos());
            BlockState next = Util.crackedState(stateClicked);
            if (next != null) {
                if (!evt.getLevel().m_5776_()) {
                    evt.getLevel().m_46597_(evt.getPos(), next);
                    evt.getItemStack().m_41622_(1, (LivingEntity)evt.getEntity(), e -> {});
                    return;
                }
                evt.setCancellationResult(InteractionResult.SUCCESS);
                evt.setCanceled(true);
                evt.getEntity().m_5496_(SoundEvents.f_12494_, 1.0f, 1.0f);
            }
        } else if (item == Items.f_42350_) {
            if (evt.getFace().m_122434_() != Direction.Axis.Y) {
                BlockPos pos = evt.getPos().m_121945_(evt.getFace());
                if (evt.getLevel().m_8055_(pos).m_60795_()) {
                    if (!evt.getEntity().m_6047_() && evt.getLevel().m_8055_(evt.getPos()).m_60664_(evt.getLevel(), evt.getEntity(), evt.getHand(), evt.getHitVec()) != InteractionResult.PASS) {
                        evt.setCancellationResult(InteractionResult.SUCCESS);
                        evt.setCanceled(true);
                        return;
                    }
                    boolean flag = evt.getHitVec().m_82450_().f_82480_ - (double)evt.getPos().m_123342_() - 0.5 < 0.0;
                    BlockState state = (BlockState)((BlockState)((Block)Index.VERTICAL_REPEATER.get()).m_49966_().m_61124_((Property)VerticalRepeaterBlock.HORIZONTAL_FACING, (Comparable)evt.getFace().m_122424_())).m_61124_((Property)VerticalRepeaterBlock.VERTICAL_FACING, (Comparable)(flag ? Direction.UP : Direction.DOWN));
                    if (!evt.getLevel().m_8055_(evt.getPos()).m_60783_((BlockGetter)evt.getLevel(), evt.getPos(), evt.getFace())) {
                        return;
                    }
                    evt.getLevel().m_46597_(pos, state);
                    ((Block)Index.VERTICAL_REPEATER.get()).m_6402_(evt.getLevel(), pos, state, (LivingEntity)evt.getEntity(), evt.getItemStack());
                    if (!evt.getEntity().m_7500_()) {
                        evt.getItemStack().m_41774_(1);
                    }
                    evt.setCancellationResult(InteractionResult.SUCCESS);
                    evt.setCanceled(true);
                    SoundType snd = Blocks.f_50146_.getSoundType(state, (LevelReader)evt.getLevel(), pos, (Entity)evt.getEntity());
                    evt.getEntity().m_5496_(snd.m_56777_(), snd.m_56773_(), snd.m_56774_());
                }
            }
        } else if (item == Items.f_42351_ && evt.getFace().m_122434_() != Direction.Axis.Y) {
            BlockPos pos = evt.getPos().m_121945_(evt.getFace());
            if (evt.getLevel().m_8055_(pos).m_60795_()) {
                if (!evt.getEntity().m_6047_() && evt.getLevel().m_8055_(evt.getPos()).m_60664_(evt.getLevel(), evt.getEntity(), evt.getHand(), evt.getHitVec()) != InteractionResult.PASS) {
                    evt.setCancellationResult(InteractionResult.SUCCESS);
                    evt.setCanceled(true);
                    return;
                }
                boolean flag = evt.getHitVec().m_82450_().f_82480_ - (double)evt.getPos().m_123342_() - 0.5 < 0.0;
                BlockState state = (BlockState)((BlockState)((Block)Index.VERTICAL_COMPARATOR.get()).m_49966_().m_61124_((Property)VerticalComparatorBlock.HORIZONTAL_FACING, (Comparable)evt.getFace().m_122424_())).m_61124_((Property)VerticalComparatorBlock.VERTICAL_FACING, (Comparable)(flag ? Direction.UP : Direction.DOWN));
                if (!evt.getLevel().m_8055_(evt.getPos()).m_60783_((BlockGetter)evt.getLevel(), evt.getPos(), evt.getFace())) {
                    return;
                }
                evt.getLevel().m_46597_(pos, state);
                ((Block)Index.VERTICAL_COMPARATOR.get()).m_6402_(evt.getLevel(), pos, state, (LivingEntity)evt.getEntity(), evt.getItemStack());
                if (!evt.getEntity().m_7500_()) {
                    evt.getItemStack().m_41774_(1);
                }
                evt.setCancellationResult(InteractionResult.SUCCESS);
                evt.setCanceled(true);
                SoundType snd = Blocks.f_50328_.getSoundType(state, (LevelReader)evt.getLevel(), pos, (Entity)evt.getEntity());
                evt.getEntity().m_5496_(snd.m_56777_(), snd.m_56773_(), snd.m_56774_());
            }
        }
    }

    @SubscribeEvent
    public static void tickEvent(TickEvent.ServerTickEvent evt) {
        if ((SpeakerTileEntity.latestNotes -= (Integer)Config.MIDI_NOTES_PER_SECOND.get() / 20) < 0) {
            SpeakerTileEntity.latestNotes = 0;
        }
    }
}

