/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.Index;
import com.mrh0.buildersaddition.blocks.base.BaseBlock;
import com.mrh0.buildersaddition.event.opts.BlockOptions;
import com.mrh0.buildersaddition.event.opts.ItemOptions;
import com.mrh0.buildersaddition.tileentity.ArcadeTileEntity;
import com.mrh0.buildersaddition.util.Util;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class Arcade
extends BaseBlock
implements EntityBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static VoxelShape SHAPE_NORTH_LOWER = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)32.0, (double)16.0);
    private static VoxelShape SHAPE_EAST_LOWER = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)32.0, (double)16.0);
    private static VoxelShape SHAPE_SOUTH_LOWER = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)15.0);
    private static VoxelShape SHAPE_WEST_LOWER = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    private static VoxelShape SHAPE_NORTH_UPPER = Block.m_49796_((double)0.0, (double)-16.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0);
    private static VoxelShape SHAPE_EAST_UPPER = Block.m_49796_((double)0.0, (double)-16.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
    private static VoxelShape SHAPE_SOUTH_UPPER = Block.m_49796_((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0);
    private static VoxelShape SHAPE_WEST_UPPER = Block.m_49796_((double)1.0, (double)-16.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public Arcade() {
        super("arcade", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60910_().m_60960_(Util::isntSolid).m_60922_(Util::isntSolid).m_60971_(Util::isntSolid), new BlockOptions().setItemOptions(new ItemOptions().group(null)));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public Arcade(String name) {
        super("arcade_" + name, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60910_().m_60922_(Util::isntSolid).m_60960_(Util::isntSolid).m_60971_(Util::isntSolid));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return world.m_5776_() ? Util.createTickerHelper(type, (BlockEntityType)Index.ARCADE_TILE_ENTITY_TYPE.get(), ArcadeTileEntity::tick) : null;
    }

    public PushReaction m_5537_(BlockState p_60584_) {
        return PushReaction.BLOCK;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        if (blockpos.m_123342_() < 255 && context.m_43725_().m_8055_(blockpos.m_7494_()).m_60629_(context)) {
            Level world = context.m_43725_();
            boolean flag = world.m_46753_(blockpos) || world.m_46753_(blockpos.m_7494_());
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity ent, ItemStack p_49851_) {
        world.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public boolean isValidPosition(BlockState state, BlockGetter worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = worldIn.m_8055_(blockpos);
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? true : blockstate.m_60713_((Block)this);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HALF});
    }

    private VoxelShape getShapeForDirection(Direction d, boolean b) {
        switch (d) {
            case NORTH: {
                return b ? SHAPE_NORTH_UPPER : SHAPE_NORTH_LOWER;
            }
            case SOUTH: {
                return b ? SHAPE_SOUTH_UPPER : SHAPE_SOUTH_LOWER;
            }
            case EAST: {
                return b ? SHAPE_EAST_UPPER : SHAPE_EAST_LOWER;
            }
            case WEST: {
                return b ? SHAPE_WEST_UPPER : SHAPE_WEST_LOWER;
            }
        }
        return SHAPE_NORTH_LOWER;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getShapeForDirection((Direction)state.m_61143_((Property)FACING), state.m_61143_(HALF) == DoubleBlockHalf.UPPER);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_5833_()) {
            return InteractionResult.PASS;
        }
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        ArcadeTileEntity mte = this.getTE(state, world, pos);
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)mte, extraData -> extraData.m_130064_(pos));
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            ArcadeTileEntity tileentity = this.getTE(state, worldIn, pos);
            if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                worldIn.m_46597_(pos.m_7494_(), Blocks.f_50016_.m_49966_());
            } else {
                worldIn.m_46597_(pos.m_7495_(), Blocks.f_50016_.m_49966_());
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    private ArcadeTileEntity getTE(BlockState state, Level worldIn, BlockPos pos) {
        BlockEntity tileentity = state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? worldIn.m_7702_(pos) : worldIn.m_7702_(pos.m_7495_());
        if (tileentity != null && tileentity instanceof ArcadeTileEntity) {
            return (ArcadeTileEntity)tileentity;
        }
        return null;
    }

    public RenderShape m_7514_(BlockState p_60550_) {
        return RenderShape.MODEL;
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int id, int param) {
        BlockEntity tileentity = world.m_7702_(pos);
        return tileentity == null ? false : tileentity.m_7531_(id, param);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ArcadeTileEntity(pos, state);
    }
}

