/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.other;

import com.teamabnormals.blueprint.core.other.tags.BlueprintBlockTags;
import com.teamabnormals.blueprint.core.util.DataUtil;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.BlockSourceImpl;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.NoteBlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="blueprint")
public final class BlueprintEvents {
    public static final String NOTE_KEY = "minecraft:note";
    public static List<DataUtil.CustomNoteBlockInstrument> SORTED_CUSTOM_NOTE_BLOCK_INSTRUMENTS = null;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onNoteBlockPlay(NoteBlockEvent.Play event) {
        Level level;
        if (SORTED_CUSTOM_NOTE_BLOCK_INSTRUMENTS != null && !(level = (Level)event.getLevel()).m_5776_()) {
            BlockPos pos = event.getPos();
            BlockSourceImpl source = new BlockSourceImpl((ServerLevel)level, pos.m_121945_(Direction.DOWN));
            for (DataUtil.CustomNoteBlockInstrument instrument : SORTED_CUSTOM_NOTE_BLOCK_INSTRUMENTS) {
                if (!instrument.test((BlockSource)source)) continue;
                SoundEvent sound = instrument.getSound();
                double note = event.getVanillaNoteId();
                level.m_5594_(null, pos, sound, SoundSource.RECORDS, 3.0f, (float)Math.pow(2.0, (note - 12.0) / 12.0));
                NetworkUtil.spawnParticle(NOTE_KEY, (ResourceKey<Level>)level.m_46472_(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, note / 24.0, 0.0, 0.0);
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getState().m_204336_(BlueprintBlockTags.LEAF_PILES) && event.getEntity().m_21205_().m_204117_(Tags.Items.SHEARS)) {
            event.setNewSpeed(15.0f);
        }
    }
}

