/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.loot.modification.modifiers;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.common.loot.modification.LootModifierSerializers;
import com.teamabnormals.blueprint.common.loot.modification.modifiers.LootModifier;
import com.teamabnormals.blueprint.common.loot.modification.modifiers.LootPoolsModifier;
import com.teamabnormals.blueprint.core.util.DataUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.PredicateManager;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public record LootPoolEntriesModifier(boolean replace, int index, List<LootPoolEntryContainer> entries) implements LootModifier<LootPoolEntriesModifier>
{
    public static final Field ENTRIES = ObfuscationReflectionHelper.findField(LootPool.class, (String)"f_79023_");

    public LootPoolEntriesModifier(boolean replace, int index, LootPoolEntryContainer ... entries) {
        this(replace, index, List.of(entries));
    }

    @Override
    public void modify(LootTableLoadEvent object) {
        try {
            LootPool pool = (LootPool)((List)LootPoolsModifier.POOLS.get(object.getTable())).get(this.index);
            LootPoolEntryContainer[] lootEntries = (LootPoolEntryContainer[])ENTRIES.get(pool);
            lootEntries = this.replace ? (LootPoolEntryContainer[])this.entries.toArray(LootPoolEntryContainer[]::new) : DataUtil.concatArrays(lootEntries, (LootPoolEntryContainer[])this.entries.toArray(LootPoolEntryContainer[]::new));
            ENTRIES.set(pool, lootEntries);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public Serializer getSerializer() {
        return LootModifierSerializers.ENTRIES;
    }

    public static final class Serializer
    implements LootModifier.Serializer<LootPoolEntriesModifier> {
        @Override
        public JsonElement serialize(LootPoolEntriesModifier modifier, Gson gson) throws JsonParseException {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("replace", Boolean.valueOf(modifier.replace));
            jsonObject.addProperty("index", (Number)modifier.index);
            JsonArray entries = new JsonArray();
            for (LootPoolEntryContainer lootEntry : modifier.entries) {
                entries.add(gson.toJsonTree((Object)lootEntry));
            }
            jsonObject.add("entries", (JsonElement)entries);
            return jsonObject;
        }

        @Override
        public LootPoolEntriesModifier deserialize(JsonElement element, Pair<Gson, PredicateManager> additional) throws JsonParseException {
            JsonObject jsonObject = element.getAsJsonObject();
            int index = GsonHelper.m_13927_((JsonObject)jsonObject, (String)"index");
            if (index < 0) {
                throw new JsonParseException("'index' must be 0 or greater!");
            }
            ArrayList<LootPoolEntryContainer> entries = new ArrayList<LootPoolEntryContainer>();
            JsonArray entriesArray = jsonObject.getAsJsonArray("entries");
            Gson gson = (Gson)additional.getFirst();
            entriesArray.forEach(entry -> entries.add((LootPoolEntryContainer)gson.fromJson(entry, LootPoolEntryContainer.class)));
            return new LootPoolEntriesModifier(GsonHelper.m_13912_((JsonObject)jsonObject, (String)"replace"), index, entries);
        }
    }
}

