/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.util;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;

public class ModelHelper {
    private static void putVertex(VertexConsumer builder, Vec3 normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float r, float g, float b, float a) {
        float iu = sprite.m_118367_((double)u);
        float iv = sprite.m_118393_((double)v);
        builder.m_5483_(x, y, z).m_7421_(iu, iv).m_7120_(0, 0).m_85950_(r, g, b, a).m_5601_((float)normal.m_7096_(), (float)normal.m_7098_(), (float)normal.m_7094_()).m_5752_();
    }

    public static BakedQuad createQuad(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite, float ulow, float uhigh, float vlow, float vhigh, int tintIndex) {
        Vec3 normal = v3.m_82546_(v2).m_82537_(v1.m_82546_(v2)).m_82541_();
        BakedQuad[] quad = new BakedQuad[1];
        QuadBakingVertexConsumer builder = new QuadBakingVertexConsumer(q -> {
            quad[0] = q;
        });
        builder.setSprite(sprite);
        builder.setDirection(Direction.m_122366_((double)normal.f_82479_, (double)normal.f_82480_, (double)normal.f_82481_));
        builder.setTintIndex(tintIndex);
        ModelHelper.putVertex((VertexConsumer)builder, normal, v1.f_82479_, v1.f_82480_, v1.f_82481_, ulow, vlow, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
        ModelHelper.putVertex((VertexConsumer)builder, normal, v2.f_82479_, v2.f_82480_, v2.f_82481_, ulow, vhigh, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
        ModelHelper.putVertex((VertexConsumer)builder, normal, v3.f_82479_, v3.f_82480_, v3.f_82481_, uhigh, vhigh, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
        ModelHelper.putVertex((VertexConsumer)builder, normal, v4.f_82479_, v4.f_82480_, v4.f_82481_, uhigh, vlow, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
        return quad[0];
    }

    public static BakedQuad createQuad(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite, float ulow, float uhigh, float vlow, float vhigh, int tintIndex, boolean invert) {
        Vec3 normal = v3.m_82546_(v2).m_82537_(v1.m_82546_(v2)).m_82541_();
        if (invert) {
            normal = normal.m_82548_();
        }
        BakedQuad[] quad = new BakedQuad[1];
        QuadBakingVertexConsumer builder = new QuadBakingVertexConsumer(q -> {
            quad[0] = q;
        });
        builder.setSprite(sprite);
        builder.setDirection(Direction.m_122366_((double)normal.f_82479_, (double)normal.f_82480_, (double)normal.f_82481_));
        builder.setTintIndex(tintIndex);
        if (invert) {
            ModelHelper.putVertex((VertexConsumer)builder, normal, v1.f_82479_, v1.f_82480_, v1.f_82481_, ulow, vlow, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex((VertexConsumer)builder, normal, v2.f_82479_, v2.f_82480_, v2.f_82481_, ulow, vhigh, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex((VertexConsumer)builder, normal, v3.f_82479_, v3.f_82480_, v3.f_82481_, uhigh, vhigh, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex((VertexConsumer)builder, normal, v4.f_82479_, v4.f_82480_, v4.f_82481_, uhigh, vlow, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            ModelHelper.putVertex((VertexConsumer)builder, normal, v4.f_82479_, v4.f_82480_, v4.f_82481_, ulow, vlow, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex((VertexConsumer)builder, normal, v3.f_82479_, v3.f_82480_, v3.f_82481_, uhigh, vlow, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex((VertexConsumer)builder, normal, v2.f_82479_, v2.f_82480_, v2.f_82481_, uhigh, vhigh, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex((VertexConsumer)builder, normal, v1.f_82479_, v1.f_82480_, v1.f_82481_, ulow, vhigh, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        return quad[0];
    }

    public static BakedQuad createQuadInverted(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite, float ulow, float uhigh, float vlow, float vhigh, int tintIndex) {
        return ModelHelper.createQuadInverted(v1, v2, v3, v4, sprite, ulow, uhigh, vlow, vhigh, tintIndex, false);
    }

    public static BakedQuad createQuadInverted(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite, float ulow, float uhigh, float vlow, float vhigh, int tintIndex, boolean invert) {
        Vec3 normal = v3.m_82546_(v2).m_82537_(v1.m_82546_(v2)).m_82541_();
        if (invert) {
            normal = normal.m_82548_();
        }
        BakedQuad[] quad = new BakedQuad[1];
        QuadBakingVertexConsumer builder = new QuadBakingVertexConsumer(q -> {
            quad[0] = q;
        });
        builder.setSprite(sprite);
        builder.setDirection(Direction.m_122366_((double)normal.f_82479_, (double)normal.f_82480_, (double)normal.f_82481_));
        builder.setTintIndex(tintIndex);
        if (invert) {
            ModelHelper.putVertex((VertexConsumer)builder, normal, v4.f_82479_, v4.f_82480_, v4.f_82481_, ulow, vlow, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex((VertexConsumer)builder, normal, v3.f_82479_, v3.f_82480_, v3.f_82481_, uhigh, vlow, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex((VertexConsumer)builder, normal, v2.f_82479_, v2.f_82480_, v2.f_82481_, uhigh, vhigh, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex((VertexConsumer)builder, normal, v1.f_82479_, v1.f_82480_, v1.f_82481_, ulow, vhigh, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            ModelHelper.putVertex((VertexConsumer)builder, normal, v1.f_82479_, v1.f_82480_, v1.f_82481_, ulow, vlow, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex((VertexConsumer)builder, normal, v2.f_82479_, v2.f_82480_, v2.f_82481_, uhigh, vlow, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex((VertexConsumer)builder, normal, v3.f_82479_, v3.f_82480_, v3.f_82481_, uhigh, vhigh, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex((VertexConsumer)builder, normal, v4.f_82479_, v4.f_82480_, v4.f_82481_, ulow, vhigh, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        return quad[0];
    }

    public static List<BakedQuad> createCuboid(float xl, float xh, float yl, float yh, float zl, float zh, TextureAtlasSprite texture, int tintIndex) {
        return ModelHelper.createCuboid(xl, xh, yl, yh, zl, zh, texture, tintIndex, true, true, true, true, true, true);
    }

    public static List<BakedQuad> createCuboid(float xl, float xh, float yl, float yh, float zl, float zh, TextureAtlasSprite texture, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vec3 NWU = ModelHelper.v(xl, yh, zl);
        Vec3 SWU = ModelHelper.v(xl, yh, zh);
        Vec3 NWD = ModelHelper.v(xl, yl, zl);
        Vec3 SWD = ModelHelper.v(xl, yl, zh);
        Vec3 NEU = ModelHelper.v(xh, yh, zl);
        Vec3 SEU = ModelHelper.v(xh, yh, zh);
        Vec3 NED = ModelHelper.v(xh, yl, zl);
        Vec3 SED = ModelHelper.v(xh, yl, zh);
        if (xh - xl > 1.0f || yh - yl > 1.0f || zh - zl > 1.0f) {
            if (Minecraft.m_91087_().f_91074_ != null) {
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.block_error"), true);
            }
            return quads;
        }
        if (xl < 0.0f) {
            xl += 1.0f;
            xh += 1.0f;
        }
        if (xh > 1.0f) {
            xh -= 1.0f;
            xl -= 1.0f;
        }
        if (yl < 0.0f) {
            yl += 1.0f;
            yh += 1.0f;
        }
        if (yh > 1.0f) {
            yh -= 1.0f;
            yl -= 1.0f;
        }
        if (zl < 0.0f) {
            zl += 1.0f;
            zh += 1.0f;
        }
        if (zh > 1.0f) {
            zh -= 1.0f;
            zl -= 1.0f;
        }
        if (up) {
            quads.add(ModelHelper.createQuad(NWU, SWU, SEU, NEU, texture, xl * 16.0f, xh * 16.0f, zl * 16.0f, zh * 16.0f, tintIndex));
        }
        if (down) {
            quads.add(ModelHelper.createQuad(NED, SED, SWD, NWD, texture, xh * 16.0f, xl * 16.0f, 16.0f - zl * 16.0f, 16.0f - zh * 16.0f, tintIndex));
        }
        if (west) {
            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, texture, zl * 16.0f, zh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
        }
        if (east) {
            quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, texture, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
        }
        if (north) {
            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, texture, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
        }
        if (south) {
            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, texture, xl * 16.0f, xh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
        }
        return quads;
    }

    public static List<BakedQuad> createSixFaceCuboid(float xl, float xh, float yl, float yh, float zl, float zh, BlockState mimic, BakedModel model, ModelData extraData, RandomSource rand, int tintIndex, int rotation) {
        return ModelHelper.createSixFaceCuboid(xl, xh, yl, yh, zl, zh, mimic, model, extraData, rand, tintIndex, true, true, true, true, true, true, rotation);
    }

    public static List<BakedQuad> createSixFaceCuboid(float xl, float xh, float yl, float yh, float zl, float zh, BlockState mimic, BakedModel model, ModelData extraData, RandomSource rand, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, int rotation) {
        List<TextureAtlasSprite> textureList;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vec3 NWU = ModelHelper.v(xl, yh, zl);
        Vec3 SWU = ModelHelper.v(xl, yh, zh);
        Vec3 NWD = ModelHelper.v(xl, yl, zl);
        Vec3 SWD = ModelHelper.v(xl, yl, zh);
        Vec3 NEU = ModelHelper.v(xh, yh, zl);
        Vec3 SEU = ModelHelper.v(xh, yh, zh);
        Vec3 NED = ModelHelper.v(xh, yl, zl);
        Vec3 SED = ModelHelper.v(xh, yl, zh);
        if (xh - xl > 1.0f || yh - yl > 1.0f || zh - zl > 1.0f) {
            if (Minecraft.m_91087_().f_91074_ != null) {
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.block_error"), true);
            }
            return quads;
        }
        if (xl < 0.0f) {
            xl += 1.0f;
            xh += 1.0f;
        }
        if (xh > 1.0f) {
            xh -= 1.0f;
            xl -= 1.0f;
        }
        if (yl < 0.0f) {
            yl += 1.0f;
            yh += 1.0f;
        }
        if (yh > 1.0f) {
            yh -= 1.0f;
            yl -= 1.0f;
        }
        if (zl < 0.0f) {
            zl += 1.0f;
            zh += 1.0f;
        }
        if (zh > 1.0f) {
            zh -= 1.0f;
            zl -= 1.0f;
        }
        if ((textureList = TextureHelper.getTextureFromModel(model, extraData, rand)).size() == 0) {
            if (Minecraft.m_91087_().f_91074_ != null) {
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.block_not_available"), true);
            }
            return quads;
        }
        TextureAtlasSprite textureNorth = textureList.get(0);
        TextureAtlasSprite textureEast = textureList.get(0);
        TextureAtlasSprite textureSouth = textureList.get(0);
        TextureAtlasSprite textureWest = textureList.get(0);
        TextureAtlasSprite textureUp = textureList.get(0);
        TextureAtlasSprite textureDown = textureList.get(0);
        for (BakedQuad quad : model.getQuads((BlockState)extraData.get(FrameBlockTile.MIMIC), Direction.NORTH, rand, extraData, RenderType.m_110466_())) {
            textureNorth = quad.m_173410_();
        }
        for (BakedQuad quad : model.getQuads((BlockState)extraData.get(FrameBlockTile.MIMIC), Direction.EAST, rand, extraData, RenderType.m_110466_())) {
            textureEast = quad.m_173410_();
        }
        for (BakedQuad quad : model.getQuads((BlockState)extraData.get(FrameBlockTile.MIMIC), Direction.SOUTH, rand, extraData, RenderType.m_110466_())) {
            textureSouth = quad.m_173410_();
        }
        for (BakedQuad quad : model.getQuads((BlockState)extraData.get(FrameBlockTile.MIMIC), Direction.WEST, rand, extraData, RenderType.m_110466_())) {
            textureWest = quad.m_173410_();
        }
        for (BakedQuad quad : model.getQuads((BlockState)extraData.get(FrameBlockTile.MIMIC), Direction.UP, rand, extraData, RenderType.m_110466_())) {
            textureUp = quad.m_173410_();
        }
        for (BakedQuad quad : model.getQuads((BlockState)extraData.get(FrameBlockTile.MIMIC), Direction.DOWN, rand, extraData, RenderType.m_110466_())) {
            textureDown = quad.m_173410_();
        }
        if (rotation == 0) {
            if (up) {
                quads.add(ModelHelper.createQuad(NWU, SWU, SEU, NEU, textureUp, xl * 16.0f, xh * 16.0f, zl * 16.0f, zh * 16.0f, tintIndex));
            }
            if (down) {
                quads.add(ModelHelper.createQuad(SWD, NWD, NED, SED, textureDown, 16.0f - xl * 16.0f, 16.0f - xh * 16.0f, zh * 16.0f, zl * 16.0f, tintIndex));
            }
            if (west) {
                quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, textureWest, zl * 16.0f, zh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (east) {
                quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, textureEast, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (north) {
                quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, textureNorth, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (south) {
                quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, textureSouth, xl * 16.0f, xh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
        }
        if (rotation == 1) {
            if (up) {
                quads.add(ModelHelper.createQuad(NEU, NWU, SWU, SEU, textureUp, zl * 16.0f, zh * 16.0f, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, tintIndex));
            }
            if (down) {
                quads.add(ModelHelper.createQuad(NWD, NED, SED, SWD, textureDown, 16.0f - zl * 16.0f, 16.0f - zh * 16.0f, 16.0f - xl * 16.0f, 16.0f - xh * 16.0f, tintIndex));
            }
            if (west) {
                quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, textureSouth, zl * 16.0f, zh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (east) {
                quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, textureNorth, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (north) {
                quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, textureWest, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (south) {
                quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, textureEast, xl * 16.0f, xh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
        }
        if (rotation == 2) {
            if (up) {
                quads.add(ModelHelper.createQuad(SEU, NEU, NWU, SWU, textureUp, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, tintIndex));
            }
            if (down) {
                quads.add(ModelHelper.createQuad(NED, SED, SWD, NWD, textureDown, xh * 16.0f, xl * 16.0f, 16.0f - zl * 16.0f, 16.0f - zh * 16.0f, tintIndex));
            }
            if (west) {
                quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, textureEast, zl * 16.0f, zh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (east) {
                quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, textureWest, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (north) {
                quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, textureSouth, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (south) {
                quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, textureNorth, xl * 16.0f, xh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
        }
        if (rotation == 3) {
            if (up) {
                quads.add(ModelHelper.createQuad(SWU, SEU, NEU, NWU, textureUp, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, xl * 16.0f, xh * 16.0f, tintIndex));
            }
            if (down) {
                quads.add(ModelHelper.createQuad(SED, SWD, NWD, NED, textureDown, zh * 16.0f, zl * 16.0f, xh * 16.0f, xl * 16.0f, tintIndex));
            }
            if (west) {
                quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, textureNorth, zl * 16.0f, zh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (east) {
                quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, textureSouth, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (north) {
                quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, textureEast, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (south) {
                quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, textureWest, xl * 16.0f, xh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
        }
        if (rotation == 4) {
            if (up) {
                quads.add(ModelHelper.createQuad(NWU, SWU, SEU, NEU, textureSouth, xl * 16.0f, xh * 16.0f, zl * 16.0f, zh * 16.0f, tintIndex));
            }
            if (down) {
                quads.add(ModelHelper.createQuad(SWD, NWD, NED, SED, textureNorth, 16.0f - xl * 16.0f, 16.0f - xh * 16.0f, zh * 16.0f, zl * 16.0f, tintIndex));
            }
            if (west) {
                quads.add(ModelHelper.createQuad(NWD, SWD, SWU, NWU, textureWest, yl * 16.0f, yh * 16.0f, zl * 16.0f, zh * 16.0f, tintIndex));
            }
            if (east) {
                quads.add(ModelHelper.createQuad(NEU, SEU, SED, NED, textureEast, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, zl * 16.0f, zh * 16.0f, tintIndex));
            }
            if (north) {
                quads.add(ModelHelper.createQuad(NWD, NWU, NEU, NED, textureUp, xl * 16.0f, xh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (south) {
                quads.add(ModelHelper.createQuad(SED, SEU, SWU, SWD, textureDown, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
        }
        if (rotation == 5) {
            if (up) {
                quads.add(ModelHelper.createQuad(NEU, NWU, SWU, SEU, textureSouth, zl * 16.0f, zh * 16.0f, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, tintIndex));
            }
            if (down) {
                quads.add(ModelHelper.createQuad(NWD, NED, SED, SWD, textureNorth, 16.0f - zl * 16.0f, 16.0f - zh * 16.0f, 16.0f - xl * 16.0f, 16.0f - xh * 16.0f, tintIndex));
            }
            if (west) {
                quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, textureDown, zl * 16.0f, zh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (east) {
                quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, textureUp, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (north) {
                quads.add(ModelHelper.createQuad(NED, NWD, NWU, NEU, textureWest, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, tintIndex));
            }
            if (south) {
                quads.add(ModelHelper.createQuad(SEU, SWU, SWD, SED, textureEast, yl * 16.0f, yh * 16.0f, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, tintIndex));
            }
        }
        if (rotation == 6) {
            if (up) {
                quads.add(ModelHelper.createQuad(SEU, NEU, NWU, SWU, textureSouth, xl * 16.0f, xh * 16.0f, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, tintIndex));
            }
            if (down) {
                quads.add(ModelHelper.createQuad(NED, SED, SWD, NWD, textureNorth, 16.0f - xl * 16.0f, 16.0f - xh * 16.0f, 16.0f - zl * 16.0f, 16.0f - zh * 16.0f, tintIndex));
            }
            if (west) {
                quads.add(ModelHelper.createQuad(SWU, NWU, NWD, SWD, textureEast, yl * 16.0f, yh * 16.0f, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, tintIndex));
            }
            if (east) {
                quads.add(ModelHelper.createQuad(SED, NED, NEU, SEU, textureWest, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, tintIndex));
            }
            if (north) {
                quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, textureDown, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (south) {
                quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, textureUp, xl * 16.0f, xh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
        }
        if (rotation == 7) {
            if (up) {
                quads.add(ModelHelper.createQuad(SWU, SEU, NEU, NWU, textureSouth, zl * 16.0f, zh * 16.0f, xl * 16.0f, xh * 16.0f, tintIndex));
            }
            if (down) {
                quads.add(ModelHelper.createQuad(SED, SWD, NWD, NED, textureNorth, 16.0f - zl * 16.0f, 16.0f - zh * 16.0f, xh * 16.0f, xl * 16.0f, tintIndex));
            }
            if (west) {
                quads.add(ModelHelper.createQuad(SWD, SWU, NWU, NWD, textureUp, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (east) {
                quads.add(ModelHelper.createQuad(NED, NEU, SEU, SED, textureDown, zl * 16.0f, zh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (north) {
                quads.add(ModelHelper.createQuad(NWU, NEU, NED, NWD, textureEast, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, xl * 16.0f, xh * 16.0f, tintIndex));
            }
            if (south) {
                quads.add(ModelHelper.createQuad(SWD, SED, SEU, SWU, textureWest, yl * 16.0f, yh * 16.0f, xl * 16.0f, xh * 16.0f, tintIndex));
            }
        }
        if (rotation == 8) {
            if (up) {
                quads.add(ModelHelper.createQuad(NWU, SWU, SEU, NEU, textureNorth, xl * 16.0f, xh * 16.0f, zl * 16.0f, zh * 16.0f, tintIndex));
            }
            if (down) {
                quads.add(ModelHelper.createQuad(SWD, NWD, NED, SED, textureSouth, 16.0f - xl * 16.0f, 16.0f - xh * 16.0f, zh * 16.0f, zl * 16.0f, tintIndex));
            }
            if (west) {
                quads.add(ModelHelper.createQuad(NWD, SWD, SWU, NWU, textureWest, yl * 16.0f, yh * 16.0f, zl * 16.0f, zh * 16.0f, tintIndex));
            }
            if (east) {
                quads.add(ModelHelper.createQuad(NEU, SEU, SED, NED, textureEast, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, zl * 16.0f, zh * 16.0f, tintIndex));
            }
            if (north) {
                quads.add(ModelHelper.createQuad(NWD, NWU, NEU, NED, textureUp, xl * 16.0f, xh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (south) {
                quads.add(ModelHelper.createQuad(SED, SEU, SWU, SWD, textureDown, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
        }
        if (rotation == 9) {
            if (up) {
                quads.add(ModelHelper.createQuad(NEU, NWU, SWU, SEU, textureNorth, zl * 16.0f, zh * 16.0f, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, tintIndex));
            }
            if (down) {
                quads.add(ModelHelper.createQuad(NWD, NED, SED, SWD, textureSouth, 16.0f - zl * 16.0f, 16.0f - zh * 16.0f, 16.0f - xl * 16.0f, 16.0f - xh * 16.0f, tintIndex));
            }
            if (west) {
                quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, textureDown, zl * 16.0f, zh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (east) {
                quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, textureUp, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (north) {
                quads.add(ModelHelper.createQuad(NED, NWD, NWU, NEU, textureWest, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, tintIndex));
            }
            if (south) {
                quads.add(ModelHelper.createQuad(SEU, SWU, SWD, SED, textureEast, yl * 16.0f, yh * 16.0f, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, tintIndex));
            }
        }
        if (rotation == 10) {
            if (up) {
                quads.add(ModelHelper.createQuad(SEU, NEU, NWU, SWU, textureNorth, xl * 16.0f, xh * 16.0f, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, tintIndex));
            }
            if (down) {
                quads.add(ModelHelper.createQuad(NED, SED, SWD, NWD, textureSouth, 16.0f - xl * 16.0f, 16.0f - xh * 16.0f, 16.0f - zl * 16.0f, 16.0f - zh * 16.0f, tintIndex));
            }
            if (west) {
                quads.add(ModelHelper.createQuad(SWU, NWU, NWD, SWD, textureEast, yl * 16.0f, yh * 16.0f, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, tintIndex));
            }
            if (east) {
                quads.add(ModelHelper.createQuad(SED, NED, NEU, SEU, textureWest, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, tintIndex));
            }
            if (north) {
                quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, textureDown, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (south) {
                quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, textureUp, xl * 16.0f, xh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
        }
        if (rotation == 11) {
            if (up) {
                quads.add(ModelHelper.createQuad(SWU, SEU, NEU, NWU, textureNorth, zl * 16.0f, zh * 16.0f, xl * 16.0f, xh * 16.0f, tintIndex));
            }
            if (down) {
                quads.add(ModelHelper.createQuad(SED, SWD, NWD, NED, textureSouth, 16.0f - zl * 16.0f, 16.0f - zh * 16.0f, xh * 16.0f, xl * 16.0f, tintIndex));
            }
            if (west) {
                quads.add(ModelHelper.createQuad(SWD, SWU, NWU, NWD, textureUp, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (east) {
                quads.add(ModelHelper.createQuad(NED, NEU, SEU, SED, textureDown, zl * 16.0f, zh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (north) {
                quads.add(ModelHelper.createQuad(NWU, NEU, NED, NWD, textureEast, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, xl * 16.0f, xh * 16.0f, tintIndex));
            }
            if (south) {
                quads.add(ModelHelper.createQuad(SWD, SED, SEU, SWU, textureWest, yl * 16.0f, yh * 16.0f, xl * 16.0f, xh * 16.0f, tintIndex));
            }
        }
        return quads;
    }

    public static List<BakedQuad> createSixFaceVoxel(float x, float y, float z, BlockState mimic, BakedModel model, ModelData extraData, RandomSource rand, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, int rotation) {
        return ModelHelper.createSixFaceCuboid(x / 16.0f, (x + 1.0f) / 16.0f, y / 16.0f, (y + 1.0f) / 16.0f, z / 16.0f, (z + 1.0f) / 16.0f, mimic, model, extraData, rand, tintIndex, north, south, east, west, up, down, rotation);
    }

    public static List<BakedQuad> createSixFaceCuboid(float xl, float xh, float yl, float yh, float zl, float zh, int tintIndex, TextureAtlasSprite textureNorth, TextureAtlasSprite textureSouth, TextureAtlasSprite textureEast, TextureAtlasSprite textureWest, TextureAtlasSprite textureUp, TextureAtlasSprite textureDown, int rotation) {
        return ModelHelper.createSixFaceCuboid(xl, xh, yl, yh, zl, zh, tintIndex, true, true, true, true, true, true, textureNorth, textureSouth, textureEast, textureWest, textureUp, textureDown, true, rotation);
    }

    public static List<BakedQuad> createSixFaceCuboid(float xl, float xh, float yl, float yh, float zl, float zh, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, TextureAtlasSprite textureNorth, TextureAtlasSprite textureSouth, TextureAtlasSprite textureEast, TextureAtlasSprite textureWest, TextureAtlasSprite textureUp, TextureAtlasSprite textureDown, Boolean moveOverlay, int rotation) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vec3 NWU = ModelHelper.v(xl, yh, zl);
        Vec3 SWU = ModelHelper.v(xl, yh, zh);
        Vec3 NWD = ModelHelper.v(xl, yl, zl);
        Vec3 SWD = ModelHelper.v(xl, yl, zh);
        Vec3 NEU = ModelHelper.v(xh, yh, zl);
        Vec3 SEU = ModelHelper.v(xh, yh, zh);
        Vec3 NED = ModelHelper.v(xh, yl, zl);
        Vec3 SED = ModelHelper.v(xh, yl, zh);
        if (xh - xl > 1.0f || yh - yl > 1.0f || zh - zl > 1.0f) {
            if (Minecraft.m_91087_().f_91074_ != null) {
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.block_error"), true);
            }
            return quads;
        }
        if (xl < 0.0f) {
            xl += 1.0f;
            xh += 1.0f;
        }
        if (xh > 1.0f) {
            xh -= 1.0f;
            xl -= 1.0f;
        }
        if (yl < 0.0f) {
            yl += 1.0f;
            yh += 1.0f;
        }
        if (yh > 1.0f) {
            yh -= 1.0f;
            yl -= 1.0f;
        }
        if (zl < 0.0f) {
            zl += 1.0f;
            zh += 1.0f;
        }
        if (zh > 1.0f) {
            zh -= 1.0f;
            zl -= 1.0f;
        }
        if (rotation == 0) {
            if (up && textureUp != null) {
                quads.add(ModelHelper.createQuad(NWU, SWU, SEU, NEU, textureUp, xl * 16.0f, xh * 16.0f, zl * 16.0f, zh * 16.0f, tintIndex));
            }
            if (down && textureDown != null) {
                quads.add(ModelHelper.createQuad(NED, SED, SWD, NWD, textureDown, xh * 16.0f, xl * 16.0f, 16.0f - zl * 16.0f, 16.0f - zh * 16.0f, tintIndex));
            }
            if (west && textureWest != null && !moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, textureWest, zl * 16.0f, zh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (east && textureEast != null && !moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, textureEast, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (north && textureNorth != null && !moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, textureNorth, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (south && textureSouth != null && !moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, textureSouth, xl * 16.0f, xh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (west && textureWest != null && moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, textureWest, zl * 16.0f, zh * 16.0f, yl * 16.0f, yh * 16.0f, tintIndex));
            }
            if (east && textureEast != null && moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, textureEast, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, yl * 16.0f, yh * 16.0f, tintIndex));
            }
            if (north && textureNorth != null && moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, textureNorth, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, yl * 16.0f, yh * 16.0f, tintIndex));
            }
            if (south && textureSouth != null && moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, textureSouth, xl * 16.0f, xh * 16.0f, yl * 16.0f, yh * 16.0f, tintIndex));
            }
        }
        if (rotation == 1) {
            if (up && textureUp != null) {
                quads.add(ModelHelper.createQuad(NWU, NEU, SEU, SWU, textureUp, xl * 16.0f, xh * 16.0f, zl * 16.0f, zh * 16.0f, tintIndex));
            }
            if (down && textureDown != null) {
                quads.add(ModelHelper.createQuad(NED, NWD, SWD, SED, textureDown, xl * 16.0f, xh * 16.0f, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, tintIndex));
            }
            if (north && textureNorth != null && !moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(SWU, SWD, NWD, NWU, textureNorth, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (south && textureSouth != null && !moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(NEU, NED, SED, SEU, textureSouth, xl * 16.0f, xh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (east && textureEast != null && !moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(NWU, NWD, NED, NEU, textureEast, zl * 16.0f, zh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (west && textureWest != null && !moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(SEU, SED, SWD, SWU, textureWest, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (north && textureNorth != null && moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(SWU, SWD, NWD, NWU, textureNorth, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, yl * 16.0f, yh * 16.0f, tintIndex));
            }
            if (south && textureSouth != null && moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(NEU, NED, SED, SEU, textureSouth, xl * 16.0f, xh * 16.0f, yl * 16.0f, yh * 16.0f, tintIndex));
            }
            if (east && textureEast != null && moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(NWU, NWD, NED, NEU, textureEast, zl * 16.0f, zh * 16.0f, yl * 16.0f, yh * 16.0f, tintIndex));
            }
            if (west && textureWest != null && moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(SEU, SED, SWD, SWU, textureWest, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, yl * 16.0f, yh * 16.0f, tintIndex));
            }
        }
        return quads;
    }

    public static List<BakedQuad> createCuboid(float xl, float xh, float yl, float yh, float zl, float zh, TextureAtlasSprite texture, int tintIndex, int[] ulow, int[] uhigh, int[] vlow, int[] vhigh) {
        return ModelHelper.createCuboid(xl, xh, yl, yh, zl, zh, texture, tintIndex, true, true, true, true, true, true, ulow, uhigh, vlow, vhigh);
    }

    public static List<BakedQuad> createCuboid(float xl, float xh, float yl, float yh, float zl, float zh, TextureAtlasSprite texture, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, int[] ulow, int[] uhigh, int[] vlow, int[] vhigh) {
        if (ulow.length != 6 || uhigh.length != 6 || vlow.length != 6 || vhigh.length != 6) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vec3 NWU = ModelHelper.v(xl, yh, zl);
        Vec3 NEU = ModelHelper.v(xl, yh, zh);
        Vec3 NWD = ModelHelper.v(xl, yl, zl);
        Vec3 NED = ModelHelper.v(xl, yl, zh);
        Vec3 SWU = ModelHelper.v(xh, yh, zl);
        Vec3 SEU = ModelHelper.v(xh, yh, zh);
        Vec3 SWD = ModelHelper.v(xh, yl, zl);
        Vec3 SED = ModelHelper.v(xh, yl, zh);
        if (up) {
            quads.add(ModelHelper.createQuad(NWU, NEU, SEU, SWU, texture, ulow[0], uhigh[0], vlow[0], vhigh[0], tintIndex));
        }
        if (down) {
            quads.add(ModelHelper.createQuad(NED, NWD, SWD, SED, texture, ulow[1], uhigh[1], vlow[1], vhigh[1], tintIndex));
        }
        if (north) {
            quads.add(ModelHelper.createQuad(NWU, NWD, NED, NEU, texture, ulow[2], uhigh[2], vlow[2], vhigh[2], tintIndex));
        }
        if (east) {
            quads.add(ModelHelper.createQuad(NEU, NED, SED, SEU, texture, ulow[3], uhigh[3], vlow[3], vhigh[3], tintIndex));
        }
        if (south) {
            quads.add(ModelHelper.createQuad(SEU, SED, SWD, SWU, texture, ulow[4], uhigh[4], vlow[4], vhigh[4], tintIndex));
        }
        if (west) {
            quads.add(ModelHelper.createQuad(SWU, SWD, NWD, NWU, texture, ulow[5], uhigh[5], vlow[5], vhigh[5], tintIndex));
        }
        return quads;
    }

    public static List<BakedQuad> createVoxel(int x, int y, int z, TextureAtlasSprite texture, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down) {
        return ModelHelper.createCuboid((float)x / 16.0f, (float)(x + 1) / 16.0f, (float)y / 16.0f, (float)(y + 1) / 16.0f, (float)z / 16.0f, (float)(z + 1) / 16.0f, texture, tintIndex, north, south, east, west, up, down);
    }

    public static List<BakedQuad> createSixFaceVoxel(int x, int y, int z, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, TextureAtlasSprite textureNorth, TextureAtlasSprite textureSouth, TextureAtlasSprite textureEast, TextureAtlasSprite textureWest, TextureAtlasSprite textureUp, TextureAtlasSprite textureDown, Boolean moveOverlay, int rotation) {
        return ModelHelper.createSixFaceCuboid((float)x / 16.0f, (float)(x + 1) / 16.0f, (float)y / 16.0f, (float)(y + 1) / 16.0f, (float)z / 16.0f, (float)(z + 1) / 16.0f, tintIndex, north, south, east, west, up, down, textureNorth, textureSouth, textureEast, textureWest, textureUp, textureDown, moveOverlay, 0);
    }

    private static Vec3 v(double x, double y, double z) {
        return new Vec3(x, y, z);
    }

    public static List<BakedQuad> createOverlayVoxel(int x, int y, int z, int overlayIndex) {
        return ModelHelper.createOverlay((float)x / 16.0f, (float)(x + 1) / 16.0f, (float)y / 16.0f, (float)(y + 1) / 16.0f, (float)z / 16.0f, (float)(z + 1) / 16.0f, overlayIndex);
    }

    public static List<BakedQuad> createOverlayVoxel(int x, int y, int z, int overlayIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, Boolean doNotMoveOverlay) {
        return ModelHelper.createOverlay((float)x / 16.0f, (float)(x + 1) / 16.0f, (float)y / 16.0f, (float)(y + 1) / 16.0f, (float)z / 16.0f, (float)(z + 1) / 16.0f, overlayIndex, north, south, east, west, up, down, doNotMoveOverlay);
    }

    public static List<BakedQuad> createOverlay(float xl, float xh, float yl, float yh, float zl, float zh, int overlayIndex) {
        return ModelHelper.createOverlay(xl, xh, yl, yh, zl, zh, overlayIndex, true, true, true, true, true, true, true);
    }

    public static List<BakedQuad> createOverlay(float xl, float xh, float yl, float yh, float zl, float zh, int overlayIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, Boolean doNotMoveOverlay) {
        int tintIndex = -1;
        TextureAtlasSprite overlay = null;
        TextureAtlasSprite upOverlay = null;
        TextureAtlasSprite downOverlay = null;
        if (overlayIndex == 1) {
            tintIndex = 1;
            overlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/grass_block_side_overlay"));
            upOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/grass_block_top"));
        }
        if (overlayIndex == 2) {
            tintIndex = 1;
            overlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/grass_block_side_overlay_large"));
            upOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/grass_block_top"));
        }
        if (overlayIndex == 3) {
            overlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/grass_block_snow_overlay"));
            upOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/snow"));
        }
        if (overlayIndex == 4) {
            overlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/grass_block_snow_overlay_small"));
            upOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/snow"));
        }
        if (overlayIndex == 5) {
            tintIndex = 1;
            overlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/vine"));
        }
        if (overlayIndex >= 6 && overlayIndex <= 10) {
            doNotMoveOverlay = false;
            if (overlayIndex == 6) {
                overlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/stone_brick_overlay"));
                upOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/stone_brick_overlay"));
                downOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/stone_brick_overlay"));
            }
            if (overlayIndex == 7) {
                overlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/brick_overlay"));
                upOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/brick_overlay"));
                downOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/brick_overlay"));
            }
            if (overlayIndex == 8) {
                overlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/chiseled_sandstone_overlay"));
            }
            if (overlayIndex == 9) {
                overlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/boundary_overlay"));
                upOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/boundary_overlay"));
                downOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/boundary_overlay"));
            }
            if (overlayIndex == 10) {
                overlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/chiseled_stone_overlay"));
                upOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/chiseled_stone_overlay"));
                downOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/chiseled_stone_overlay"));
            }
        }
        return ModelHelper.createSixFaceCuboid(xl, xh, yl, yh, zl, zh, tintIndex, north, south, east, west, up, down, overlay, overlay, overlay, overlay, upOverlay, downOverlay, doNotMoveOverlay, 0);
    }

    public static List<BakedQuad> createSixFaceCuboidAsVoxels(int xl, int xh, int yl, int yh, int zl, int zh, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, TextureAtlasSprite textureNorth, TextureAtlasSprite textureSouth, TextureAtlasSprite textureEast, TextureAtlasSprite textureWest, TextureAtlasSprite textureUp, TextureAtlasSprite textureDown, Boolean moveOverlay) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (int x = xl; x < xh; ++x) {
            for (int y = yl; y < yh; ++y) {
                for (int z = zl; z < zh; ++z) {
                    quads.addAll(ModelHelper.createSixFaceVoxel(x, y, z, tintIndex, z == zl, z == zh - 1, x == xh - 1, x == xl, y == yh - 1, y == yl, textureNorth, textureSouth, textureEast, textureWest, textureUp, textureDown, moveOverlay, 0));
                }
            }
        }
        return quads;
    }
}

