/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.setup.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BCModConfig {
    public static final String CATEGORY_TOOLS = "tools";
    public static final String CATEGORY_BLOCKS = "blocks";
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec.BooleanValue HAMMER_NEEDED;
    public static ForgeConfigSpec.BooleanValue SNEAK_FOR_TEXTURE_WRENCH_TO_ROTATE_MIMICKED_BLOCKS;
    public static ForgeConfigSpec.BooleanValue SNEAK_FOR_VERTICAL_SLABS;

    private static void setupToolSettings() {
        HAMMER_NEEDED = COMMON_BUILDER.comment("Determines whether you need a hammer to remove blocks from a frame, when set to false, you can remove blocks from a frame by sneaking and right-clicking the block (default: true)").define("hammer_needed", true);
    }

    private static void setupBlockSettings() {
        SNEAK_FOR_VERTICAL_SLABS = COMMON_BUILDER.comment("Determines whether you have to sneak when placing vertical slabs, when set to false, frame slabs will always be placed on the side of the block; when set to true, frame slabs will be placed like vanilla slabs, and you have to sneak in order to make place vertical slabs (default: true)").define("sneak_for_vertical_slabs", true);
    }

    private static void setupClientSettings() {
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    static {
        COMMON_BUILDER.comment("Tool settings").push(CATEGORY_TOOLS);
        BCModConfig.setupToolSettings();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Block settings").push(CATEGORY_BLOCKS);
        BCModConfig.setupBlockSettings();
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }
}

