/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.block;

import mod.pianomanu.blockcarpentry.item.BCToolItem;
import mod.pianomanu.blockcarpentry.item.BaseFrameItem;
import mod.pianomanu.blockcarpentry.item.BaseIllusionItem;
import mod.pianomanu.blockcarpentry.setup.Registration;
import mod.pianomanu.blockcarpentry.setup.config.BCModConfig;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BCBlockStateProperties;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelperItems;
import mod.pianomanu.blockcarpentry.util.BlockSavingHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public interface IFrameBlock {
    public static final BooleanProperty CONTAINS_BLOCK = BCBlockStateProperties.CONTAINS_BLOCK;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty LIGHT_LEVEL = BCBlockStateProperties.LIGHT_LEVEL;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;

    public static int getLightEmission(BlockState state) {
        if ((Integer)state.m_61143_((Property)LIGHT_LEVEL) > 15) {
            return 15;
        }
        return (Integer)state.m_61143_((Property)LIGHT_LEVEL);
    }

    default public boolean shouldCallFrameUse(BlockState state, ItemStack itemStack) {
        return (Boolean)state.m_61143_((Property)CONTAINS_BLOCK) == false || BlockAppearanceHelperItems.isAppearanceModifier(itemStack.m_41720_()) || itemStack.m_41720_() instanceof BCToolItem;
    }

    default public boolean removeBlock(Level level, BlockPos pos, BlockState state, ItemStack itemStack, Player player) {
        if (itemStack.m_41720_() == Registration.HAMMER.get() || !((Boolean)BCModConfig.HAMMER_NEEDED.get()).booleanValue() && player.m_6047_()) {
            if (!player.m_7500_()) {
                this.dropContainedBlock(level, pos);
            } else {
                this.clearTile(level, pos);
            }
            state = (BlockState)state.m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE);
            level.m_7731_(pos, state, 2);
            return true;
        }
        return false;
    }

    default public void clearTile(Level level, BlockPos pos) {
        FrameBlockTile frameBlockEntity;
        BlockState blockState;
        BlockEntity tileentity;
        if (!level.f_46443_ && (tileentity = level.m_7702_(pos)) instanceof FrameBlockTile && (blockState = (frameBlockEntity = (FrameBlockTile)tileentity).getMimic()) != null) {
            frameBlockEntity.clear();
        }
    }

    default public void dropContainedBlock(Level level, BlockPos pos) {
        FrameBlockTile frameBlockEntity;
        BlockState blockState;
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof FrameBlockTile && (blockState = (frameBlockEntity = (FrameBlockTile)blockEntity).getMimic()) != null) {
            this.dropItemStackInWorld(level, pos, blockState);
            frameBlockEntity.clear();
        }
    }

    default public void dropItemStackInWorld(Level level, BlockPos pos, BlockState blockState) {
        level.m_46796_(1010, pos, 0);
        float f = 0.7f;
        double dx = (double)(level.f_46441_.m_188501_() * f) + (double)0.15f;
        double dy = (double)(level.f_46441_.m_188501_() * f) + (double)f;
        double dz = (double)(level.f_46441_.m_188501_() * f) + (double)0.15f;
        ItemStack itemStack = new ItemStack((ItemLike)blockState.m_60734_());
        ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + dx, (double)pos.m_123342_() + dy, (double)pos.m_123343_() + dz, itemStack);
        itemEntity.m_32060_();
        level.m_7967_((Entity)itemEntity);
    }

    default public void insertBlock(Level levelIn, BlockPos pos, BlockState state, BlockState handBlock) {
        BlockEntity blockEntity = levelIn.m_7702_(pos);
        if (this.isCorrectTileInstance(blockEntity)) {
            this.fillBlockEntity(levelIn, pos, state, handBlock, blockEntity);
        }
    }

    default public void fillBlockEntity(Level levelIn, BlockPos pos, BlockState state, BlockState handBlock, BlockEntity blockEntity) {
        FrameBlockTile frameBlockEntity = (FrameBlockTile)blockEntity;
        frameBlockEntity.clear();
        frameBlockEntity.setMimic(handBlock);
        levelIn.m_7731_(pos, (BlockState)state.m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.TRUE), 2);
    }

    default public InteractionResult frameUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitresult) {
        ItemStack itemStack = player.m_21120_(hand);
        if (this.removeBlock(level, pos, state, itemStack, player)) {
            return InteractionResult.SUCCESS;
        }
        if (BlockAppearanceHelper.setLightLevel(itemStack, state, level, pos, player, hand) || BlockAppearanceHelper.setTexture(itemStack, state, level, player, pos) || BlockAppearanceHelper.setDesign(level, pos, player, itemStack) || BlockAppearanceHelper.setDesignTexture(level, pos, player, itemStack) || BlockAppearanceHelper.setColor(level, pos, player, hand) || BlockAppearanceHelper.setOverlay(level, pos, player, itemStack) || BlockAppearanceHelper.setRotation(level, pos, player, itemStack)) {
            return InteractionResult.SUCCESS;
        }
        if (itemStack.m_41720_() instanceof BlockItem && this.changeMimic(state, level, pos, player, itemStack)) {
            return InteractionResult.SUCCESS;
        }
        return itemStack.m_41720_() instanceof BlockItem ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    default public boolean changeMimic(BlockState state, Level level, BlockPos pos, Player player, ItemStack itemStack) {
        if (((Boolean)state.m_61143_((Property)BCBlockStateProperties.CONTAINS_BLOCK)).booleanValue() || itemStack.m_41720_() instanceof BaseFrameItem || itemStack.m_41720_() instanceof BaseIllusionItem) {
            return false;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        int count = itemStack.m_41613_();
        Block heldBlock = ((BlockItem)itemStack.m_41720_()).m_40614_();
        if (this.isCorrectTileInstance(blockEntity) && !itemStack.m_41619_() && BlockSavingHelper.isValidBlock(heldBlock) && !((Boolean)state.m_61143_((Property)CONTAINS_BLOCK)).booleanValue()) {
            BlockState handBlockState = ((BlockItem)itemStack.m_41720_()).m_40614_().m_49966_();
            this.insertBlock(level, pos, state, handBlockState);
            if (!player.m_7500_()) {
                itemStack.m_41764_(count - 1);
            }
        }
        return true;
    }

    default public boolean isCorrectTileInstance(BlockEntity blockEntity) {
        return blockEntity instanceof FrameBlockTile;
    }
}

