/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui_hud.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TEntityRendererElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TContextMenuPanel;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.apache.logging.log4j.util.TriConsumer;

public abstract class BSHudStatWidget
extends TElement {
    public static final int SIZE = 21;
    public static final int DRAG_STEP = 5;
    protected double anchorX;
    protected double anchorY;
    protected final StatsCounter statHandler;
    protected final TriConsumer<TElement, Boolean, Boolean> ehChildAr_reposition;
    protected int dragOffMouseX;
    protected int dragOffMouseY;

    public BSHudStatWidget(int x, int y, StatsCounter statHandler) {
        super(x, y, 21, 21);
        this.statHandler = Objects.requireNonNull(statHandler, "statHandler must not be null.");
        this.ehChildAr_reposition = (TriConsumer)this.getEvents().CHILD_AR.addWeakEventHandler((child, added, repositioned) -> {
            if (!added.booleanValue()) {
                return;
            }
            TElement lastChild = child.previous();
            if (!this.getTChildren().contains((Object)lastChild)) {
                child.setPosition(0, 0, true);
            } else {
                child.setPosition(lastChild.getTpeEndX(), this.getTpeY(), false);
            }
        });
    }

    public void updateRenderingBoundingBox() {
        this.RENDER_RECT.setLocation(this.x, this.y);
        this.RENDER_RECT.setSize(this.width, this.height);
    }

    public void onParentChanged() {
        if (this.getTParent() != null) {
            this.init();
        }
    }

    public boolean reCalculateAnchor() {
        if (this.screen == null) {
            return false;
        }
        int sW = this.screen.getTpeWidth();
        int sH = this.screen.getTpeHeight();
        this.anchorX = (sW -= this.getTpeWidth()) > 0 ? (double)this.getTpeX() / (double)sW : 0.0;
        this.anchorY = sH > 0 ? (double)this.getTpeY() / (double)(sH -= this.getTpeHeight()) : 0.0;
        return true;
    }

    public boolean rePositionToAnchor() {
        if (this.screen == null) {
            return false;
        }
        int sW = this.screen.getTpeWidth();
        int sH = this.screen.getTpeHeight();
        int x = (int)(this.anchorX * (double)(sW -= this.getTpeWidth()));
        int y = (int)(this.anchorY * (double)(sH -= this.getTpeHeight()));
        this.setPosition(x, y, false);
        return true;
    }

    public final void init() {
        this.clearTChildren();
        this.onInit();
        this.reAlignElements();
        this.updateRenderingBoundingBox();
        this.forEachChild(child -> {
            child.updateRenderingBoundingBox();
            return false;
        }, true);
        this.tick();
    }

    public abstract void onInit();

    public void reAlignElements() {
        TElement last = null;
        for (TElement child : this.getTChildren()) {
            if (last == null) {
                child.setPosition(0, 0, true);
            } else {
                child.setPosition(last.getTpeEndX(), this.getTpeY(), false);
            }
            last = child;
        }
        this.width = last == null ? 21 : Math.abs(last.getTpeEndX() - this.getTpeX());
        this.updateRenderingBoundingBox();
    }

    public ItemEntry addItemEntry(Item item) {
        return new ItemEntry(item);
    }

    public EntityEntry addEntityEntry(EntityType<?> entityType) {
        return new EntityEntry(entityType);
    }

    protected void onContextMenu(TContextMenuPanel contextMenu) {
        super.onContextMenu(contextMenu);
        if (contextMenu.getTChildren().size() > 0) {
            contextMenu.addSeparator();
        }
        contextMenu.addButton((Component)TextUtils.translatable((String)"selectWorld.deleteButton", (Object[])new Object[0]), btn -> {
            if (this.getTParent() != null) {
                this.getTParent().removeTChild((TElement)this);
            }
        });
    }

    public boolean mousePressed(int mouseX, int mouseY, int button) {
        if (button == 1) {
            this.showContextMenu(mouseX, mouseY);
            return true;
        }
        this.dragOffMouseX = mouseX - this.getTpeX();
        this.dragOffMouseY = mouseY - this.getTpeY();
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
        int targetX = (int)mouseX - this.dragOffMouseX;
        int targetY = (int)mouseY - this.dragOffMouseY;
        targetX -= targetX % 5;
        targetY -= targetY % 5;
        this.setPosition(targetX, targetY, false);
        this.reCalculateAnchor();
        return true;
    }

    public void render(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
        BSHudStatWidget.m_93172_((PoseStack)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)0x50000000);
        BSHudStatWidget.m_93172_((PoseStack)matrices, (int)this.x, (int)this.y, (int)(this.x + 21), (int)(this.y + this.height), (int)0x50000000);
        if (this.isFocusedOrHovered()) {
            this.drawOutline(matrices, -1);
        }
    }

    protected class ItemEntry
    extends TElement {
        protected ItemStack stack;

        public ItemEntry(Item item) {
            super(0, 0, 21, 21);
            if (item == null) {
                item = Items.f_41852_;
            }
            this.stack = item.m_7968_();
            BSHudStatWidget.this.addTChild(this);
        }

        public boolean isClickThrough() {
            return true;
        }

        public int getTpeY() {
            return BSHudStatWidget.this.getTpeY();
        }

        public void render(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
            this.getItemRenderer().m_115123_(this.stack, this.getTpeX() + 3, this.getTpeY() + 3);
        }
    }

    protected class EntityEntry
    extends TEntityRendererElement {
        public EntityEntry(EntityType<?> entityType) {
            super(0, 0, 21, 21, entityType);
            BSHudStatWidget.this.addTChild((TElement)this);
        }

        public boolean isClickThrough() {
            return true;
        }

        public int getTpeY() {
            return BSHudStatWidget.this.getTpeY();
        }

        public void render(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
            super.render(matrices, this.getTpeX() + 150, this.getTpeY() + 55, deltaTime);
        }
    }

    protected class LabelEntry
    extends TLabelElement {
        protected int txt_width;

        public LabelEntry(Component text) {
            super(0, 0, 21, 21, text);
            BSHudStatWidget.this.addTChild((TElement)this);
        }

        public boolean isClickThrough() {
            return true;
        }

        public int getTpeY() {
            return BSHudStatWidget.this.getTpeY() + 1;
        }

        protected void setTpeWidth(int width) {
            this.width = width;
            this.updateRenderingBoundingBox();
            BSHudStatWidget.this.reAlignElements();
        }

        public void setText(Component label) {
            int w;
            super.setText(label);
            int n = w = label != null ? this.getTextRenderer().m_92852_((FormattedText)label) : 0;
            if (w != this.txt_width) {
                this.setTpeWidth(w + 10);
            }
            this.txt_width = w;
        }

        public void render(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
            this.drawTElementText(matrices, this.getText(), this.getHorizontalAlignment(), this.getColor(), 5, deltaTime);
        }
    }
}

