/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.mixin;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.bettercombat.BetterCombat;
import net.bettercombat.api.AttackHand;
import net.bettercombat.api.EntityPlayer_BetterCombat;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.client.animation.PlayerAttackAnimatable;
import net.bettercombat.logic.PlayerAttackHelper;
import net.bettercombat.logic.PlayerAttackProperties;
import net.bettercombat.logic.WeaponRegistry;
import net.bettercombat.mixin.PlayerEntityAccessor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
implements PlayerAttackProperties,
EntityPlayer_BetterCombat {
    private int comboCount = 0;
    private Multimap<Attribute, AttributeModifier> dualWieldingAttributeMap;
    private static UUID dualWieldingSpeedModifierId = UUID.fromString("6b364332-0dc4-11ed-861d-0242ac120002");
    private AttackHand lastAttack;

    @Override
    public int getComboCount() {
        return this.comboCount;
    }

    @Override
    public void setComboCount(int comboCount) {
        this.comboCount = comboCount;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void post_Tick(CallbackInfo ci) {
        PlayerEntityMixin instance = this;
        if (((Player)instance).f_19853_.m_5776_()) {
            ((PlayerAttackAnimatable)((Object)this)).updateAnimationsOnTick();
        }
        this.updateDualWieldingSpeedBoost();
    }

    @ModifyVariable(method={"attack"}, at=@At(value="STORE"), ordinal=3)
    private boolean disableSweeping(boolean value) {
        if (BetterCombat.config.allow_vanilla_sweeping) {
            return value;
        }
        Player player = (Player)this;
        AttackHand currentHand = PlayerAttackHelper.getCurrentAttack(player, this.comboCount);
        if (currentHand != null) {
            return false;
        }
        return value;
    }

    @Inject(method={"getEquippedStack"}, at={@At(value="HEAD")}, cancellable=true)
    public void getEquippedStack_Pre(EquipmentSlot slot, CallbackInfoReturnable<ItemStack> cir) {
        boolean mainHandHasTwoHanded = false;
        ItemStack mainHandStack = ((PlayerEntityAccessor)((Object)this)).getInventory().m_36056_();
        WeaponAttributes mainHandAttributes = WeaponRegistry.getAttributes(mainHandStack);
        if (mainHandAttributes != null && mainHandAttributes.isTwoHanded()) {
            mainHandHasTwoHanded = true;
        }
        boolean offHandHasTwoHanded = false;
        ItemStack offHandStack = (ItemStack)((PlayerEntityAccessor)((Object)this)).getInventory().f_35976_.get(0);
        WeaponAttributes offHandAttributes = WeaponRegistry.getAttributes(offHandStack);
        if (offHandAttributes != null && offHandAttributes.isTwoHanded()) {
            offHandHasTwoHanded = true;
        }
        if (slot == EquipmentSlot.OFFHAND && (mainHandHasTwoHanded || offHandHasTwoHanded)) {
            cir.setReturnValue((Object)ItemStack.f_41583_);
            cir.cancel();
            return;
        }
    }

    private void updateDualWieldingSpeedBoost() {
        boolean currentState;
        Player player = (Player)this;
        boolean newState = PlayerAttackHelper.isDualWielding(player);
        boolean bl = currentState = this.dualWieldingAttributeMap != null;
        if (newState != currentState) {
            if (newState) {
                this.dualWieldingAttributeMap = HashMultimap.create();
                double multiplier = BetterCombat.config.dual_wielding_attack_speed_multiplier - 1.0f;
                this.dualWieldingAttributeMap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(dualWieldingSpeedModifierId, "Dual wielding attack speed boost", multiplier, AttributeModifier.Operation.MULTIPLY_BASE));
                player.m_21204_().m_22178_(this.dualWieldingAttributeMap);
            } else if (this.dualWieldingAttributeMap != null) {
                player.m_21204_().m_22161_(this.dualWieldingAttributeMap);
                this.dualWieldingAttributeMap = null;
            }
        }
    }

    @ModifyArg(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getStackInHand(Lnet/minecraft/util/Hand;)Lnet/minecraft/item/ItemStack;"), index=0)
    public InteractionHand getHand(InteractionHand hand) {
        Player player = (Player)this;
        AttackHand currentHand = PlayerAttackHelper.getCurrentAttack(player, this.comboCount);
        if (currentHand != null) {
            return currentHand.isOffHand() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        }
        return InteractionHand.MAIN_HAND;
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getMainHandStack()Lnet/minecraft/item/ItemStack;"))
    public ItemStack getMainHandStack_Redirect(Player instance) {
        if (this.comboCount < 0) {
            return instance.m_21205_();
        }
        AttackHand hand = PlayerAttackHelper.getCurrentAttack(instance, this.comboCount);
        if (hand == null) {
            boolean isOffHand = PlayerAttackHelper.shouldAttackWithOffHand(instance, this.comboCount);
            if (isOffHand) {
                return ItemStack.f_41583_;
            }
            return instance.m_21205_();
        }
        this.lastAttack = hand;
        return hand.itemStack();
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;setStackInHand(Lnet/minecraft/util/Hand;Lnet/minecraft/item/ItemStack;)V"))
    public void setStackInHand_Redirect(Player instance, InteractionHand handArg, ItemStack itemStack) {
        AttackHand hand;
        if (this.comboCount < 0) {
            instance.m_21008_(handArg, itemStack);
        }
        if ((hand = this.lastAttack) == null) {
            hand = PlayerAttackHelper.getCurrentAttack(instance, this.comboCount);
        }
        if (hand == null) {
            instance.m_21008_(handArg, itemStack);
            return;
        }
        InteractionHand redirectedHand = hand.isOffHand() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        instance.m_21008_(redirectedHand, itemStack);
    }

    @Override
    @Nullable
    public AttackHand getCurrentAttack() {
        if (this.comboCount < 0) {
            return null;
        }
        Player player = (Player)this;
        return PlayerAttackHelper.getCurrentAttack(player, this.comboCount);
    }
}

