/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.autothirdperson.forge;

import agency.highlysuspect.autothirdperson.AutoThirdPerson;
import agency.highlysuspect.autothirdperson.config.ConfigProperties;
import agency.highlysuspect.autothirdperson.config.ConfigProperty;
import agency.highlysuspect.autothirdperson.config.ConfigSchema;
import agency.highlysuspect.autothirdperson.config.CookedConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraftforge.common.ForgeConfigSpec;

public class ForgeCookedConfig
implements CookedConfig {
    public final ForgeConfigSpec forgeSpec;
    private final Map<ConfigProperty<?>, ForgeConfigSpec.ConfigValue<?>> forgeProps = new HashMap();
    private final Map<ConfigProperty<?>, Object> parsedValues = new HashMap();

    public ForgeCookedConfig(ConfigSchema schema) {
        final ForgeConfigSpec.Builder forge = new ForgeConfigSpec.Builder();
        schema.accept(new ConfigSchema.Visitor(){
            boolean noSectionsYet = true;

            @Override
            public void visitSection(ConfigSchema.Section section) {
                if (this.noSectionsYet) {
                    this.noSectionsYet = false;
                } else {
                    forge.pop();
                }
                if (section.comment != null) {
                    forge.comment(section.comment);
                }
                forge.push(section.getCamelCaseName());
            }

            @Override
            public <T> void visitProperty(ConfigProperty<T> prop) {
                T defaultValue = prop.defaultValue();
                Object comment = prop.comment();
                if (comment != null) {
                    if (prop.showDefaultValue()) {
                        comment = (String)comment + "\nDefault: " + prop.write(defaultValue);
                    }
                    if (((String)comment).trim().isEmpty()) {
                        comment = " ";
                    }
                    forge.comment((String)comment);
                }
                if (defaultValue instanceof Integer) {
                    int defaultInt = (Integer)defaultValue;
                    ForgeConfigSpec.ConfigValue forgeInt = forge.define(prop.name(), (Object)defaultInt, ForgeCookedConfig.this.mkValidator(prop));
                    ForgeCookedConfig.this.forgeProps.put(prop, forgeInt);
                } else if (defaultValue instanceof Boolean) {
                    boolean defaultBool = (Boolean)defaultValue;
                    ForgeConfigSpec.ConfigValue forgeBool = forge.define(prop.name(), (Object)defaultBool, ForgeCookedConfig.this.mkValidator(prop));
                    ForgeCookedConfig.this.forgeProps.put(prop, forgeBool);
                } else {
                    String defaultString = prop.write(defaultValue);
                    ForgeConfigSpec.ConfigValue forgeString = forge.define(prop.name(), (Object)defaultString, ForgeCookedConfig.this.mkValidator(prop));
                    ForgeCookedConfig.this.forgeProps.put(prop, forgeString);
                }
            }
        });
        this.forgeSpec = forge.build();
        try {
            this.refresh();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Predicate<Object> mkValidator(ConfigProperty<?> prop) {
        return obj -> {
            if (obj == null) {
                System.err.println("FORGE ASKED ME TO VALIDATE A NULL VALUE FOR " + prop.name() + ", is the filewatcher acting up again");
                return false;
            }
            if (obj instanceof String) {
                try {
                    obj = prop.read((String)obj);
                }
                catch (Exception e) {
                    AutoThirdPerson.instance.logger.warn("Option '" + prop.name() + "' failed to parse: ", e);
                    return false;
                }
            }
            try {
                ConfigProperties.validateErased(prop, obj);
            }
            catch (Exception e) {
                AutoThirdPerson.instance.logger.error("Option " + prop.name() + " failed validation: ", e);
                return false;
            }
            return true;
        };
    }

    @Override
    public <T> T get(ConfigProperty<T> prop) {
        return (T)this.parsedValues.computeIfAbsent(prop, this::load);
    }

    @Override
    public <T> T getOr(ConfigProperty<T> prop, T def) {
        if (prop == null) {
            return def;
        }
        return this.get(prop);
    }

    @Override
    public void refresh() throws Exception {
        this.parsedValues.clear();
    }

    public <T> T load(ConfigProperty<T> prop) {
        Object frog = this.forgeProps.get(prop).get();
        if (frog instanceof String) {
            try {
                frog = prop.read((String)frog);
            }
            catch (Exception e) {
                AutoThirdPerson.instance.logger.warn("Option '{}' failed to parse. Using default value of {}.", prop.name(), prop.write(prop.defaultValue()));
                return prop.defaultValue();
            }
        }
        Object frog2 = frog;
        try {
            prop.validate(frog2);
        }
        catch (Exception e) {
            AutoThirdPerson.instance.logger.warn("Option '{}' failed validation. Using default value of {}.", prop.name(), prop.write(prop.defaultValue()));
            return prop.defaultValue();
        }
        return (T)frog2;
    }
}

