/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.autothirdperson.config;

import agency.highlysuspect.autothirdperson.config.ConfigProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class ConfigSchema {
    private final List<Object> entries = new ArrayList<Object>();
    private final Map<String, ConfigProperty<?>> propsByName = new HashMap();

    public ConfigSchema section(String name, @Nullable String sectionComment, ConfigProperty<?> ... options) {
        this.entries.add(new Section(name, sectionComment));
        return this.opt(options);
    }

    public ConfigSchema opt(ConfigProperty<?> ... options) {
        for (ConfigProperty<?> opt : options) {
            if (opt == null) continue;
            this.entries.add(opt);
            this.propsByName.put(opt.name(), opt);
        }
        return this;
    }

    public void accept(Visitor v) {
        for (Object o : this.entries) {
            if (o instanceof Section) {
                v.visitSection((Section)o);
                continue;
            }
            if (o instanceof ConfigProperty) {
                v.visitProperty((ConfigProperty)o);
                continue;
            }
            throw new IllegalStateException("weird thing in config entries: " + v);
        }
    }

    public Map<String, ConfigProperty<?>> getPropsByName() {
        return this.propsByName;
    }

    public static class Section {
        public final String name;
        @Nullable
        public final String comment;

        public Section(String name, @Nullable String comment) {
            this.name = name;
            this.comment = comment;
        }

        public String getCamelCaseName() {
            Matcher m;
            Pattern p = Pattern.compile(" .");
            Object work = this.name.toLowerCase(Locale.ROOT);
            while ((m = p.matcher((CharSequence)work)).find()) {
                String beforeMatch = ((String)work).substring(0, m.start());
                String match = ((String)work).substring(m.start(), m.end());
                String afterMatch = ((String)work).substring(m.end());
                work = beforeMatch + match.trim().toUpperCase(Locale.ROOT) + afterMatch;
            }
            return work;
        }
    }

    public static interface Visitor {
        public void visitSection(Section var1);

        public <T> void visitProperty(ConfigProperty<T> var1);
    }
}

