/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.registrate.builder;

import com.tterrag.registrate.builders.BuilderCallback;
import java.util.Collections;
import java.util.EnumSet;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.apex.forge.apexcore.core.init.ACRegistry;
import xyz.apex.forge.apexcore.registrate.CoreRegistrate;
import xyz.apex.forge.apexcore.registrate.builder.AbstractBuilder;
import xyz.apex.forge.apexcore.registrate.builder.factory.EnchantmentFactory;
import xyz.apex.forge.apexcore.registrate.entry.EnchantmentEntry;

public final class EnchantmentBuilder<OWNER extends CoreRegistrate<OWNER>, ENCHANTMENT extends Enchantment, PARENT>
extends AbstractBuilder<OWNER, Enchantment, ENCHANTMENT, PARENT, EnchantmentBuilder<OWNER, ENCHANTMENT, PARENT>, EnchantmentEntry<ENCHANTMENT>> {
    private final EnchantmentFactory<ENCHANTMENT> enchantmentFactory;
    private Enchantment.Rarity enchantmentRarity = Enchantment.Rarity.COMMON;
    private EnchantmentCategory enchantmentCategory = ACRegistry.ENCHANTMENT_CATEGORY_NONE;
    private final EnumSet<EquipmentSlot> equipmentSlots = EnumSet.noneOf(EquipmentSlot.class);

    public EnchantmentBuilder(OWNER owner, PARENT parent, String name, BuilderCallback callback, EnchantmentFactory<ENCHANTMENT> enchantmentFactory) {
        super(owner, parent, name, callback, ForgeRegistries.Keys.ENCHANTMENTS, (x$0, x$1) -> new EnchantmentEntry((CoreRegistrate<?>)((CoreRegistrate)x$0), x$1), EnchantmentEntry::cast);
        this.enchantmentFactory = enchantmentFactory;
    }

    public EnchantmentBuilder<OWNER, ENCHANTMENT, PARENT> rarity(Enchantment.Rarity enchantmentRarity) {
        this.enchantmentRarity = enchantmentRarity;
        return this;
    }

    public EnchantmentBuilder<OWNER, ENCHANTMENT, PARENT> category(EnchantmentCategory enchantmentCategory) {
        this.enchantmentCategory = enchantmentCategory;
        return this;
    }

    public EnchantmentBuilder<OWNER, ENCHANTMENT, PARENT> armorSlots() {
        return this.slot(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
    }

    public EnchantmentBuilder<OWNER, ENCHANTMENT, PARENT> slot(EquipmentSlot ... slots) {
        Collections.addAll(this.equipmentSlots, slots);
        return this;
    }

    public EnchantmentBuilder<OWNER, ENCHANTMENT, PARENT> defaultLang() {
        return (EnchantmentBuilder)this.lang(Enchantment::m_44704_);
    }

    public EnchantmentBuilder<OWNER, ENCHANTMENT, PARENT> lang(String name) {
        return (EnchantmentBuilder)this.lang(Enchantment::m_44704_, name);
    }

    @Override
    protected ENCHANTMENT createEntry() {
        return this.enchantmentFactory.create(this.enchantmentRarity, this.enchantmentCategory, (EquipmentSlot[])this.equipmentSlots.toArray(EquipmentSlot[]::new));
    }
}

