/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.item;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import xyz.apex.forge.apexcore.lib.item.ItemGroupCategory;

public final class ItemGroupCategoryManager {
    private static final Map<CreativeModeTab, ItemGroupCategoryManager> categoryManagers = Maps.newHashMap();
    private final Set<ItemGroupCategory> categories = Sets.newLinkedHashSet();
    private final Set<ItemGroupCategory> enabledCategories = Sets.newHashSet();
    private final CreativeModeTab itemGroup;

    private ItemGroupCategoryManager(CreativeModeTab itemGroup) {
        this.itemGroup = itemGroup;
    }

    public void addCategory(ItemGroupCategory category) {
        this.categories.add(category);
    }

    public void addCategories(ItemGroupCategory ... categories) {
        Collections.addAll(this.categories, categories);
    }

    public void addCategories(Collection<ItemGroupCategory> categories) {
        this.categories.addAll(categories);
    }

    public Set<ItemGroupCategory> getCategories() {
        return this.categories;
    }

    public CreativeModeTab getItemGroup() {
        return this.itemGroup;
    }

    public Set<ItemGroupCategory> getEnabledCategories() {
        return this.enabledCategories;
    }

    public boolean isCategoryAllowed(ItemGroupCategory category) {
        return this.categories.contains(category);
    }

    public boolean isCategoryEnabled(ItemGroupCategory category) {
        return this.isCategoryAllowed(category) && this.enabledCategories.contains(category);
    }

    public void enableCategory(ItemGroupCategory category) {
        if (!this.isCategoryAllowed(category)) {
            return;
        }
        if (this.isCategoryEnabled(category)) {
            return;
        }
        this.enabledCategories.add(category);
    }

    public void disableCategory(ItemGroupCategory category) {
        if (!this.isCategoryAllowed(category)) {
            return;
        }
        if (!this.isCategoryEnabled(category)) {
            return;
        }
        this.enabledCategories.remove(category);
    }

    public void toggleCategory(ItemGroupCategory category) {
        if (!this.isCategoryAllowed(category)) {
            return;
        }
        if (this.isCategoryEnabled(category)) {
            this.disableCategory(category);
        } else {
            this.enableCategory(category);
        }
    }

    public void disableCategories() {
        this.enabledCategories.clear();
    }

    public void applyFilter(NonNullList<ItemStack> items) {
        items.clear();
        if (this.enabledCategories.isEmpty()) {
            this.itemGroup.m_6151_(items);
            return;
        }
        NonNullList itemGroupItems = NonNullList.m_122779_();
        this.itemGroup.m_6151_(itemGroupItems);
        block0: for (ItemStack stack : itemGroupItems) {
            for (ItemGroupCategory category : this.enabledCategories) {
                if (!category.test(stack)) continue;
                items.add((Object)stack);
                continue block0;
            }
        }
    }

    public static ItemGroupCategoryManager getInstance(CreativeModeTab itemGroup) {
        return categoryManagers.computeIfAbsent(itemGroup, ItemGroupCategoryManager::new);
    }
}

