/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import xyz.apex.forge.apexcore.lib.util.VectorHelper;

public final class VoxelShaper {
    public static final Function<Direction, Vec3> DEFAULT_ROTATION_VALUES = dir -> new Vec3(dir == Direction.UP ? 0.0 : (Direction.Plane.VERTICAL.test(dir) ? 180.0 : 90.0), (double)(-VoxelShaper.horizontalAngleFromDirection(dir)), 0.0);
    public static final Function<Direction, Vec3> HORIZONTAL_ROTATION_VALUES = dir -> new Vec3(0.0, (double)(-VoxelShaper.horizontalAngleFromDirection(dir)), 0.0);
    private final Map<Direction, VoxelShape> shapes = Maps.newEnumMap(Direction.class);

    public VoxelShape get(Direction facing) {
        return this.shapes.containsKey(facing) ? this.shapes.get(facing) : Shapes.m_83144_();
    }

    public VoxelShape get(Direction.Axis axis) {
        return this.get(VoxelShaper.axisAsFace(axis));
    }

    public VoxelShaper withVerticalShapes(VoxelShape source) {
        return this.with(source, Direction.UP).with(VoxelShaper.rotatedCopy(source, new Vec3(180.0, 0.0, 0.0)), Direction.DOWN);
    }

    public VoxelShaper with(VoxelShape source, Direction facing) {
        this.shapes.put(facing, source);
        return this;
    }

    public static Direction axisAsFace(Direction.Axis axis) {
        return Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
    }

    public static float horizontalAngleFromDirection(Direction direction) {
        return (Math.max(direction.m_122416_(), 0) & 3) * 90;
    }

    public static VoxelShaper forHorizontal(VoxelShape source, Direction facing) {
        return VoxelShaper.forDirectionsWithRotation(source, facing, (Iterable<Direction>)Direction.Plane.HORIZONTAL, HORIZONTAL_ROTATION_VALUES);
    }

    public static VoxelShaper forHorizontalAxis(VoxelShape source, Direction.Axis along) {
        return VoxelShaper.forDirectionsWithRotation(source, VoxelShaper.axisAsFace(along), Arrays.asList(Direction.SOUTH, Direction.EAST), HORIZONTAL_ROTATION_VALUES);
    }

    public static VoxelShaper forDirectional(VoxelShape source, Direction facing) {
        return VoxelShaper.forDirectionsWithRotation(source, facing, Lists.newArrayList((Object[])Direction.values()), DEFAULT_ROTATION_VALUES);
    }

    public static VoxelShaper forAxis(VoxelShape source, Direction.Axis axis) {
        return VoxelShaper.forDirectionsWithRotation(source, VoxelShaper.axisAsFace(axis), Arrays.asList(Direction.SOUTH, Direction.EAST, Direction.UP), DEFAULT_ROTATION_VALUES);
    }

    public static VoxelShaper forDirectionsWithRotation(VoxelShape source, Direction facing, Iterable<Direction> directions, Function<Direction, Vec3> usingValues) {
        VoxelShaper shaper = new VoxelShaper();
        for (Direction direction : directions) {
            shaper.with(VoxelShaper.rotate(source, facing, direction, usingValues), direction);
        }
        return shaper;
    }

    public static VoxelShape rotate(VoxelShape source, Direction from, Direction to, Function<Direction, Vec3> usingValues) {
        if (from == to) {
            return source;
        }
        return VoxelShaper.rotatedCopy(source, usingValues.apply(from).m_82548_().m_82549_(usingValues.apply(to)));
    }

    public static VoxelShape rotatedCopy(VoxelShape source, Vec3 rotation) {
        if (rotation.equals((Object)Vec3.f_82478_)) {
            return source;
        }
        MutableObject result = new MutableObject((Object)Shapes.m_83040_());
        Vec3 center = new Vec3(8.0, 8.0, 8.0);
        source.m_83286_((x1, y1, z1, x2, y2, z2) -> {
            Vec3 v1 = new Vec3(x1, y1, z1).m_82490_(16.0).m_82546_(center);
            Vec3 v2 = new Vec3(x2, y2, z2).m_82490_(16.0).m_82546_(center);
            v1 = VectorHelper.rotate(v1, (float)rotation.f_82479_, Direction.Axis.X);
            v1 = VectorHelper.rotate(v1, (float)rotation.f_82480_, Direction.Axis.Y);
            v1 = VectorHelper.rotate(v1, (float)rotation.f_82481_, Direction.Axis.Z).m_82549_(center);
            v2 = VectorHelper.rotate(v2, (float)rotation.f_82479_, Direction.Axis.X);
            v2 = VectorHelper.rotate(v2, (float)rotation.f_82480_, Direction.Axis.Y);
            v2 = VectorHelper.rotate(v2, (float)rotation.f_82481_, Direction.Axis.Z).m_82549_(center);
            VoxelShape rotated = VoxelShaper.box(v1, v2);
            result.setValue((Object)Shapes.m_83110_((VoxelShape)((VoxelShape)result.getValue()), (VoxelShape)rotated));
        });
        return (VoxelShape)result.getValue();
    }

    public static VoxelShape box(Vec3 v1, Vec3 v2) {
        return Block.m_49796_((double)Math.min(v1.f_82479_, v2.f_82479_), (double)Math.min(v1.f_82480_, v2.f_82480_), (double)Math.min(v1.f_82481_, v2.f_82481_), (double)Math.max(v1.f_82479_, v2.f_82479_), (double)Math.max(v1.f_82480_, v2.f_82480_), (double)Math.max(v1.f_82481_, v2.f_82481_));
    }

    public static VoxelShape join(BooleanOp function, VoxelShape ... shapes) {
        VoxelShape result = Shapes.m_83040_();
        for (VoxelShape shape : shapes) {
            result = Shapes.m_83113_((VoxelShape)result, (VoxelShape)shape, (BooleanOp)function);
        }
        return result.m_83296_();
    }

    public static VoxelShape or(VoxelShape ... shapes) {
        return VoxelShaper.join(BooleanOp.f_82695_, shapes);
    }
}

