/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_delight.core.other;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.teamabnormals.abnormals_delight.common.item.SlabdishItem;
import com.teamabnormals.abnormals_delight.core.other.ADConstants;
import com.teamabnormals.abnormals_delight.core.other.tags.ADBlockTags;
import com.teamabnormals.abnormals_delight.core.registry.ADItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.MathUtils;

@Mod.EventBusSubscriber(modid="abnormals_delight")
public class ADEvents {
    public static final IntegerProperty BITES = IntegerProperty.m_61631_((String)"bites", (int)0, (int)9);
    public static final HashMap<Supplier<Item>, ResourceLocation> SLICES_TO_CAKES = (HashMap)Util.m_137469_((Object)Maps.newHashMap(), list -> {
        list.put(ADItems.VANILLA_CAKE_SLICE, ADConstants.VANILLA_CAKE);
        list.put(ADItems.CHOCOLATE_CAKE_SLICE, ADConstants.CHOCOLATE_CAKE);
        list.put(ADItems.STRAWBERRY_CAKE_SLICE, ADConstants.STRAWBERRY_CAKE);
        list.put(ADItems.BANANA_CAKE_SLICE, ADConstants.BANANA_CAKE);
        list.put(ADItems.MINT_CAKE_SLICE, ADConstants.MINT_CAKE);
        list.put(ADItems.ADZUKI_CAKE_SLICE, ADConstants.ADZUKI_CAKE);
    });
    public static final HashMap<TagKey<Block>, Supplier<Item>> TAGS_TO_SLICES = (HashMap)Util.m_137469_((Object)Maps.newHashMap(), list -> {
        list.put(ADBlockTags.DROPS_VANILLA_CAKE_SLICE, ADItems.VANILLA_CAKE_SLICE);
        list.put(ADBlockTags.DROPS_CHOCOLATE_CAKE_SLICE, ADItems.CHOCOLATE_CAKE_SLICE);
        list.put(ADBlockTags.DROPS_STRAWBERRY_CAKE_SLICE, ADItems.STRAWBERRY_CAKE_SLICE);
        list.put(ADBlockTags.DROPS_BANANA_CAKE_SLICE, ADItems.BANANA_CAKE_SLICE);
        list.put(ADBlockTags.DROPS_MINT_CAKE_SLICE, ADItems.MINT_CAKE_SLICE);
        list.put(ADBlockTags.DROPS_ADZUKI_CAKE_SLICE, ADItems.ADZUKI_CAKE_SLICE);
    });

    public static Supplier<Item> getCakeSlice(BlockState state) {
        TagKey<Block> cakeTag = ADBlockTags.DROPS_FLAVORED_CAKE_SLICE;
        for (TagKey<Block> tagKey : TAGS_TO_SLICES.keySet()) {
            if (!state.m_204336_(tagKey)) continue;
            cakeTag = tagKey;
        }
        return TAGS_TO_SLICES.get(cakeTag);
    }

    @SubscribeEvent
    public static void onCakeInteraction(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        ItemStack tool = event.getEntity().m_21120_(event.getHand());
        ResourceLocation name = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
        if (tool.m_204117_(ModTags.KNIVES) && name != null) {
            if (state.m_204336_(ADBlockTags.DROPS_FLAVORED_CAKE_SLICE)) {
                Supplier<Item> cakeSlice = ADEvents.getCakeSlice(state);
                if (state.m_61138_((Property)CakeBlock.f_51180_)) {
                    int bites = (Integer)state.m_61143_((Property)CakeBlock.f_51180_);
                    if (bites < 6) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)CakeBlock.f_51180_, (Comparable)Integer.valueOf(bites + 1)), 3);
                    } else {
                        level.m_7471_(pos, false);
                    }
                } else {
                    level.m_7731_(pos, (BlockState)((Block)ForgeRegistries.BLOCKS.getValue(SLICES_TO_CAKES.get(cakeSlice))).m_49966_().m_61124_((Property)CakeBlock.f_51180_, (Comparable)Integer.valueOf(1)), 3);
                    Block.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
                }
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)cakeSlice.get()));
                level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            } else if (name.equals((Object)ADConstants.YUCCA_GATEAU)) {
                int bites = (Integer)state.m_61143_((Property)BITES);
                if (bites < 9) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
                } else {
                    level.m_7471_(pos, false);
                }
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)ADItems.YUCCA_GATEAU_SLICE.get()));
                level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockState state = event.getState();
        Player player = event.getPlayer();
        ArrayList loot = Lists.newArrayList();
        ResourceLocation name = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
        if (player.m_21205_().m_204117_(ModTags.KNIVES) && name != null) {
            if (state.m_204336_(ADBlockTags.DROPS_FLAVORED_CAKE_SLICE)) {
                Supplier<Item> cakeSlice = ADEvents.getCakeSlice(state);
                int subtraction = !state.m_61138_((Property)CakeBlock.f_51180_) ? 0 : (Integer)state.m_61143_((Property)CakeBlock.f_51180_);
                loot.add(new ItemStack((ItemLike)cakeSlice.get(), 7 - subtraction));
            } else if (name.equals((Object)ADConstants.YUCCA_GATEAU)) {
                loot.add(new ItemStack((ItemLike)ADItems.YUCCA_GATEAU_SLICE.get(), 10 - (Integer)state.m_61143_((Property)BITES)));
            }
            if (!loot.isEmpty() && event.getLevel() instanceof Level) {
                for (ItemStack stack : loot) {
                    Block.m_49840_((Level)((Level)event.getLevel()), (BlockPos)event.getPos(), (ItemStack)stack);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        Entity target = event.getTarget();
        ItemStack stack = event.getItemStack();
        if (target instanceof TamableAnimal) {
            TamableAnimal entity = (TamableAnimal)target;
            if (ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_()).equals((Object)ADConstants.SLABFISH) && entity.m_6084_() && entity.m_21824_() && stack.m_41720_().equals(ADItems.SLABDISH.get())) {
                entity.m_21153_(entity.m_21233_());
                for (MobEffectInstance effect : SlabdishItem.EFFECTS) {
                    entity.m_7292_(new MobEffectInstance(effect));
                }
                entity.f_19853_.m_5594_(null, target.m_20183_(), SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
                for (int i = 0; i < 5; ++i) {
                    double d0 = MathUtils.RAND.nextGaussian() * 0.02;
                    double d1 = MathUtils.RAND.nextGaussian() * 0.02;
                    double d2 = MathUtils.RAND.nextGaussian() * 0.02;
                    entity.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.STAR.get(), entity.m_20208_(1.0), entity.m_20187_() + 0.5, entity.m_20262_(1.0), d0, d1, d2);
                }
                if (stack.getCraftingRemainingItem() != ItemStack.f_41583_ && !player.m_7500_()) {
                    player.m_36356_(stack.getCraftingRemainingItem());
                    stack.m_41774_(1);
                }
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }
}

