/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.world.item.ItemStack;

public class LootTable {
    public static final String BLANK_KEYWORD = "$BLANK$";
    public final List<Loot> items = new ArrayList<Loot>();

    public void clearLootTable() {
        this.items.clear();
    }

    public static LootTable getCopyOfLootTable(LootTable source) {
        LootTable table = new LootTable();
        table.items.addAll(source.items);
        return table;
    }

    public void addLootToTable(ItemStack stack, int rarity) {
        if (stack != null && rarity > 0) {
            int maxIndex = this.items.size() > 0 ? this.items.get((int)(this.items.size() - 1)).maxIndex + rarity : rarity - 1;
            this.items.add(new Loot(stack, rarity, maxIndex));
        }
    }

    public Optional<Loot> getRandomLootFromTable() {
        if (this.items.size() > 0) {
            int randomIndex = new Random().nextInt(this.items.get((int)(this.items.size() - 1)).maxIndex + 1);
            for (Loot loot : this.items) {
                if (randomIndex > loot.maxIndex) continue;
                return Optional.of(loot);
            }
        }
        return Optional.empty();
    }

    public List<ItemStack> getLootTableAsList(boolean excludeEmptyStacks) {
        ArrayList<ItemStack> stacklist = new ArrayList<ItemStack>();
        for (Loot loot : this.items) {
            ItemStack stack = loot.getStack();
            if (stack.m_41619_() && excludeEmptyStacks) continue;
            stacklist.add(stack);
        }
        return stacklist;
    }

    public static class Loot {
        private final ItemStack stack;
        private final int rarity;
        private final int maxIndex;

        public Loot(ItemStack stack, int rarity, int maxIndex) {
            this.stack = stack;
            this.rarity = rarity;
            this.maxIndex = maxIndex;
        }

        public ItemStack getStack() {
            return this.stack.m_41777_();
        }

        public int getRarity() {
            return this.rarity;
        }
    }
}

