/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.villagercomfort.comfort;

import dev.ghen.villagercomfort.common.capabilty.IComfortValuesCap;
import dev.ghen.villagercomfort.common.capabilty.ModCapabilities;
import dev.ghen.villagercomfort.core.config.CommonConfig;
import dev.ghen.villagercomfort.core.math.MathHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;

public class ComfortHelper {
    public static int calculatePriceModifier(Villager villager, IComfortValuesCap cap, int basePrice) {
        int comfort = ComfortHelper.getVillagerComfort(villager);
        int finalPriceDiff = 0;
        float maxComfortInfluence = 100.0f * (1.0f / ((Number)CommonConfig.COMFORT_INFLUENCE_ON_PRICE.get()).floatValue());
        finalPriceDiff = comfort > 0 ? -MathHelper.scale(comfort, (int)maxComfortInfluence, basePrice) : MathHelper.scale(comfort, (int)(-maxComfortInfluence), 64 - basePrice);
        return finalPriceDiff;
    }

    public static int getVillagerComfort(Villager villager) {
        IComfortValuesCap cap = (IComfortValuesCap)villager.getCapability(ModCapabilities.COMFORT_VALUES_CAP).orElse(null);
        if (cap != null) {
            int comfort = 0;
            if (cap.hasBed()) {
                if (cap.getBedroomSize() >= ((Number)CommonConfig.MAX_BEDROOM_SIZE.get()).intValue()) {
                    comfort += ((Number)CommonConfig.MAX_BEDROOM_SIZE_COMFORT.get()).intValue();
                } else if (cap.getBedroomSize() > ((Number)CommonConfig.AVERAGE_BEDROOM_SIZE.get()).intValue()) {
                    comfort += MathHelper.scale(cap.getBedroomSize() - ((Number)CommonConfig.AVERAGE_BEDROOM_SIZE.get()).intValue(), ((Number)CommonConfig.MAX_BEDROOM_SIZE.get()).intValue() - ((Number)CommonConfig.AVERAGE_BEDROOM_SIZE.get()).intValue(), ((Number)CommonConfig.MAX_BEDROOM_SIZE_COMFORT.get()).intValue());
                } else if (cap.getBedroomSize() < ((Number)CommonConfig.AVERAGE_BEDROOM_SIZE.get()).intValue()) {
                    comfort += MathHelper.scale(((Number)CommonConfig.AVERAGE_BEDROOM_SIZE.get()).intValue() - cap.getBedroomSize(), ((Number)CommonConfig.AVERAGE_BEDROOM_SIZE.get()).intValue(), ((Number)CommonConfig.MIN_BEDROOM_SIZE_COMFORT.get()).intValue());
                }
                if (cap.getBedsCount() > ((Number)CommonConfig.BEDS_THRESHOLD.get()).intValue()) {
                    comfort += (cap.getBedsCount() - ((Number)CommonConfig.BEDS_THRESHOLD.get()).intValue()) * ((Number)CommonConfig.COMFORT_PER_BED.get()).intValue();
                }
                if (cap.getBedroomLight() > ((Number)CommonConfig.BEDROOM_LIGHT_AVERAGE.get()).intValue()) {
                    comfort += (cap.getBedroomLight() - ((Number)CommonConfig.BEDROOM_LIGHT_AVERAGE.get()).intValue()) * ((Number)CommonConfig.COMFORT_PER_MORE_BEDROOM_LIGHT.get()).intValue();
                } else if (cap.getBedroomLight() < ((Number)CommonConfig.BEDROOM_LIGHT_AVERAGE.get()).intValue()) {
                    comfort += (((Number)CommonConfig.BEDROOM_LIGHT_AVERAGE.get()).intValue() - cap.getBedroomLight()) * ((Number)CommonConfig.COMFORT_PER_LESS_BEDROOM_LIGHT.get()).intValue();
                }
                if (cap.getIsWorkstationInBedroom()) {
                    comfort += ((Number)CommonConfig.WORKSTATION_IN_BEDROOM_COMFORT.get()).intValue();
                }
            }
            if (cap.hasWorkplace()) {
                if (cap.getWorkplaceSize() >= ((Number)CommonConfig.MAX_WORKPLACE_SIZE.get()).intValue()) {
                    comfort += ((Number)CommonConfig.MAX_WORKPLACE_SIZE_COMFORT.get()).intValue();
                } else if (cap.getWorkplaceSize() > ((Number)CommonConfig.AVERAGE_WORKPLACE_SIZE.get()).intValue()) {
                    comfort += MathHelper.scale(cap.getWorkplaceSize() - ((Number)CommonConfig.AVERAGE_WORKPLACE_SIZE.get()).intValue(), ((Number)CommonConfig.MAX_WORKPLACE_SIZE.get()).intValue() - ((Number)CommonConfig.AVERAGE_WORKPLACE_SIZE.get()).intValue(), ((Number)CommonConfig.MAX_WORKPLACE_SIZE_COMFORT.get()).intValue());
                } else if (cap.getWorkplaceSize() < ((Number)CommonConfig.AVERAGE_WORKPLACE_SIZE.get()).intValue()) {
                    comfort += MathHelper.scale(((Number)CommonConfig.AVERAGE_WORKPLACE_SIZE.get()).intValue() - cap.getWorkplaceSize(), ((Number)CommonConfig.AVERAGE_WORKPLACE_SIZE.get()).intValue(), ((Number)CommonConfig.MIN_WORKPLACE_SIZE_COMFORT.get()).intValue());
                }
                if (cap.getWorkstationsCount() > ((Number)CommonConfig.WORKSTATIONS_THRESHOLD.get()).intValue()) {
                    comfort += (cap.getWorkstationsCount() - ((Number)CommonConfig.WORKSTATIONS_THRESHOLD.get()).intValue()) * ((Number)CommonConfig.COMFORT_PER_WORKSTATION.get()).intValue();
                }
                if (cap.getWorkplaceLight() > ((Number)CommonConfig.WORKPLACE_LIGHT_AVERAGE.get()).intValue()) {
                    comfort += (cap.getWorkplaceLight() - ((Number)CommonConfig.WORKPLACE_LIGHT_AVERAGE.get()).intValue()) * ((Number)CommonConfig.COMFORT_PER_MORE_WORKPLACE_LIGHT.get()).intValue();
                } else if (cap.getWorkplaceLight() < ((Number)CommonConfig.WORKPLACE_LIGHT_AVERAGE.get()).intValue()) {
                    comfort += (((Number)CommonConfig.WORKPLACE_LIGHT_AVERAGE.get()).intValue() - cap.getWorkplaceLight()) * ((Number)CommonConfig.COMFORT_PER_LESS_WORKPLACE_LIGHT.get()).intValue();
                }
            }
            if (cap.hasBed() && cap.hasWorkplace()) {
                if (cap.getBedWorkstationDistance() > ((Number)CommonConfig.MAX_BED_WORKPLACE_DISTANCE.get()).intValue()) {
                    comfort += ((Number)CommonConfig.MAX_BED_WORKPLACE_DISTANCE.get()).intValue() - ((Number)CommonConfig.AVERAGE_DISTANCE_BED_WORKPLACE.get()).intValue() * ((Number)CommonConfig.COMFORT_PER_MORE_BED_WORKPLACE_DISTANCE.get()).intValue();
                } else if (cap.getBedWorkstationDistance() > ((Number)CommonConfig.AVERAGE_DISTANCE_BED_WORKPLACE.get()).intValue()) {
                    comfort += cap.getBedWorkstationDistance() - ((Number)CommonConfig.AVERAGE_DISTANCE_BED_WORKPLACE.get()).intValue() * ((Number)CommonConfig.COMFORT_PER_MORE_BED_WORKPLACE_DISTANCE.get()).intValue();
                } else if (cap.getBedWorkstationDistance() < ((Number)CommonConfig.AVERAGE_DISTANCE_BED_WORKPLACE.get()).intValue()) {
                    comfort += ((Number)CommonConfig.AVERAGE_DISTANCE_BED_WORKPLACE.get()).intValue() - cap.getBedWorkstationDistance() * ((Number)CommonConfig.COMFORT_PER_LESS_BED_WORKPLACE_DISTANCE.get()).intValue();
                }
            }
            if (cap.getDaysWithoutOutside() > 0) {
                comfort += cap.getDaysWithoutOutside() * ((Number)CommonConfig.COMFORT_PER_DAY_WITHOUT_OUTSIDE.get()).intValue();
            }
            if (cap.getDaysWithoutZombie() > ((Number)CommonConfig.MAX_DAYS_WITHOUT_ZOMBIE.get()).intValue()) {
                comfort += ((Number)CommonConfig.MAX_DAYS_WITHOUT_ZOMBIE.get()).intValue() * ((Number)CommonConfig.COMFORT_PER_DAY_WITHOUT_ZOMBIE.get()).intValue();
            } else if (cap.getDaysWithoutZombie() > 0) {
                comfort += cap.getDaysWithoutZombie() * ((Number)CommonConfig.COMFORT_PER_DAY_WITHOUT_ZOMBIE.get()).intValue();
            }
            if (villager.m_6274_().m_21952_(MemoryModuleType.f_26328_).orElse(0L) > 24000L) {
                comfort = (int)((long)comfort + villager.m_6274_().m_21952_(MemoryModuleType.f_26328_).orElse(0L) / 24000L * (long)((Number)CommonConfig.COMFORT_PER_DAY_WITHOUT_SLEEP.get()).intValue());
            }
            comfort = Mth.m_14045_((int)comfort, (int)-100, (int)100);
            cap.setComfort(comfort);
            return comfort;
        }
        return 0;
    }
}

