/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.item;

import com.google.common.collect.Lists;
import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Tweak(eventClass=ItemTooltipEvent.class, category="item")
public class DurabilityTooltipTweak
extends VTweak {
    private final ArrayList<ChatFormatting> ColorByIndex = Lists.newArrayList((Object[])new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.RED, ChatFormatting.GOLD, ChatFormatting.YELLOW, ChatFormatting.GREEN, ChatFormatting.DARK_GREEN, ChatFormatting.DARK_AQUA, ChatFormatting.BLUE, ChatFormatting.DARK_PURPLE, ChatFormatting.LIGHT_PURPLE});
    private ForgeConfigSpec.EnumValue<TooltipSetting> setting;

    @Override
    public void registerConfigs(ForgeConfigSpec.Builder builder) {
        this.setting = builder.comment("Show tool durability on item hover").defineEnum("durabilityTooltipSetting", (Enum)TooltipSetting.WITH_SHIFT);
    }

    @SubscribeEvent
    public void process(ItemTooltipEvent evt) {
        if (this.setting.get() == TooltipSetting.NEVER) {
            return;
        }
        ItemStack stack = evt.getItemStack();
        boolean shifting = Screen.m_96638_();
        if (!stack.m_41763_()) {
            return;
        }
        if (this.setting.get() == TooltipSetting.WITH_SHIFT && !shifting) {
            return;
        }
        evt.getToolTip().add(this.getDurabilityString(stack));
    }

    private MutableComponent getDurabilityString(ItemStack itemstack) {
        String ret = "Durability: ";
        MutableComponent c = Component.m_237119_();
        int max = itemstack.m_41776_();
        int damage = itemstack.m_41773_();
        float percentage = 1.0f - (float)damage / (float)max;
        int scaled = Math.max(Math.min(Math.round(percentage * 10.0f) - 1, 9), 0);
        return c.m_130946_(ret + this.ColorByIndex.get(scaled) + (max - damage) + "/" + max + ChatFormatting.RESET);
    }

    public static enum TooltipSetting {
        NEVER,
        WITH_SHIFT,
        ALWAYS;

    }
}

