/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.entity;

import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Tweak(eventClass=AttackEntityEvent.class, category="entity")
public class PetFriendlyFireTweak
extends VTweak {
    private ForgeConfigSpec.EnumValue<FFSetting> setting;

    @Override
    public void registerConfigs(ForgeConfigSpec.Builder builder) {
        this.setting = builder.comment("If set to \"OWNER\", this will prevent owners of pets from attacking their own pet. If set to \"ALL\", this prevents all players from attacking anyone's pet").defineEnum("enablePetFriendlyFireTweak", (Enum)FFSetting.OWNER);
    }

    @SubscribeEvent
    public void process(AttackEntityEvent evt) {
        boolean applyToAny;
        if (this.setting.get() == FFSetting.DISABLED) {
            return;
        }
        if (evt.getTarget() == null) {
            return;
        }
        if (evt.getEntity() == null) {
            return;
        }
        Entity entity = evt.getTarget();
        if (!(entity instanceof TamableAnimal)) {
            return;
        }
        TamableAnimal pet = (TamableAnimal)entity;
        if (!pet.m_21824_()) {
            return;
        }
        boolean bl = applyToAny = this.setting.get() == FFSetting.ALL;
        if ((applyToAny || pet.m_21826_() == evt.getEntity()) && evt.isCancelable()) {
            evt.setCanceled(true);
        }
    }

    public static enum FFSetting {
        DISABLED,
        OWNER,
        ALL;

    }
}

