/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.entity;

import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Tweak(eventClass=LivingSpawnEvent.CheckSpawn.class, category="entity")
public class PeacefulSurfaceTweak
extends VTweak {
    private ForgeConfigSpec.BooleanValue enabled;
    private ForgeConfigSpec.IntValue minY;
    public static final TagKey<EntityType<?>> BLACKLISTED_ENTITIES = TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)new ResourceLocation("vtweaks", "ignored_by_peaceful_surface"));
    public static final TagKey<DimensionType> BLACKLISTED_DIMENSIONS = TagKey.m_203882_((ResourceKey)Registry.f_122818_, (ResourceLocation)new ResourceLocation("vtweaks", "peaceful_surface_blacklist_dims"));

    @Override
    public void registerConfigs(ForgeConfigSpec.Builder builder) {
        this.enabled = builder.comment("Prevents mobs from spawning above sea level unless it's a new moon").define("enablePeacefulSurface", false);
        this.minY = builder.comment("The lowest Y-level which mobs will be prevented from spawning").defineInRange("peacefulSurfaceMinY", 60, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @SubscribeEvent
    public void process(LivingSpawnEvent.CheckSpawn evt) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        if (evt.getEntity() == null) {
            return;
        }
        if (evt.getSpawnReason() != MobSpawnType.NATURAL) {
            return;
        }
        if (!(evt.getEntity() instanceof Monster) || evt.getEntity().m_6095_().m_204039_(BLACKLISTED_ENTITIES)) {
            return;
        }
        LevelAccessor levelAccessor = evt.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        if (level.m_204156_().m_203656_(BLACKLISTED_DIMENSIONS)) {
            return;
        }
        int day = (int)(level.m_6106_().m_6792_() / 24000L % Integer.MAX_VALUE);
        if ((day % 4 != 0 || day % 8 == 0) && evt.getEntity().m_20186_() >= (double)((Integer)this.minY.get()).intValue()) {
            evt.setResult(Event.Result.DENY);
        }
    }
}

