/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.entity;

import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Tweak(eventClass=PlayerInteractEvent.EntityInteract.class, category="entity")
public class ItemFrameTweak
extends VTweak {
    public static final TagKey<Item> GLASS = ItemTags.create((ResourceLocation)new ResourceLocation("vtweaks", "clear_glass"));
    private ForgeConfigSpec.BooleanValue enabled;

    @Override
    public void registerConfigs(ForgeConfigSpec.Builder builder) {
        this.enabled = builder.comment("Allows any vtweaks:clear_glass, or glow ink sac, to be activated on an item frame while sneaking to make the item frame transparent or glowing respectively.").define("enableItemFrameTweak", true);
    }

    @SubscribeEvent
    public void process(PlayerInteractEvent.EntityInteract evt) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        if (evt.getTarget() == null || evt.getEntity() == null) {
            return;
        }
        Entity entity = evt.getTarget();
        if (!(entity instanceof ItemFrame)) {
            return;
        }
        ItemFrame frame = (ItemFrame)entity;
        Player player = evt.getEntity();
        if (!player.m_6047_()) {
            return;
        }
        if (player.m_21205_().m_204117_(GLASS)) {
            if (frame.m_20145_()) {
                return;
            }
            frame.m_6842_(true);
            player.m_5496_(SoundEvents.f_144244_, 1.0f, 1.0f);
        } else if (player.m_21205_().m_41720_() == Items.f_151056_) {
            if (frame instanceof GlowItemFrame) {
                return;
            }
            GlowItemFrame glowing = new GlowItemFrame(evt.getLevel(), frame.m_31748_(), frame.m_6350_());
            glowing.getPersistentData().m_128391_(frame.getPersistentData());
            glowing.m_31805_(frame.m_31822_());
            glowing.m_31770_(frame.m_31823_());
            glowing.m_6842_(frame.m_20145_());
            frame.m_31805_(ItemStack.f_41583_);
            frame.m_6074_();
            evt.getLevel().m_7967_((Entity)glowing);
            player.m_5496_(SoundEvents.f_144159_, 1.0f, 1.0f);
            player.m_21205_().m_41774_(1);
        } else {
            return;
        }
        player.m_6674_(evt.getHand());
        evt.setCanceled(true);
        evt.setResult(Event.Result.DENY);
        evt.setCancellationResult(InteractionResult.CONSUME);
    }
}

